/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.ackd;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.ackd.Readers;
import org.xml.sax.ContentHandler;

public class AckdConfiguration
implements Serializable {
    private boolean _alarmSync = true;
    private boolean _has_alarmSync;
    private String _ackExpression = "~^ack$";
    private String _unackExpression = "~^unack$";
    private String _escalateExpression = "~^esc$";
    private String _clearExpression = "~^(resolve|clear)$";
    private String _notifyidMatchExpression = "~.*Re:.*Notice #([0-9]+).*";
    private String _alarmidMatchExpression = "~.*Re:.*Alarm #([0-9]+).*";
    private Readers _readers;

    public AckdConfiguration() {
        this.setAckExpression("~^ack$");
        this.setUnackExpression("~^unack$");
        this.setEscalateExpression("~^esc$");
        this.setClearExpression("~^(resolve|clear)$");
        this.setNotifyidMatchExpression("~.*Re:.*Notice #([0-9]+).*");
        this.setAlarmidMatchExpression("~.*Re:.*Alarm #([0-9]+).*");
    }

    public void deleteAlarmSync() {
        this._has_alarmSync = false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AckdConfiguration) {
            AckdConfiguration temp = (AckdConfiguration)obj;
            if (this._alarmSync != temp._alarmSync) {
                return false;
            }
            if (this._has_alarmSync != temp._has_alarmSync) {
                return false;
            }
            if (this._ackExpression != null) {
                if (temp._ackExpression == null) {
                    return false;
                }
                if (!this._ackExpression.equals(temp._ackExpression)) {
                    return false;
                }
            } else if (temp._ackExpression != null) {
                return false;
            }
            if (this._unackExpression != null) {
                if (temp._unackExpression == null) {
                    return false;
                }
                if (!this._unackExpression.equals(temp._unackExpression)) {
                    return false;
                }
            } else if (temp._unackExpression != null) {
                return false;
            }
            if (this._escalateExpression != null) {
                if (temp._escalateExpression == null) {
                    return false;
                }
                if (!this._escalateExpression.equals(temp._escalateExpression)) {
                    return false;
                }
            } else if (temp._escalateExpression != null) {
                return false;
            }
            if (this._clearExpression != null) {
                if (temp._clearExpression == null) {
                    return false;
                }
                if (!this._clearExpression.equals(temp._clearExpression)) {
                    return false;
                }
            } else if (temp._clearExpression != null) {
                return false;
            }
            if (this._notifyidMatchExpression != null) {
                if (temp._notifyidMatchExpression == null) {
                    return false;
                }
                if (!this._notifyidMatchExpression.equals(temp._notifyidMatchExpression)) {
                    return false;
                }
            } else if (temp._notifyidMatchExpression != null) {
                return false;
            }
            if (this._alarmidMatchExpression != null) {
                if (temp._alarmidMatchExpression == null) {
                    return false;
                }
                if (!this._alarmidMatchExpression.equals(temp._alarmidMatchExpression)) {
                    return false;
                }
            } else if (temp._alarmidMatchExpression != null) {
                return false;
            }
            if (this._readers != null) {
                if (temp._readers == null) {
                    return false;
                }
                if (!this._readers.equals(temp._readers)) {
                    return false;
                }
            } else if (temp._readers != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public String getAckExpression() {
        return this._ackExpression;
    }

    public boolean getAlarmSync() {
        return this._alarmSync;
    }

    public String getAlarmidMatchExpression() {
        return this._alarmidMatchExpression;
    }

    public String getClearExpression() {
        return this._clearExpression;
    }

    public String getEscalateExpression() {
        return this._escalateExpression;
    }

    public String getNotifyidMatchExpression() {
        return this._notifyidMatchExpression;
    }

    public Readers getReaders() {
        return this._readers;
    }

    public String getUnackExpression() {
        return this._unackExpression;
    }

    public boolean hasAlarmSync() {
        return this._has_alarmSync;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this._alarmSync ? 0 : 1);
        if (this._ackExpression != null) {
            result = 37 * result + this._ackExpression.hashCode();
        }
        if (this._unackExpression != null) {
            result = 37 * result + this._unackExpression.hashCode();
        }
        if (this._escalateExpression != null) {
            result = 37 * result + this._escalateExpression.hashCode();
        }
        if (this._clearExpression != null) {
            result = 37 * result + this._clearExpression.hashCode();
        }
        if (this._notifyidMatchExpression != null) {
            result = 37 * result + this._notifyidMatchExpression.hashCode();
        }
        if (this._alarmidMatchExpression != null) {
            result = 37 * result + this._alarmidMatchExpression.hashCode();
        }
        if (this._readers != null) {
            result = 37 * result + this._readers.hashCode();
        }
        return result;
    }

    public boolean isAlarmSync() {
        return this._alarmSync;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void setAckExpression(String ackExpression) {
        this._ackExpression = ackExpression;
    }

    public void setAlarmSync(boolean alarmSync) {
        this._alarmSync = alarmSync;
        this._has_alarmSync = true;
    }

    public void setAlarmidMatchExpression(String alarmidMatchExpression) {
        this._alarmidMatchExpression = alarmidMatchExpression;
    }

    public void setClearExpression(String clearExpression) {
        this._clearExpression = clearExpression;
    }

    public void setEscalateExpression(String escalateExpression) {
        this._escalateExpression = escalateExpression;
    }

    public void setNotifyidMatchExpression(String notifyidMatchExpression) {
        this._notifyidMatchExpression = notifyidMatchExpression;
    }

    public void setReaders(Readers readers) {
        this._readers = readers;
    }

    public void setUnackExpression(String unackExpression) {
        this._unackExpression = unackExpression;
    }

    public static AckdConfiguration unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (AckdConfiguration)Unmarshaller.unmarshal(AckdConfiguration.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

