/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.server.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jradius.server.config.XMLConfiguration;
import org.apache.commons.configuration.HierarchicalConfiguration;

public abstract class ConfigurationItem {
    protected XMLConfiguration hcfg;
    protected HierarchicalConfiguration.Node root;
    protected String name;
    protected String description;
    protected String className;
    protected Map properties;

    public ConfigurationItem(String name) {
        this.name = name;
    }

    public ConfigurationItem(String name, String className) {
        this.name = name;
        this.className = className;
    }

    public ConfigurationItem(HierarchicalConfiguration.Node node, XMLConfiguration config) {
        HierarchicalConfiguration.Node pnode = config.getRoot();
        config.setRoot(node);
        this.hcfg = config;
        this.root = node;
        this.name = config.getConfigString("name");
        this.description = config.getConfigString("description");
        this.className = config.getConfigString("class");
        this.setProperties(config);
        config.setRoot(pnode);
    }

    protected void setProperties(XMLConfiguration config) {
        this.properties = ConfigurationItem.getPropertiesFromConfig(config, this.root);
    }

    public static HashMap getPropertiesFromConfig(XMLConfiguration config, HierarchicalConfiguration.Node root) {
        HashMap<String, String> map = new HashMap<String, String>();
        List list = root.getChildren("property");
        for (HierarchicalConfiguration.Node node : list) {
            config.setRoot(node);
            String name = config.getConfigString("name");
            String value = config.getConfigString("value");
            map.put(name, value);
        }
        return map;
    }

    public String getClassName() {
        return this.className;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public Map getProperties() {
        return this.properties;
    }

    public XMLConfiguration getXMLConfig() {
        return this.hcfg;
    }

    public HierarchicalConfiguration.Node getRoot() {
        return this.root;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public String xmlKey() {
        return "no such key";
    }

    public String toString() {
        return this.name + " [" + this.className + "]: " + this.description + " -- " + this.properties;
    }
}

