/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.server;

import com.sun.net.ssl.internal.ssl.Provider;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import net.jradius.exception.RadiusException;
import net.jradius.log.RadiusLog;
import net.jradius.server.JRadiusEvent;
import net.jradius.server.JRadiusThread;
import net.jradius.server.KeepAliveListener;
import net.jradius.server.Listener;
import net.jradius.server.ListenerRequest;
import net.jradius.server.TCPListenerRequest;
import net.jradius.server.config.ListenerConfigurationItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TCPListener
extends JRadiusThread
implements Listener {
    private boolean active = false;
    protected ListenerConfigurationItem config;
    protected BlockingQueue<ListenerRequest> queue;
    private int port = 1814;
    private int backlog = 1024;
    private boolean usingSSL = false;
    private boolean keepAlive;
    private ServerSocket serverSocket;
    private List<KeepAliveListener> keepAliveListeners = new LinkedList<KeepAliveListener>();

    @Override
    public abstract JRadiusEvent parseRequest(InputStream var1) throws IOException, RadiusException;

    @Override
    public void setConfiguration(ListenerConfigurationItem cfg) {
        try {
            this.setConfiguration(cfg, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setConfiguration(ListenerConfigurationItem cfg, boolean noKeepAlive) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException, IOException {
        this.keepAlive = !noKeepAlive;
        this.config = cfg;
        Map props = this.config.getProperties();
        String s = (String)props.get("port");
        if (s != null) {
            this.port = new Integer(s);
        }
        if ((s = (String)props.get("backlog")) != null) {
            this.backlog = new Integer(s);
        }
        if (this.keepAlive && (s = (String)props.get("keepAlive")) != null) {
            this.keepAlive = new Boolean(s);
        }
        String useSSL = (String)props.get("useSSL");
        String trustAll = (String)props.get("trustAll");
        if ("true".equalsIgnoreCase(useSSL)) {
            Security.addProvider((java.security.Provider)new Provider());
            KeyManager[] keyManagers = null;
            TrustManager[] trustManagers = null;
            String keystore = (String)props.get("keyStore");
            String keystoreType = (String)props.get("keyStoreType");
            String keystorePassword = (String)props.get("keyStorePassword");
            String keyPassword = (String)props.get("keyPassword");
            if (keystore != null) {
                if (keystoreType == null) {
                    keystoreType = "pkcs12";
                }
                KeyStore ks = KeyStore.getInstance(keystoreType);
                ks.load(new FileInputStream(keystore), keystorePassword == null ? null : keystorePassword.toCharArray());
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                kmf.init(ks, keyPassword == null ? null : keyPassword.toCharArray());
                keyManagers = kmf.getKeyManagers();
            }
            if ("true".equalsIgnoreCase(trustAll)) {
                trustManagers = new TrustManager[]{new X509TrustManager(){

                    public void checkClientTrusted(X509Certificate[] chain, String authType) {
                    }

                    public void checkServerTrusted(X509Certificate[] chain, String authType) {
                    }

                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }};
            } else {
                keystore = (String)props.get("caStore");
                keystoreType = (String)props.get("caStoreType");
                keystorePassword = (String)props.get("caStorePassword");
                if (keystore != null) {
                    if (keystoreType == null) {
                        keystoreType = "pkcs12";
                    }
                    KeyStore caKeys = KeyStore.getInstance(keystoreType);
                    caKeys.load(new FileInputStream(keystore), keystorePassword == null ? null : keystorePassword.toCharArray());
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                    tmf.init(caKeys);
                    trustManagers = tmf.getTrustManagers();
                }
            }
            SSLContext sslContext = SSLContext.getInstance("SSLv3");
            sslContext.init(keyManagers, trustManagers, null);
            SSLServerSocketFactory socketFactory = sslContext.getServerSocketFactory();
            this.serverSocket = socketFactory.createServerSocket(this.port, this.backlog);
            this.usingSSL = true;
        } else {
            this.serverSocket = new ServerSocket(this.port, this.backlog);
        }
        this.serverSocket.setReuseAddress(true);
        this.setActive(this.serverSocket != null);
    }

    @Override
    public void setRequestQueue(BlockingQueue<ListenerRequest> q) {
        this.queue = q;
    }

    public void setListenerConfigurationItem(ListenerConfigurationItem cfg) {
        this.config = cfg;
        this.setName(this.config.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listen() throws IOException, InterruptedException, RadiusException {
        RadiusLog.debug("Listening on socket...");
        Socket socket = this.serverSocket.accept();
        if (this.keepAlive) {
            KeepAliveListener keepAliveListener = new KeepAliveListener(socket, this, this.queue);
            keepAliveListener.start();
            List<KeepAliveListener> list = this.keepAliveListeners;
            synchronized (list) {
                this.keepAliveListeners.add(keepAliveListener);
            }
        } else {
            this.queue.put(new TCPListenerRequest(socket, this, false));
        }
    }

    public void deadKeepAliveListener(KeepAliveListener keepAliveListener) {
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (!active) {
            for (KeepAliveListener listener : this.keepAliveListeners) {
                try {
                    listener.shutdown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (KeepAliveListener listener : this.keepAliveListeners) {
                try {
                    listener.interrupt();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.keepAliveListeners.clear();
            try {
                this.serverSocket.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.interrupt();
        }
    }

    @Override
    public void run() {
        while (this.isActive()) {
            try {
                Thread.yield();
                this.listen();
            }
            catch (Throwable e) {
                System.err.println("The Listener's listen() method threw an exception: " + e);
                RadiusLog.error(e.getMessage());
                e.printStackTrace();
            }
        }
        RadiusLog.error("Listener: " + this.getClass().getName() + " exiting (not active)");
    }

    public boolean isUsingSSL() {
        return this.usingSSL;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUsingSSL(boolean usingSSL) {
        this.usingSSL = usingSSL;
    }
}

