/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.server;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.jradius.handler.chain.JRCommand;
import net.jradius.log.RadiusLog;
import net.jradius.server.JRadiusEvent;
import net.jradius.server.JRadiusThread;
import net.jradius.server.event.ServerEvent;
import net.jradius.session.JRadiusSession;
import net.jradius.session.JRadiusSessionManager;
import org.apache.commons.chain.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDispatcher
extends JRadiusThread {
    private BlockingQueue<JRadiusEvent> eventQueue = new LinkedBlockingQueue<JRadiusEvent>();
    private List<JRCommand> eventHandlers = new LinkedList<JRCommand>();

    public void post(JRadiusEvent event) {
        try {
            this.eventQueue.put(event);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.yield();
                    this.dispatchEvent();
                }
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Throwable e) {
                RadiusLog.error(e.getMessage());
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent() throws InterruptedException {
        JRadiusEvent event = this.eventQueue.take();
        if (event != null) {
            JRadiusSessionManager sessionManager = JRadiusSessionManager.getManager(event.getSender());
            JRadiusSession session = null;
            if (event instanceof ServerEvent) {
                session = ((ServerEvent)event).getRequest().getSession();
            }
            if (session != null) {
                sessionManager.lock(session);
            }
            try {
                for (JRCommand command : this.eventHandlers) {
                    try {
                        if (!command.doesHandle(event) || !command.execute((Context)event)) continue;
                        break;
                    }
                    catch (Throwable e) {
                        RadiusLog.error("Event handler " + command.getName() + " threw an exception:" + e);
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (session != null) {
                    sessionManager.unlock(session);
                }
            }
        }
    }

    public List<JRCommand> getEventHandlers() {
        return this.eventHandlers;
    }

    public void setEventHandlers(List<JRCommand> eventHandlers) {
        this.eventHandlers = eventHandlers;
    }
}

