/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.DetectFuture;
import org.opennms.netmgt.provision.support.AsyncClientConversation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseDetectorHandler<Request, Response>
extends IoHandlerAdapter {
    private DetectFuture m_future;
    private AsyncClientConversation<Request, Response> m_conversation;

    public void setFuture(DetectFuture future) {
        this.m_future = future;
    }

    public DetectFuture getFuture() {
        return this.m_future;
    }

    public void sessionCreated(IoSession session) throws Exception {
    }

    public void sessionOpened(IoSession session) throws Exception {
        if (!this.getConversation().hasBanner() && this.getConversation().getRequest() != null) {
            Request request = this.getConversation().getRequest();
            session.write(request);
        }
    }

    public void sessionClosed(IoSession session) throws Exception {
        if (!this.getFuture().isDone()) {
            this.getFuture().setServiceDetected(false);
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        if (this.getConversation().hasBanner() && status == IdleStatus.READER_IDLE) {
            this.getFuture().setServiceDetected(false);
            session.close(true);
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        LogUtils.debugf((Object)((Object)this), (Throwable)cause, (String)"Caught a Throwable in BaseDetectorHandler", (Object[])new Object[0]);
        this.getFuture().setException(cause);
        session.close(true);
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        block8: {
            try {
                LogUtils.debugf((Object)((Object)this), (String)"Client Receiving: %s\n", (Object[])new Object[]{message.toString().trim()});
                if (this.getConversation().hasExchanges() && this.getConversation().validate(message)) {
                    Request request = this.getConversation().getRequest();
                    if (request != null) {
                        session.write(request);
                    } else if (request == null && this.getConversation().isComplete()) {
                        this.getFuture().setServiceDetected(true);
                        session.close(false);
                    } else {
                        this.getFuture().setServiceDetected(false);
                        session.close(false);
                    }
                } else {
                    this.getFuture().setServiceDetected(false);
                    session.close(false);
                }
            }
            catch (Exception e) {
                if (session.isClosing()) break block8;
                session.close(true);
            }
        }
    }

    public void messageSent(IoSession session, Object message) throws Exception {
    }

    public void setConversation(AsyncClientConversation<Request, Response> conversation) {
        this.m_conversation = conversation;
    }

    public AsyncClientConversation<Request, Response> getConversation() {
        return this.m_conversation;
    }
}

