/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vulnscand;

import java.net.InetAddress;
import java.sql.Timestamp;
import java.util.Date;
import org.opennms.netmgt.config.VulnscandConfigFactory;
import org.opennms.netmgt.vulnscand.NessusScan;
import org.opennms.netmgt.vulnscand.ScheduleTrigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NessusScanConfiguration
implements ScheduleTrigger<Runnable> {
    public String username;
    public String password;
    public InetAddress hostname;
    public int hostport;
    public InetAddress targetAddress;
    public int scanLevel;
    Timestamp lastScan;
    long interval;
    boolean scheduled;

    NessusScanConfiguration(InetAddress address, int newScanLevel, Timestamp newLastScan, long newInterval) {
        this.targetAddress = address;
        this.scanLevel = newScanLevel;
        this.lastScan = newLastScan;
        this.interval = newInterval;
        this.init();
    }

    NessusScanConfiguration(InetAddress address, int newScanLevel, Date newLastScan, long newInterval) {
        this.targetAddress = address;
        this.scanLevel = newScanLevel;
        this.lastScan = new Timestamp(newLastScan.getTime());
        this.interval = newInterval;
        this.init();
    }

    private void init() {
        VulnscandConfigFactory config = VulnscandConfigFactory.getInstance();
        this.scheduled = false;
        this.hostname = config.getServerAddress();
        this.hostport = config.getServerPort();
        this.username = config.getServerUsername();
        this.password = config.getServerPassword();
    }

    @Override
    public boolean isScheduled() {
        return this.scheduled;
    }

    InetAddress getAddress() {
        return this.targetAddress;
    }

    Timestamp getLastScanned() {
        return this.lastScan;
    }

    long getRescanInterval() {
        return this.interval;
    }

    @Override
    public void setScheduled(boolean newScheduled) {
        this.scheduled = newScheduled;
    }

    void setLastScanned(Date newLastScan) {
        this.lastScan = new Timestamp(newLastScan.getTime());
    }

    void setLastScanned(Timestamp newLastScan) {
        this.lastScan = newLastScan;
    }

    @Override
    public boolean isTimeForRescan() {
        return System.currentTimeMillis() >= this.lastScan.getTime() + this.interval;
    }

    public boolean isValid() {
        boolean retval = this.hostname != null && this.username != null && this.username != "" && this.password != null && this.password != "" && this.scanLevel > 0 && this.scanLevel < 5 && this.targetAddress != null && this.hostport > 0 && this.hostport < 65536;
        return retval;
    }

    @Override
    public Runnable getJob() {
        return new NessusScan(this);
    }

    public String toString() {
        return this.getAddress().toString();
    }
}

