/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.tl1d;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jfree.util.Log;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.netmgt.config.tl1d.Tl1Element;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.dao.Tl1ConfigurationDao;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventForwarder;
import org.opennms.netmgt.model.events.annotations.EventHandler;
import org.opennms.netmgt.model.events.annotations.EventListener;
import org.opennms.netmgt.tl1d.Tl1AutonomousMessage;
import org.opennms.netmgt.tl1d.Tl1AutonomousMessageProcessor;
import org.opennms.netmgt.tl1d.Tl1Client;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.springframework.beans.factory.InitializingBean;

@EventListener(name="OpenNMS:Tl1d")
public class Tl1d
extends AbstractServiceDaemon
implements PausableFiber,
InitializingBean {
    private volatile int m_status = 0;
    private volatile Thread m_tl1MesssageProcessor;
    private volatile EventForwarder m_eventForwarder;
    private volatile Tl1ConfigurationDao m_configurationDao;
    private final BlockingQueue<Tl1AutonomousMessage> m_tl1Queue = new LinkedBlockingQueue<Tl1AutonomousMessage>();
    private final List<Tl1Client> m_tl1Clients = new ArrayList<Tl1Client>();

    public Tl1d() {
        super("OpenNMS.Tl1d");
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleRelooadConfigurationEvent(Event e) {
        if (this.isReloadConfigEventTarget(e)) {
            EventBuilder ebldr = null;
            try {
                this.stopListeners();
                this.removeClients();
                this.m_configurationDao.update();
                this.initializeTl1Connections();
                this.startClients();
                this.log().debug("handleReloadConfigurationEvent: " + this.m_tl1Clients.size() + " defined.");
                this.log().info("handleReloadConfigurationEvent: completed.");
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", this.getName());
                ebldr.addParam("daemonName", "Tl1d");
            }
            catch (Exception exception) {
                this.log().error("handleReloadConfigurationEvent: failed.", (Throwable)exception);
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", this.getName());
                ebldr.addParam("daemonName", "Tl1d");
                ebldr.addParam("reason", exception.getLocalizedMessage().substring(1, 128));
            }
            if (ebldr != null) {
                this.m_eventForwarder.sendNow(ebldr.getEvent());
            }
        }
    }

    private boolean isReloadConfigEventTarget(Event event) {
        boolean isTarget = false;
        List parmCollection = event.getParms().getParmCollection();
        for (Parm parm : parmCollection) {
            if (!"daemonName".equals(parm.getParmName()) || !"Tl1d".equalsIgnoreCase(parm.getValue().getContent())) continue;
            isTarget = true;
            break;
        }
        this.log().debug("isReloadConfigEventTarget: Tl1d was target of reload event: " + isTarget);
        return isTarget;
    }

    public synchronized void onInit() {
        this.initializeTl1Connections();
    }

    public synchronized void onStart() {
        this.log().info("onStart: Initializing Tl1d message processing.");
        this.m_tl1MesssageProcessor = new Thread("Tl1-Message-Processor"){

            public void run() {
                Tl1d.this.doMessageProcessing();
            }
        };
        this.log().info("onStart: starting message processing thread...");
        this.m_tl1MesssageProcessor.start();
        this.log().info("onStart: message processing thread started.");
        this.startClients();
        this.log().info("onStart: Finished Initializing Tl1d connections.");
    }

    private void startClients() {
        this.log().info("startClients: starting clients...");
        for (Tl1Client client : this.m_tl1Clients) {
            this.log().debug("startClients: starting client: " + client);
            client.start();
            this.log().debug("startClients: started client.");
        }
        this.log().info("startClients: clients started.");
    }

    public synchronized void onStop() {
        this.stopListeners();
        this.m_tl1MesssageProcessor.interrupt();
        this.removeClients();
    }

    private void removeClients() {
        this.log().info("removeClients: removing current set of defined TL1 clients...");
        Iterator<Tl1Client> it = this.m_tl1Clients.iterator();
        while (it.hasNext()) {
            Tl1Client client = it.next();
            this.log().debug("removeClients: removing client: " + client);
            client = null;
            it.remove();
        }
        this.log().info("removeClients: all clients removed.");
    }

    private void stopListeners() {
        this.log().info("stopListeners: calling stop on all clients...");
        for (Tl1Client client : this.m_tl1Clients) {
            this.log().debug("stopListeners: calling stop on client: " + client);
            client.stop();
        }
        this.log().info("stopListeners: clients stopped.");
    }

    private void initializeTl1Connections() {
        this.log().info("onInit: Initializing Tl1d connections...");
        List configElements = this.m_configurationDao.getElements();
        for (Tl1Element element : configElements) {
            try {
                Tl1Client client = (Tl1Client)Class.forName(element.getTl1ClientApi()).newInstance();
                this.log().debug("initializeTl1Connections: initializing client: " + client);
                client.setHost(element.getHost());
                client.setPort(element.getPort());
                client.setTl1Queue(this.m_tl1Queue);
                client.setMessageProcessor((Tl1AutonomousMessageProcessor)Class.forName(element.getTl1MessageParser()).newInstance());
                client.setLog(this.log());
                client.setReconnectionDelay(element.getReconnectDelay());
                this.m_tl1Clients.add(client);
                this.log().debug("initializeTl1Connections: client initialized.");
            }
            catch (InstantiationException e) {
                this.log().error("onInit: could not instantiate specified class.", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.log().error("onInit: could not access specified class.", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                this.log().error("onInit: could not find specified class.", (Throwable)e);
            }
        }
        this.log().info("onInit: Finished Initializing Tl1d connections.");
    }

    private void processMessage(Tl1AutonomousMessage message) {
        this.log().debug("processMessage: Processing message: " + message);
        EventBuilder bldr = new EventBuilder("uei.opennms.org/api/tl1d/message/autonomous", "Tl1d");
        bldr.setHost(message.getHost());
        bldr.setInterface(message.getHost());
        bldr.setService("TL-1");
        bldr.setSeverity(message.getId().getHighestSeverity());
        bldr.setTime(message.getTimestamp());
        bldr.addParam("raw-message", message.getRawMessage());
        bldr.addParam("alarm-code", message.getId().getAlarmCode());
        bldr.addParam("atag", message.getId().getAlarmTag());
        bldr.addParam("verb", message.getId().getVerb());
        bldr.addParam("autoblock", message.getAutoBlock().getBlock());
        bldr.addParam("aid", message.getAutoBlock().getAid());
        bldr.addParam("additionalParams", message.getAutoBlock().getAdditionalParams());
        this.m_eventForwarder.sendNow(bldr.getEvent());
        this.log().debug("processMessage: Message processed: " + message);
    }

    public synchronized int getStatus() {
        return this.m_status;
    }

    private void doMessageProcessing() {
        this.log().debug("doMessageProcessing: Processing messages.");
        boolean cont = true;
        while (cont) {
            try {
                this.log().debug("doMessageProcessing: taking message from queue..");
                Tl1AutonomousMessage message = this.m_tl1Queue.take();
                this.log().debug("doMessageProcessing: message taken: " + message);
                this.processMessage(message);
            }
            catch (InterruptedException e) {
                Log.warn((Object)("doMessageProcessing: received interrupt: " + e), (Exception)e);
            }
        }
        this.log().debug("doMessageProcessing: Exiting processing messages.");
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public void setConfigurationDao(Tl1ConfigurationDao configurationDao) {
        this.m_configurationDao = configurationDao;
    }
}

