/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.collectd.CollectionAttribute;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.poller.LatencyCollectionAttribute;
import org.opennms.netmgt.poller.LatencyCollectionResource;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.ThresholdEntity;
import org.opennms.netmgt.threshd.ThresholdingSet;
import org.opennms.netmgt.xml.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatencyThresholdingSet
extends ThresholdingSet {
    public LatencyThresholdingSet(int nodeId, String hostAddress, String serviceName, RrdRepository repository) {
        super(nodeId, hostAddress, serviceName, repository);
    }

    public boolean hasThresholds(Map<String, Double> attributes) {
        if (this.hasThresholds()) {
            for (String ds : attributes.keySet()) {
                if (!this.hasThresholds("if", ds)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Event> applyThresholds(String svcName, Map<String, Double> attributes) {
        LatencyCollectionResource latencyResource = new LatencyCollectionResource(svcName, this.m_hostAddress);
        HashMap<String, CollectionAttribute> attributesMap = new HashMap<String, CollectionAttribute>();
        for (String ds : attributes.keySet()) {
            attributesMap.put(ds, new LatencyCollectionAttribute(latencyResource, ds, attributes.get(ds)));
        }
        CollectionResourceWrapper resourceWrapper = new CollectionResourceWrapper(new Date(), this.m_nodeId, this.m_hostAddress, this.m_serviceName, this.m_repository, latencyResource, attributesMap);
        return this.applyThresholds(resourceWrapper, attributesMap);
    }

    @Override
    protected boolean passedThresholdFilters(CollectionResourceWrapper resource, ThresholdEntity thresholdEntity) {
        return true;
    }
}

