/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.config.threshd.Basethresholddef;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.LatencyInterface;
import org.opennms.netmgt.threshd.LatencyParameters;
import org.opennms.netmgt.threshd.ServiceThresholder;
import org.opennms.netmgt.threshd.ThresholdEntity;
import org.opennms.netmgt.threshd.ThresholdExpressionException;
import org.opennms.netmgt.threshd.ThresholdNetworkInterface;
import org.opennms.netmgt.threshd.ThresholdingException;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LatencyThresholder
implements ServiceThresholder {
    private static final String SQL_GET_NODEID = "SELECT nodeid FROM ipinterface WHERE ipAddr=? AND ismanaged!='D'";
    static final int DEFAULT_INTERVAL = 300000;
    static final int DEFAULT_RANGE = 0;
    static final String RRD_REPOSITORY_KEY = "org.opennms.netmgt.collectd.LatencyThresholder.RrdRepository";
    static final String THRESHOLD_MAP_KEY = "org.opennms.netmgt.collectd.LatencyThresholder.ThresholdMap";
    static final String NODE_ID_KEY = "org.opennms.netmgt.collectd.SnmpThresholder.NodeId";
    private String m_svcName;
    private String m_host;

    LatencyThresholder() {
    }

    public String serviceName() {
        return this.m_svcName;
    }

    @Override
    public void initialize(Map parameters) {
        this.m_svcName = (String)parameters.get("svcName");
        if (this.log().isDebugEnabled()) {
            this.log().debug("initialize: latency thresholder for service '" + this.m_svcName + "'");
        }
        try {
            this.m_host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            if (this.log().isEnabledFor(ThreadCategory.Level.WARN)) {
                this.log().warn("initialize: Unable to resolve local host name.", (Throwable)e);
            }
            this.m_host = "unresolved.host";
        }
    }

    @Override
    public void reinitialize() {
    }

    @Override
    public void release() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(ThresholdNetworkInterface iface, Map parameters) {
        if (iface.getType() != 1) {
            throw new RuntimeException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        InetAddress ipAddr = (InetAddress)iface.getAddress();
        String groupName = ParameterMap.getKeyedString((Map)parameters, (String)"thresholding-group", (String)"default");
        String repository = null;
        try {
            repository = ThresholdingConfigFactory.getInstance().getRrdRepository(groupName);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Thresholding group '" + groupName + "' does not exist.");
        }
        iface.setAttribute(RRD_REPOSITORY_KEY, repository);
        Connection dbConn = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            dbConn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)dbConn);
        }
        catch (SQLException sqlE) {
            if (this.log().isEnabledFor(ThreadCategory.Level.ERROR)) {
                this.log().error("initialize: Failed getting connection to the database.", (Throwable)sqlE);
            }
            throw new UndeclaredThrowableException(sqlE);
        }
        int nodeId = -1;
        try {
            PreparedStatement stmt = null;
            try {
                stmt = dbConn.prepareStatement(SQL_GET_NODEID);
                d.watch((Object)stmt);
                stmt.setString(1, ipAddr.getHostAddress());
                ResultSet rs = stmt.executeQuery();
                d.watch((Object)rs);
                if (rs.next()) {
                    nodeId = rs.getInt(1);
                    if (rs.wasNull()) {
                        nodeId = -1;
                    }
                }
            }
            catch (SQLException sqle) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("initialize: SQL exception!!", (Throwable)sqle);
                }
                throw new RuntimeException("SQL exception while attempting to retrieve node id for interface " + ipAddr.getHostAddress());
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("initialize: db retrieval info: nodeid = " + nodeId + ", address = " + ipAddr.getHostAddress());
            }
            if (nodeId == -1) {
                throw new RuntimeException("Unable to retrieve node id for interface " + ipAddr.getHostAddress());
            }
        }
        finally {
            d.cleanUp();
        }
        iface.setAttribute(NODE_ID_KEY, new Integer(nodeId));
        HashMap<String, ThresholdEntity> thresholdMap = new HashMap<String, ThresholdEntity>();
        try {
            for (Basethresholddef thresh : ThresholdingConfigFactory.getInstance().getThresholds(groupName)) {
                boolean newEntity = false;
                ThresholdEntity thresholdEntity = null;
                if (!thresh.getDsType().equals("if") && !thresh.getDsType().equals("expr")) {
                    this.log().warn("initialize: invalid datasource type, latency thresholder only supports interface level datasources.");
                    continue;
                }
                try {
                    BaseThresholdDefConfigWrapper wrapper = BaseThresholdDefConfigWrapper.getConfigWrapper(thresh);
                    thresholdEntity = (ThresholdEntity)thresholdMap.get(wrapper.getDatasourceExpression());
                    if (thresholdEntity == null) {
                        newEntity = true;
                        thresholdEntity = new ThresholdEntity();
                    }
                    try {
                        thresholdEntity.addThreshold(wrapper);
                    }
                    catch (IllegalStateException e) {
                        this.log().warn("Encountered duplicate " + thresh.getType() + " for datasource " + wrapper.getDatasourceExpression() + ": " + e, (Throwable)e);
                    }
                    if (!newEntity) continue;
                    thresholdMap.put(wrapper.getDatasourceExpression(), thresholdEntity);
                }
                catch (ThresholdExpressionException e) {
                    this.log().warn("Could not parse threshold expression: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Thresholding group '" + groupName + "' does not exist.");
        }
        iface.setAttribute(THRESHOLD_MAP_KEY, thresholdMap);
        if (this.log().isDebugEnabled()) {
            this.log().debug("initialize: dumping interface thresholds defined for " + ipAddr.getHostAddress() + "/" + groupName + ":");
            Iterator iter = thresholdMap.values().iterator();
            while (iter.hasNext()) {
                this.log().debug(((ThresholdEntity)iter.next()).toString());
            }
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug("initialize: initialization completed for " + ipAddr.getHostAddress());
        }
    }

    @Override
    public void release(ThresholdNetworkInterface iface) {
    }

    @Override
    public int check(ThresholdNetworkInterface iface, EventProxy eproxy, Map parameters) {
        LatencyInterface latIface = new LatencyInterface(iface, this.m_svcName);
        LatencyParameters latParms = new LatencyParameters(parameters, this.m_svcName);
        try {
            if (this.log().isDebugEnabled()) {
                this.log().debug("check: service= " + this.m_svcName + " interface= " + latIface.getHostName() + " nodeId= " + latIface.getNodeId() + " thresholding-group=" + latParms.getGroupName() + " interval=" + latParms.getInterval() + "ms");
            }
            Events events = this.checkRrdDir(latIface, latParms);
            this.sendEvents(eproxy, events);
            return 1;
        }
        catch (ThresholdingException e) {
            this.log().error(e.getMessage());
            return e.getFailureCode();
        }
        catch (EventProxyException e) {
            this.log().error("check: Failed sending threshold events via event proxy...", (Throwable)e);
            return 2;
        }
    }

    private void sendEvents(EventProxy eproxy, Events events) throws EventProxyException {
        if (events != null && events.getEventCount() > 0) {
            Log eventLog = new Log();
            eventLog.setEvents(events);
            eproxy.send(eventLog);
        }
    }

    Events checkRrdDir(LatencyInterface latIface, LatencyParameters latParms) throws IllegalArgumentException, ThresholdingException {
        Map thresholdMap = latIface.getThresholdMap();
        if (latIface.getInetAddress() == null || thresholdMap == null) {
            throw new ThresholdingException("check: Threshold checking failed for " + this.m_svcName + "/" + latIface.getHostName(), 2);
        }
        Events events = new Events();
        Date date = new Date();
        for (String datasource : thresholdMap.keySet()) {
            ThresholdEntity threshold = (ThresholdEntity)thresholdMap.get(datasource);
            if (threshold == null) continue;
            Double dsValue = threshold.fetchLastValue(latIface, latParms);
            HashMap<String, Double> dsValues = new HashMap<String, Double>();
            dsValues.put(datasource, dsValue);
            List<Event> eventList = threshold.evaluateAndCreateEvents(dsValues, date);
            if (eventList.size() == 0) continue;
            this.completeEventListAndAddToEvents(events, eventList, latIface);
        }
        return events;
    }

    private void completeEventListAndAddToEvents(Events events, List<Event> eventList, LatencyInterface latIface) throws ThresholdingException {
        for (Event event : eventList) {
            event.setNodeid((long)latIface.getNodeId());
            event.setInterface(latIface.getInetAddress().getHostAddress());
            event.setService(latIface.getServiceName());
            events.addEvent(event);
        }
    }

    public final ThreadCategory log() {
        return ThreadCategory.getInstance(LatencyThresholder.class);
    }
}

