/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.scheduler.Scheduler;
import org.opennms.netmgt.threshd.Threshd;
import org.opennms.netmgt.threshd.ThresholdableService;
import org.opennms.netmgt.threshd.ThresholderUpdates;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BroadcastEventProcessor
implements EventListener {
    private Map m_monitors;
    private final Scheduler m_scheduler;
    private final List<ThresholdableService> m_thresholdableServices;
    private final Threshd m_threshd;

    BroadcastEventProcessor(Threshd threshd, List<ThresholdableService> thresholdableServices) {
        this.m_threshd = threshd;
        this.m_scheduler = this.m_threshd.getScheduler();
        this.m_thresholdableServices = thresholdableServices;
        this.installMessageSelector();
    }

    private void installMessageSelector() {
        ArrayList<String> ueiList = new ArrayList<String>();
        ueiList.add("uei.opennms.org/nodes/nodeGainedService");
        ueiList.add("uei.opennms.org/nodes/primarySnmpInterfaceChanged");
        ueiList.add("uei.opennms.org/nodes/reinitializePrimarySnmpInterface");
        ueiList.add("uei.opennms.org/nodes/interfaceReparented");
        ueiList.add("uei.opennms.org/nodes/nodeDeleted");
        ueiList.add("uei.opennms.org/nodes/duplicateNodeDeleted");
        ueiList.add("uei.opennms.org/nodes/interfaceDeleted");
        ueiList.add("uei.opennms.org/nodes/serviceDeleted");
        ueiList.add("uei.opennms.org/internal/schedOutagesChanged");
        ueiList.add("uei.opennms.org/internal/thresholdConfigChange");
        EventIpcManagerFactory.getIpcManager().addEventListener(this, ueiList);
    }

    synchronized void close() {
        EventIpcManagerFactory.getIpcManager().removeEventListener(this);
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public String getName() {
        return "Threshd:BroadcastEventProcessor";
    }

    public void onEvent(Event event) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug("received event, uei = " + event.getUei());
        }
        if (event.getUei().equals("uei.opennms.org/internal/schedOutagesChanged")) {
            this.m_threshd.refreshServicePackages();
        } else if (event.getUei().equals("uei.opennms.org/internal/thresholdConfigChange")) {
            this.thresholdConfigurationChangedHandler(event);
        } else if (!event.hasNodeid()) {
            log.info("no database node id found, discarding event");
        } else if (event.getUei().equals("uei.opennms.org/nodes/nodeGainedService")) {
            if (event.getInterface() == null || event.getInterface().length() == 0) {
                log.info("no interface found, discarding event");
            } else {
                this.nodeGainedServiceHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/nodes/primarySnmpInterfaceChanged")) {
            if (event.getInterface() == null || event.getInterface().length() == 0) {
                log.info("no interface found, discarding event");
            } else {
                this.primarySnmpInterfaceChangedHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/nodes/reinitializePrimarySnmpInterface")) {
            if (event.getInterface() == null || event.getInterface().length() == 0) {
                log.info("no interface found, discarding event");
            } else {
                this.reinitializePrimarySnmpInterfaceHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/nodes/interfaceReparented")) {
            if (event.getInterface() == null || event.getInterface().length() == 0) {
                log.info("no interface found, discarding event");
            } else {
                this.interfaceReparentedHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/nodes/nodeDeleted") || event.getUei().equals("uei.opennms.org/nodes/duplicateNodeDeleted")) {
            this.nodeDeletedHandler(event);
        } else if (event.getUei().equals("uei.opennms.org/nodes/interfaceDeleted")) {
            if (event.getInterface() == null || event.getInterface().length() == 0) {
                log.info("no interface found, discarding event");
            } else {
                this.interfaceDeletedHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/nodes/serviceDeleted")) {
            if (event.getInterface() == null || event.getInterface().length() == 0) {
                log.info("no interface found, discarding event");
            } else if (event.getService() == null || event.getService().length() == 0) {
                log.info("no service found, discarding event");
            } else {
                this.serviceDeletedHandler(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinitializePrimarySnmpInterfaceHandler(Event event) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        if (event.getInterface() == null) {
            log.error("reinitializePrimarySnmpInterface event is missing an interface.");
            return;
        }
        List<ThresholdableService> list = this.m_thresholdableServices;
        synchronized (list) {
            for (ThresholdableService tSvc : this.m_thresholdableServices) {
                InetAddress addr = (InetAddress)tSvc.getAddress();
                if (!addr.getHostAddress().equals(event.getInterface())) continue;
                ThresholdableService thresholdableService = tSvc;
                synchronized (thresholdableService) {
                    ThresholderUpdates updates = tSvc.getThresholderUpdates();
                    updates.markForReinitialization();
                    if (log.isDebugEnabled()) {
                        log.debug("markServicesForReinit: marking " + event.getInterface() + " for reinitialization for service SNMP.");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void thresholdConfigurationChangedHandler(Event event) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        try {
            ThresholdingConfigFactory.reload();
        }
        catch (Exception e) {
            log.error("thresholdConfigurationChangedHandler: Failed to reload threshold configuration because " + e.getMessage(), (Throwable)e);
            return;
        }
        this.m_threshd.reinitializeThresholders();
        List<ThresholdableService> list = this.m_thresholdableServices;
        synchronized (list) {
            for (ThresholdableService tSvc : this.m_thresholdableServices) {
                InetAddress addr = (InetAddress)tSvc.getAddress();
                ThresholdableService thresholdableService = tSvc;
                synchronized (thresholdableService) {
                    ThresholderUpdates updates = tSvc.getThresholderUpdates();
                    updates.markForReinitialization();
                    if (log.isDebugEnabled()) {
                        log.debug("thresholdConfigurationChangedHandler: marking " + addr.getHostAddress() + " for reinitialization for service SNMP.");
                    }
                }
            }
        }
    }

    private void nodeGainedServiceHandler(Event event) {
        if (!event.getService().equals("SNMP")) {
            return;
        }
        this.m_threshd.scheduleService((int)event.getNodeid(), event.getInterface(), event.getService(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void primarySnmpInterfaceChangedHandler(Event event) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug("primarySnmpInterfaceChangedHandler:  processing primary SNMP interface changed event...");
        }
        String oldPrimaryIfAddr = null;
        String newPrimaryIfAddr = null;
        Parms parms = event.getParms();
        if (parms != null) {
            String parmName = null;
            Value parmValue = null;
            String parmContent = null;
            Enumeration parmEnum = parms.enumerateParm();
            while (parmEnum.hasMoreElements()) {
                Parm parm = (Parm)parmEnum.nextElement();
                parmName = parm.getParmName();
                parmValue = parm.getValue();
                if (parmValue == null) continue;
                parmContent = parmValue.getContent();
                if (parmName.equals("oldPrimarySnmpAddress")) {
                    oldPrimaryIfAddr = parmContent;
                    continue;
                }
                if (!parmName.equals("newPrimarySnmpAddress")) continue;
                newPrimaryIfAddr = parmContent;
            }
        }
        if (oldPrimaryIfAddr != null) {
            List<ThresholdableService> list = this.m_thresholdableServices;
            synchronized (list) {
                ThresholdableService tSvc = null;
                ListIterator<ThresholdableService> liter = this.m_thresholdableServices.listIterator();
                while (liter.hasNext()) {
                    tSvc = liter.next();
                    InetAddress addr = (InetAddress)tSvc.getAddress();
                    if (!addr.getHostAddress().equals(oldPrimaryIfAddr)) continue;
                    ThresholdableService thresholdableService = tSvc;
                    synchronized (thresholdableService) {
                        ThresholderUpdates updates = tSvc.getThresholderUpdates();
                        updates.markForDeletion();
                        if (log.isDebugEnabled()) {
                            log.debug("primarySnmpInterfaceChangedHandler: marking " + oldPrimaryIfAddr + " as deleted for service SNMP.");
                        }
                    }
                    liter.remove();
                }
            }
        }
        this.m_threshd.scheduleService((int)event.getNodeid(), event.getInterface(), event.getService(), false);
        if (log.isDebugEnabled()) {
            log.debug("primarySnmpInterfaceChangedHandler: processing of primarySnmpInterfaceChanged event for nodeid " + event.getNodeid() + " completed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interfaceReparentedHandler(Event event) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug("interfaceReparentedHandler:  processing interfaceReparented event for " + event.getInterface());
        }
        if (event.getInterface() == null) {
            return;
        }
        String oldNodeIdStr = null;
        String newNodeIdStr = null;
        Parms parms = event.getParms();
        if (parms != null) {
            String parmName = null;
            Value parmValue = null;
            String parmContent = null;
            Enumeration parmEnum = parms.enumerateParm();
            while (parmEnum.hasMoreElements()) {
                Parm parm = (Parm)parmEnum.nextElement();
                parmName = parm.getParmName();
                parmValue = parm.getValue();
                if (parmValue == null) continue;
                parmContent = parmValue.getContent();
                if (parmName.equals("oldNodeID")) {
                    oldNodeIdStr = parmContent;
                    continue;
                }
                if (!parmName.equals("newNodeID")) continue;
                newNodeIdStr = parmContent;
            }
        }
        if (oldNodeIdStr == null || newNodeIdStr == null) {
            log.warn("interfaceReparentedHandler: old and new nodeId parms are required, unable to process.");
            return;
        }
        List<ThresholdableService> list = this.m_thresholdableServices;
        synchronized (list) {
            ThresholdableService tSvc2 = null;
            for (ThresholdableService tSvc2 : this.m_thresholdableServices) {
                InetAddress addr = (InetAddress)tSvc2.getAddress();
                if (!addr.getHostAddress().equals(event.getInterface())) continue;
                ThresholdableService thresholdableService = tSvc2;
                synchronized (thresholdableService) {
                    if (log.isDebugEnabled()) {
                        log.debug("interfaceReparentedHandler: got a ThresholdableService match for " + event.getInterface());
                    }
                    ThresholderUpdates updates = tSvc2.getThresholderUpdates();
                    updates.markForReparenting(oldNodeIdStr, newNodeIdStr);
                    if (log.isDebugEnabled()) {
                        log.debug("interfaceReparentedHandler: marking " + event.getInterface() + " for reparenting for service SNMP.");
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("interfaceReparentedHandler: processing of interfaceReparented event for interface " + event.getInterface() + " completed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nodeDeletedHandler(Event event) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        int nodeId = (int)event.getNodeid();
        List<ThresholdableService> list = this.m_thresholdableServices;
        synchronized (list) {
            ThresholdableService tSvc = null;
            ListIterator<ThresholdableService> liter = this.m_thresholdableServices.listIterator();
            while (liter.hasNext()) {
                tSvc = liter.next();
                if (tSvc.getNodeId() != nodeId) continue;
                ThresholdableService thresholdableService = tSvc;
                synchronized (thresholdableService) {
                    ThresholderUpdates updates = tSvc.getThresholderUpdates();
                    updates.markForDeletion();
                }
                liter.remove();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("nodeDeletedHandler: processing of nodeDeleted event for nodeid " + nodeId + " completed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interfaceDeletedHandler(Event event) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        int nodeId = (int)event.getNodeid();
        String ipAddr = event.getInterface();
        List<ThresholdableService> list = this.m_thresholdableServices;
        synchronized (list) {
            ThresholdableService tSvc = null;
            ListIterator<ThresholdableService> liter = this.m_thresholdableServices.listIterator();
            while (liter.hasNext()) {
                tSvc = liter.next();
                InetAddress addr = (InetAddress)tSvc.getAddress();
                if (tSvc.getNodeId() != nodeId || !addr.getHostName().equals(ipAddr)) continue;
                ThresholdableService thresholdableService = tSvc;
                synchronized (thresholdableService) {
                    ThresholderUpdates updates = tSvc.getThresholderUpdates();
                    updates.markForDeletion();
                }
                liter.remove();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("interfaceDeletedHandler: processing of interfaceDeleted event for " + nodeId + "/" + ipAddr + " completed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceDeletedHandler(Event event) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        if (!event.getService().equals("SNMP")) {
            return;
        }
        int nodeId = (int)event.getNodeid();
        String ipAddr = event.getInterface();
        String svcName = event.getService();
        List<ThresholdableService> list = this.m_thresholdableServices;
        synchronized (list) {
            ThresholdableService tSvc = null;
            ListIterator<ThresholdableService> liter = this.m_thresholdableServices.listIterator();
            while (liter.hasNext()) {
                tSvc = liter.next();
                InetAddress addr = (InetAddress)tSvc.getAddress();
                if ((tSvc.getNodeId() != nodeId || !addr.getHostName().equals(ipAddr)) && tSvc.getServiceName().equals(svcName)) continue;
                ThresholdableService thresholdableService = tSvc;
                synchronized (thresholdableService) {
                    ThresholderUpdates updates = tSvc.getThresholderUpdates();
                    updates.markForDeletion();
                }
                liter.remove();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("serviceDeletedHandler: processing of serviceDeleted event for " + nodeId + "/" + ipAddr + "/" + svcName + " completed.");
        }
    }
}

