/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmpinterfacepoller;

import java.util.List;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableSnmpInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnmpPollInterfaceMonitor {
    private static final String IF_ADMIN_STATUS_OID = ".1.3.6.1.2.1.2.2.1.7.";
    private static final String IF_OPER_STATUS_OID = ".1.3.6.1.2.1.2.2.1.8.";

    public List<PollableSnmpInterface.SnmpMinimalPollInterface> poll(SnmpAgentConfig agentConfig, List<PollableSnmpInterface.SnmpMinimalPollInterface> mifaces) {
        if (mifaces == null) {
            this.log().error("Null Interfaces passed to Monitor, exiting");
            return null;
        }
        this.log().debug("Got " + mifaces.size() + " interfaces to poll");
        if (agentConfig == null) {
            throw new RuntimeException("SnmpAgentConfig object not available");
        }
        SnmpObjId[] adminoids = new SnmpObjId[mifaces.size()];
        SnmpObjId[] operooids = new SnmpObjId[mifaces.size()];
        for (int i = 0; i < mifaces.size(); ++i) {
            PollableSnmpInterface.SnmpMinimalPollInterface miface = mifaces.get(i);
            miface.setStatus(PollStatus.unavailable());
            adminoids[i] = SnmpObjId.get((String)(IF_ADMIN_STATUS_OID + miface.getIfindex()));
            operooids[i] = SnmpObjId.get((String)(IF_OPER_STATUS_OID + miface.getIfindex()));
            this.log().debug("Adding Admin/Oper oids: " + adminoids[i] + "/" + operooids[i]);
        }
        SnmpValue[] adminresults = new SnmpValue[mifaces.size()];
        SnmpValue[] operoresults = new SnmpValue[mifaces.size()];
        this.log().debug("try to get admin statuses");
        adminresults = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId[])adminoids);
        this.log().debug("got admin status " + adminresults.length + " SnmpValues");
        if (adminresults.length != mifaces.size()) {
            this.log().warn("Snmp Admin statuses collection failed");
            return mifaces;
        }
        this.log().debug("try to get admin statuses");
        operoresults = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId[])operooids);
        this.log().debug("got operational status " + operoresults.length + " SnmpValues");
        if (operoresults.length != mifaces.size()) {
            this.log().warn("Snmp Operational statuses collection failed");
            return mifaces;
        }
        for (int i = 0; i < mifaces.size(); ++i) {
            PollableSnmpInterface.SnmpMinimalPollInterface miface = mifaces.get(i);
            if (adminresults[i] != null && operoresults[i] != null) {
                try {
                    miface.setAdminstatus(adminresults[i].toInt());
                    miface.setOperstatus(operoresults[i].toInt());
                    miface.setStatus(PollStatus.up());
                    this.log().debug("SNMP Value is " + adminresults[i].toInt() + " for oid: " + adminoids[i]);
                    this.log().debug("SNMP Value is " + operoresults[i].toInt() + " for oid: " + operooids[i]);
                }
                catch (Exception e) {
                    this.log().warn("SNMP Value is " + adminresults[i].toDisplayString() + " for oid: " + adminoids[i]);
                    this.log().warn("SNMP Value is " + operoresults[i].toDisplayString() + " for oid: " + operooids[i]);
                }
                continue;
            }
            this.log().info("SNMP Value is null for oid: " + adminoids[i] + "/" + operooids[i]);
        }
        return mifaces;
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

