/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc.datablock;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.opennms.netmgt.config.categories.Category;
import org.opennms.netmgt.rtc.datablock.RTCNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTCCategory
extends Category {
    private static final long serialVersionUID = 1L;
    private String m_effectiveRule;
    private List<Long> m_nodes;

    public RTCCategory(Category cat, String commonRule) {
        this.setLabel(cat.getLabel());
        this.setComment(cat.getComment());
        this.setRule(cat.getRule());
        this.setNormal(cat.getNormal());
        this.setWarning(cat.getWarning());
        this.setService(cat.getService());
        this.m_effectiveRule = "(" + commonRule + ") & (" + cat.getRule() + ")";
        this.m_nodes = Collections.synchronizedList(new ArrayList());
    }

    public void addNode(RTCNode node) {
        Long longnodeid = node.getNodeID();
        if (!this.m_nodes.contains(longnodeid)) {
            this.m_nodes.add(longnodeid);
        }
    }

    public void addNode(long nodeid) {
        Long longnodeid = new Long(nodeid);
        if (!this.m_nodes.contains(longnodeid)) {
            this.m_nodes.add(longnodeid);
        }
    }

    public void deleteNode(long nodeid) {
        Long longnodeid = new Long(nodeid);
        this.m_nodes.remove(longnodeid);
    }

    public boolean containsService(String svcname) {
        if (this.getServiceCount() <= 0) {
            return true;
        }
        boolean found = false;
        Enumeration en = this.enumerateService();
        while (en.hasMoreElements()) {
            String svc = (String)en.nextElement();
            if (!svc.equals(svcname)) continue;
            found = true;
            break;
        }
        return found;
    }

    public String getEffectiveRule() {
        return this.m_effectiveRule;
    }

    public List<Long> getNodes() {
        return this.m_nodes;
    }
}

