/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.nsclient;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.poller.nsclient.NsclientCheckParams;
import org.opennms.netmgt.poller.nsclient.NsclientException;
import org.opennms.netmgt.poller.nsclient.NsclientPacket;

public class NsclientManager {
    public static int DEFAULT_SOCKET_TIMEOUT = 5000;
    public static int DEFAULT_PORT = 1248;
    private String m_HostName = null;
    private int m_PortNumber = DEFAULT_PORT;
    private String m_Password = "None";
    private Socket m_Socket = null;
    private BufferedInputStream m_BufInStream = null;
    private ByteArrayOutputStream m_ByteArrayOutStream = null;
    private int m_Timeout = DEFAULT_SOCKET_TIMEOUT;
    public static final String CHECK_NONE = "0";
    public static final String CHECK_CLIENTVERSION = "1";
    public static final String CHECK_CPULOAD = "2";
    public static final String CHECK_UPTIME = "3";
    public static final String CHECK_USEDDISKSPACE = "4";
    public static final String CHECK_SERVICESTATE = "5";
    public static final String CHECK_PROCSTATE = "6";
    public static final String CHECK_MEMUSE = "7";
    public static final String CHECK_COUNTER = "8";
    public static final String CHECK_FILEAGE = "9";
    public static final String CHECK_INSTANCES = "10";
    public static final String CHECK_FILESIZE = "CheckFileSize";
    public static final Map<String, String> CheckStrings = new HashMap<String, String>();

    public static String convertTypeToString(String type) {
        for (Map.Entry<String, String> e : CheckStrings.entrySet()) {
            String val = e.getValue();
            if (!val.equals(type)) continue;
            return e.getKey();
        }
        return "NONE";
    }

    public static String convertStringToType(String type) {
        for (Map.Entry<String, String> e : CheckStrings.entrySet()) {
            if (!type.equalsIgnoreCase(e.getKey())) continue;
            return e.getValue();
        }
        return null;
    }

    public void setPassword(String pass) {
        this.m_Password = pass;
    }

    public void setPortNumber(int port) {
        this.m_PortNumber = port;
    }

    public int getPortNumber() {
        return this.m_PortNumber;
    }

    public void setHostName(String host) {
        this.m_HostName = host;
    }

    public String getHostName() {
        return this.m_HostName;
    }

    public void setTimeout(int timeout) {
        this.m_Timeout = timeout;
    }

    public int getTimeout() {
        return this.m_Timeout;
    }

    public NsclientManager(String host) {
        this.m_HostName = host;
    }

    public NsclientManager(String host, int port) {
        this.m_HostName = host;
        this.m_PortNumber = port;
    }

    public NsclientManager(String host, int port, String pass) {
        this.m_HostName = host;
        this.m_PortNumber = port;
        this.m_Password = pass;
    }

    public NsclientManager(String host, String pass) {
        this.m_HostName = host;
        this.m_Password = pass;
    }

    private NsclientManager() {
    }

    public void init() throws NsclientException {
        try {
            this.m_Socket = new Socket();
            this.m_Socket.connect(new InetSocketAddress(this.m_HostName, this.m_PortNumber), this.m_Timeout);
            this.m_Socket.setSoTimeout(this.m_Timeout);
            this.m_BufInStream = new BufferedInputStream(this.m_Socket.getInputStream());
            this.m_ByteArrayOutStream = new ByteArrayOutputStream();
        }
        catch (UnknownHostException e) {
            this.closeSocketAndThrow(new NsclientException("Unknown host: " + this.m_HostName, e));
        }
        catch (ConnectException e) {
            this.closeSocketAndThrow(new NsclientException("Connection refused to " + this.m_HostName + ":" + this.m_PortNumber, e));
        }
        catch (NoRouteToHostException e) {
            this.closeSocketAndThrow(new NsclientException("Unable to connect to host: " + this.m_HostName + ", no route to host.", e));
        }
        catch (InterruptedIOException e) {
            this.closeSocketAndThrow(new NsclientException("Unable to connect to host: " + this.m_HostName + ":" + this.m_PortNumber + ", exceeded timeout of " + this.m_Timeout, e));
        }
        catch (IOException e) {
            this.closeSocketAndThrow(new NsclientException("An unexpected I/O exception occured connecting to host: " + this.m_HostName + ":" + this.m_PortNumber, e));
        }
    }

    private void closeSocketAndThrow(NsclientException e) throws NsclientException {
        if (this.m_Socket != null && !this.m_Socket.isClosed()) {
            try {
                this.m_Socket.close();
            }
            catch (IOException ioe) {
                LogUtils.debugf((Object)this, (Throwable)ioe, (String)"unable to close socket after a previous failure", (Object[])new Object[0]);
            }
        }
        throw e;
    }

    public void close() {
        try {
            this.m_Socket.close();
        }
        catch (Exception e) {
            LogUtils.debugf((Object)this, (Throwable)e, (String)"unable to close socket", (Object[])new Object[0]);
        }
    }

    private NsclientPacket sendCheckRequest(String request) throws NsclientException {
        byte[] buffer = new byte[1024];
        this.m_ByteArrayOutStream.reset();
        try {
            if (!request.endsWith("\n")) {
                request = request + "\n";
            }
            this.m_Socket.getOutputStream().write(request.getBytes());
            this.m_Socket.getOutputStream().flush();
            int read = this.m_BufInStream.read(buffer);
            if (read > 0) {
                this.m_ByteArrayOutStream.write(buffer, 0, read);
            }
            return new NsclientPacket(this.m_ByteArrayOutStream.toString());
        }
        catch (Exception e) {
            throw new NsclientException("Unknown exception: " + e.getMessage(), e);
        }
    }

    public NsclientPacket processCheckCommand(String type, NsclientCheckParams param) throws NsclientException {
        if (type.equals(CHECK_CLIENTVERSION)) {
            return this.checkClientVersion(param);
        }
        if (type.equals(CHECK_CPULOAD)) {
            return this.checkCpuLoad(param);
        }
        if (type.equals(CHECK_UPTIME)) {
            return this.checkUptime(param);
        }
        if (type.equals(CHECK_SERVICESTATE)) {
            return this.checkServiceState(param);
        }
        if (type.equals(CHECK_USEDDISKSPACE)) {
            return this.checkUsedDiskSpace(param);
        }
        if (type.equals(CHECK_PROCSTATE)) {
            return this.checkProcState(param);
        }
        if (type.equals(CHECK_MEMUSE)) {
            return this.checkMemoryUsage(param);
        }
        if (type.equals(CHECK_COUNTER)) {
            return this.checkPerfCounter(param);
        }
        if (type.equals(CHECK_FILEAGE)) {
            return this.checkFileAge(param);
        }
        if (type.equals(CHECK_INSTANCES)) {
            return this.checkInstances(param);
        }
        return null;
    }

    private NsclientPacket checkClientVersion(NsclientCheckParams param) throws NsclientException {
        NsclientPacket pack = null;
        pack = this.sendCheckRequest(this.m_Password + "&" + CHECK_CLIENTVERSION);
        if (pack.getResponse().matches(".*ERROR.*")) {
            pack.setResultCode((short)-1);
            return pack;
        }
        if (param.getParamString() == null || param.getParamString().equals("")) {
            pack.setResultCode((short)0);
            return pack;
        }
        pack.setResultCode((short)2);
        String[] minimum = param.getParamString().split("\\.");
        String[] remote = pack.getResponse().contains(" ") ? pack.getResponse().split(" ")[1].split("\\.") : pack.getResponse().split("\\.");
        if (remote.length != 4) {
            pack.setResultCode((short)-1);
            return pack;
        }
        Integer[] remVer = new Integer[4];
        Integer[] minVer = new Integer[4];
        try {
            for (int i = 0; i < 4; ++i) {
                if (minimum[i] != null) {
                    minVer[i] = Integer.parseInt(minimum[i]);
                }
                if (remote[i] == null) continue;
                remVer[i] = Integer.parseInt(remote[i]);
            }
        }
        catch (NumberFormatException nfe) {
            return this.handleNumberFormatException(pack, nfe);
        }
        if (minVer[0] == null || remVer[0].compareTo(minVer[0]) > 0) {
            pack.setResultCode((short)0);
        } else if (remVer[0].compareTo(minVer[0]) == 0) {
            if (minVer[1] == null || remVer[1].compareTo(minVer[1]) > 0) {
                pack.setResultCode((short)0);
            } else if (remVer[1].compareTo(minVer[1]) == 0) {
                if (minVer[2] == null || remVer[2].compareTo(minVer[2]) > 0) {
                    pack.setResultCode((short)0);
                } else if (remVer[2].compareTo(minVer[2]) == 0) {
                    if (minVer[3] == null || remVer[3].compareTo(minVer[3]) > 0) {
                        pack.setResultCode((short)0);
                    } else if (remVer[3].compareTo(minVer[3]) == 0) {
                        pack.setResultCode((short)0);
                    }
                }
            }
        }
        return pack;
    }

    private NsclientPacket checkCpuLoad(NsclientCheckParams param) throws NsclientException {
        NsclientPacket pack = null;
        try {
            pack = this.sendCheckRequest(this.m_Password + "&" + CHECK_CPULOAD + "&1&1&1");
            pack.setResultCode((short)0);
            if (pack.getResponse().matches(".*ERROR.*")) {
                pack.setResultCode((short)-1);
                return pack;
            }
            if (param.getWarningPercent() != 0 && Integer.parseInt(pack.getResponse()) > param.getWarningPercent()) {
                pack.setResultCode((short)1);
            }
            if (param.getCriticalPercent() != 0 && Integer.parseInt(pack.getResponse()) > param.getCriticalPercent()) {
                pack.setResultCode((short)2);
            }
            return pack;
        }
        catch (NumberFormatException nfe) {
            return this.handleNumberFormatException(pack, nfe);
        }
        catch (NsclientException e) {
            throw e;
        }
    }

    private NsclientPacket checkUptime(NsclientCheckParams param) throws NsclientException {
        NsclientPacket pack = null;
        pack = this.sendCheckRequest(this.m_Password + "&" + CHECK_UPTIME);
        pack.setResultCode((short)0);
        if (pack.getResponse().matches(".*ERROR.*")) {
            pack.setResultCode((short)-1);
            return pack;
        }
        return pack;
    }

    private NsclientPacket checkServiceState(NsclientCheckParams param) throws NsclientException {
        NsclientPacket pack = null;
        pack = this.sendCheckRequest(this.m_Password + "&" + CHECK_SERVICESTATE + "&ShowAll&" + this.prepList(param.getParamString()));
        pack.setResultCode((short)0);
        String[] services = pack.getResponse().replaceFirst("^\\d&\\s+", "").split("\\s+-\\s+");
        for (int i = 0; i < services.length; ++i) {
            String stateValue = services[i].split(":\\s+")[1].trim();
            if (!stateValue.equals("Stopped") && !stateValue.equals("Unknown") && !stateValue.equals("Not found")) continue;
            pack.setResultCode((short)2);
        }
        return pack;
    }

    private NsclientPacket checkProcState(NsclientCheckParams param) throws NsclientException {
        NsclientPacket pack = null;
        pack = this.sendCheckRequest(this.m_Password + "&" + CHECK_PROCSTATE + "&ShowAll&" + this.prepList(param.getParamString()));
        pack.setResultCode((short)0);
        if (pack.getResponse().matches(".*ERROR.*")) {
            pack.setResultCode((short)-1);
            return pack;
        }
        String[] services = pack.getResponse().replaceFirst("^\\d&\\s+", "").split("\\s+-\\s+");
        for (int i = 0; i < services.length; ++i) {
            if (!services[i].split(":\\s+")[1].matches("not running\\s*")) continue;
            pack.setResultCode((short)2);
        }
        return pack;
    }

    private NsclientPacket checkUsedDiskSpace(NsclientCheckParams param) throws NsclientException {
        NsclientPacket pack = null;
        try {
            pack = this.sendCheckRequest(this.m_Password + "&" + CHECK_USEDDISKSPACE + "&" + param.getParamString());
            pack.setResultCode((short)0);
            if (pack.getResponse().matches(".*ERROR.*")) {
                pack.setResultCode((short)-1);
                return pack;
            }
            String[] results = pack.getResponse().split("&");
            double freeDisk = Double.parseDouble(results[0]);
            double totalDisk = Double.parseDouble(results[1]);
            double usedPerc = (totalDisk - freeDisk) / totalDisk * 100.0;
            if (freeDisk < 0.0 || totalDisk < 0.0) {
                pack.setResultCode((short)-1);
                return pack;
            }
            if (param.getWarningPercent() != 0 && usedPerc > (double)param.getWarningPercent()) {
                pack.setResultCode((short)1);
            }
            if (param.getCriticalPercent() != 0 && usedPerc > (double)param.getCriticalPercent()) {
                pack.setResultCode((short)2);
            }
            return pack;
        }
        catch (NumberFormatException nfe) {
            return this.handleNumberFormatException(pack, nfe);
        }
        catch (NsclientException e) {
            throw e;
        }
    }

    private NsclientPacket checkMemoryUsage(NsclientCheckParams param) throws NsclientException {
        NsclientPacket pack = null;
        try {
            pack = this.sendCheckRequest(this.m_Password + "&" + CHECK_MEMUSE + "&7");
            pack.setResultCode((short)0);
            if (pack.getResponse().matches(".*ERROR.*")) {
                pack.setResultCode((short)-1);
                return pack;
            }
            String[] results = pack.getResponse().split("&");
            float memCommitLimit = Float.parseFloat(results[0].replace(",", "."));
            float memCommitByte = Float.parseFloat(results[1].replace(",", "."));
            float memUsedPerc = memCommitByte / memCommitLimit * 100.0f;
            if (param.getWarningPercent() != 0 && memUsedPerc > (float)param.getWarningPercent()) {
                pack.setResultCode((short)1);
            }
            if (param.getCriticalPercent() != 0 && memUsedPerc > (float)param.getCriticalPercent()) {
                pack.setResultCode((short)2);
            }
            return pack;
        }
        catch (NumberFormatException nfe) {
            return this.handleNumberFormatException(pack, nfe);
        }
        catch (NsclientException e) {
            throw e;
        }
    }

    private NsclientPacket checkPerfCounter(NsclientCheckParams param) throws NsclientException {
        NsclientPacket pack = null;
        try {
            pack = this.sendCheckRequest(this.m_Password + "&" + CHECK_COUNTER + "&" + this.prepList(param.getParamString()));
            pack.setResultCode((short)0);
            if (pack.getResponse().matches(".*ERROR.*")) {
                pack.setResultCode((short)-1);
                return pack;
            }
            float counterValue = Float.parseFloat(pack.getResponse().replace(",", "."));
            if (param.getWarningPercent() != 0 && counterValue > (float)param.getWarningPercent()) {
                pack.setResultCode((short)1);
            }
            if (param.getCriticalPercent() != 0 && counterValue > (float)param.getCriticalPercent()) {
                pack.setResultCode((short)2);
            }
            return pack;
        }
        catch (NumberFormatException nfe) {
            return this.handleNumberFormatException(pack, nfe);
        }
        catch (NsclientException e) {
            throw e;
        }
    }

    private NsclientPacket checkFileAge(NsclientCheckParams param) throws NsclientException {
        NsclientPacket pack = null;
        String responseValue = "";
        try {
            pack = this.sendCheckRequest(this.m_Password + "&" + CHECK_FILEAGE + "&" + param.getParamString());
            pack.setResultCode((short)0);
            if (pack.getResponse().matches(".*ERROR.*")) {
                pack.setResultCode((short)-1);
                return pack;
            }
            String[] results = pack.getResponse().split("&");
            responseValue = results[0];
            double minutes = Double.parseDouble(responseValue);
            if (param.getWarningPercent() != 0 && minutes < (double)param.getWarningPercent()) {
                pack.setResultCode((short)1);
            }
            if (param.getCriticalPercent() != 0 && minutes < (double)param.getCriticalPercent()) {
                pack.setResultCode((short)2);
            }
            return pack;
        }
        catch (NumberFormatException nfe) {
            return this.handleNumberFormatException(pack, nfe);
        }
        catch (NsclientException e) {
            throw e;
        }
    }

    private NsclientPacket checkInstances(NsclientCheckParams param) throws NsclientException {
        NsclientPacket pack = null;
        pack = this.sendCheckRequest(this.m_Password + "&" + CHECK_INSTANCES + "&" + param.getParamString());
        pack.setResultCode((short)0);
        if (pack.getResponse().matches(".*ERROR.*")) {
            pack.setResultCode((short)-1);
            return pack;
        }
        LogUtils.debugf((Object)this, (String)"checkInstances: received result '%s'", (Object[])new Object[]{pack.getResponse()});
        return pack;
    }

    private String prepList(String list) {
        return list.replaceAll(",", "&");
    }

    private NsclientPacket handleNumberFormatException(NsclientPacket pack, NumberFormatException e) throws NsclientException {
        pack.setResultCode((short)-1);
        LogUtils.infof((Object)this, (Throwable)e, (String)"Unable to parse numeric value returned (%s)", (Object[])new Object[]{pack.getResponse()});
        return pack;
    }

    static {
        CheckStrings.put("NONE", CHECK_NONE);
        CheckStrings.put("CLIENTVERSION", CHECK_CLIENTVERSION);
        CheckStrings.put("CPULOAD", CHECK_CPULOAD);
        CheckStrings.put("UPTIME", CHECK_UPTIME);
        CheckStrings.put("USEDDISKSPACE", CHECK_USEDDISKSPACE);
        CheckStrings.put("SERVICESTATE", CHECK_SERVICESTATE);
        CheckStrings.put("PROCSTATE", CHECK_PROCSTATE);
        CheckStrings.put("MEMUSE", CHECK_MEMUSE);
        CheckStrings.put("COUNTER", CHECK_COUNTER);
        CheckStrings.put("FILEAGE", CHECK_FILEAGE);
        CheckStrings.put("INSTANCES", CHECK_INSTANCES);
    }
}

