/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.URL;
import java.util.Map;
import org.apache.log4j.Level;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable
public final class DominoIIOPMonitor
extends IPv4Monitor {
    private static final int DEFAULT_PORT = 63148;
    private static final int DEFAULT_IORPORT = 80;
    private static final int DEFAULT_RETRY = 3;
    private static final int DEFAULT_TIMEOUT = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        ThreadCategory log = ThreadCategory.getInstance(((Object)((Object)this)).getClass());
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        TimeoutTracker tracker = new TimeoutTracker(parameters, 3, 3000);
        int IORport = ParameterMap.getKeyedInteger(parameters, (String)"ior-port", (int)80);
        int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)63148);
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        if (log.isDebugEnabled()) {
            log.debug("poll: address = " + ipv4Addr.getHostAddress() + ", port = " + port + ", " + tracker);
        }
        try {
            this.retrieveIORText(ipv4Addr.getHostAddress(), IORport);
        }
        catch (Exception e) {
            return this.logDown(Level.DEBUG, "failed to get the corba IOR from " + ipv4Addr, e);
        }
        PollStatus status = null;
        tracker.reset();
        while (tracker.shouldRetry() && !status.isAvailable()) {
            Socket socket = null;
            try {
                tracker.startAttempt();
                socket = new Socket();
                socket.connect(new InetSocketAddress(ipv4Addr, port), tracker.getConnectionTimeout());
                socket.setSoTimeout(tracker.getSoTimeout());
                log.debug("DominoIIOPMonitor: connected to host: " + ipv4Addr + " on port: " + port);
                PollStatus pollStatus = PollStatus.up((Double)tracker.elapsedTimeInMillis());
                return pollStatus;
            }
            catch (NoRouteToHostException e) {
                status = this.logDown(Level.WARN, " No route to host exception for address " + ipv4Addr.getHostAddress(), e);
            }
            catch (InterruptedIOException e) {
                status = this.logDown(Level.DEBUG, "did not connect to host with " + tracker);
            }
            catch (ConnectException e) {
                status = this.logDown(Level.DEBUG, "Connection exception for address: " + ipv4Addr + " : " + e.getMessage());
            }
            catch (IOException e) {
                status = this.logDown(Level.DEBUG, "IOException while polling address: " + ipv4Addr + " : " + e.getMessage());
            }
            finally {
                block30: {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException e) {
                        e.fillInStackTrace();
                        if (!log.isDebugEnabled()) break block30;
                        log.debug("DominoIIOPMonitor: Error closing socket.", (Throwable)e);
                    }
                }
            }
            tracker.nextAttempt();
        }
        return status;
    }

    private String retrieveIORText(String host, int port) throws IOException {
        String IOR = "";
        URL u = new URL("http://" + host + ":" + port + "/diiop_ior.txt");
        InputStream is = u.openStream();
        BufferedReader dis = new BufferedReader(new InputStreamReader(is));
        boolean done = false;
        while (!done) {
            String line = dis.readLine();
            if (line == null) {
                done = true;
                continue;
            }
            if (!(IOR = IOR + line).startsWith("IOR:")) continue;
            done = true;
        }
        dis.close();
        if (!IOR.startsWith("IOR:")) {
            throw new IOException("Invalid IOR: " + IOR);
        }
        return IOR;
    }
}

