/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.capsd.snmp.SnmpTableEntry;
import org.opennms.netmgt.linkd.AtInterface;
import org.opennms.netmgt.linkd.BridgeStpInterface;
import org.opennms.netmgt.linkd.CdpInterface;
import org.opennms.netmgt.linkd.DbAtInterfaceEntry;
import org.opennms.netmgt.linkd.DbDataLinkInterfaceEntry;
import org.opennms.netmgt.linkd.DbIpRouteInterfaceEntry;
import org.opennms.netmgt.linkd.DbStpInterfaceEntry;
import org.opennms.netmgt.linkd.DbStpNodeEntry;
import org.opennms.netmgt.linkd.DbVlanEntry;
import org.opennms.netmgt.linkd.DiscoveryLink;
import org.opennms.netmgt.linkd.EventUtils;
import org.opennms.netmgt.linkd.LinkableNode;
import org.opennms.netmgt.linkd.Linkd;
import org.opennms.netmgt.linkd.MacToNodeLink;
import org.opennms.netmgt.linkd.NodeToNodeLink;
import org.opennms.netmgt.linkd.QueryManager;
import org.opennms.netmgt.linkd.RouterInterface;
import org.opennms.netmgt.linkd.SnmpCollection;
import org.opennms.netmgt.linkd.SnmpVlanCollection;
import org.opennms.netmgt.linkd.Vlan;
import org.opennms.netmgt.linkd.snmp.CdpCacheTableEntry;
import org.opennms.netmgt.linkd.snmp.Dot1dBaseGroup;
import org.opennms.netmgt.linkd.snmp.Dot1dBasePortTableEntry;
import org.opennms.netmgt.linkd.snmp.Dot1dStpGroup;
import org.opennms.netmgt.linkd.snmp.Dot1dStpPortTableEntry;
import org.opennms.netmgt.linkd.snmp.Dot1dTpFdbTableEntry;
import org.opennms.netmgt.linkd.snmp.IpNetToMediaTableEntry;
import org.opennms.netmgt.linkd.snmp.QBridgeDot1dTpFdbTableEntry;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbEventWriter
implements QueryManager {
    private JdbcTemplate jdbcTemplate;
    private Linkd m_linkd;
    private static final String SQL_SELECT_SNMP_NODE = "SELECT nodesysoid, ipaddr FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE node.nodeid = ? AND nodetype = 'A' AND issnmpprimary = 'P'";
    private static final String SQL_SELECT_SNMP_IP_ADDR = "SELECT ipaddr FROM ipinterface WHERE nodeid = ? AND issnmpprimary = 'P'";
    private static final String SQL_GET_NODEID = "SELECT node.nodeid FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE nodetype = 'A' AND ipaddr = ?";
    private static final String SQL_GET_NODEID__IFINDEX_MASK = "SELECT node.nodeid,snmpinterface.snmpifindex,snmpinterface.snmpipadentnetmask FROM node LEFT JOIN snmpinterface ON node.nodeid = snmpinterface.nodeid WHERE nodetype = 'A' AND ipaddr = ?";
    private static final String SQL_GET_NODEID_IFINDEX_IPINT = "SELECT node.nodeid,ipinterface.ifindex FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE nodetype = 'A' AND ipaddr = ?";
    private static final String SQL_UPDATE_DATALINKINTERFACE = "UPDATE datalinkinterface set status = 'N'  WHERE lastpolltime < ? AND status = 'A'";
    private static final String SQL_UPDATE_ATINTERFACE = "UPDATE atinterface set status = 'N'  WHERE sourcenodeid = ? AND lastpolltime < ? AND status = 'A'";
    private static final String SQL_UPDATE_IPROUTEINTERFACE = "UPDATE iprouteinterface set status = 'N'  WHERE nodeid = ? AND lastpolltime < ? AND status = 'A'";
    private static final String SQL_UPDATE_STPNODE = "UPDATE stpnode set status = 'N'  WHERE nodeid = ? AND lastpolltime < ? AND status = 'A'";
    private static final String SQL_UPDATE_STPINTERFACE = "UPDATE stpinterface set status = 'N'  WHERE nodeid = ? AND lastpolltime < ? AND status = 'A'";
    private static final String SQL_UPDATE_VLAN = "UPDATE vlan set status = 'N'  WHERE nodeid =? AND lastpolltime < ? AND status = 'A'";
    private static final String SQL_UPDATE_ATINTERFACE_STATUS = "UPDATE atinterface set status = ?  WHERE sourcenodeid = ? OR nodeid = ?";
    private static final String SQL_UPDATE_IPROUTEINTERFACE_STATUS = "UPDATE iprouteinterface set status = ? WHERE nodeid = ? ";
    private static final String SQL_UPDATE_STPNODE_STATUS = "UPDATE stpnode set status = ?  WHERE nodeid = ? ";
    private static final String SQL_UPDATE_STPINTERFACE_STATUS = "UPDATE stpinterface set status = ? WHERE nodeid = ? ";
    private static final String SQL_UPDATE_VLAN_STATUS = "UPDATE vlan set status = ?  WHERE nodeid = ? ";
    private static final String SQL_UPDATE_DATALINKINTERFACE_STATUS = "UPDATE datalinkinterface set status = ? WHERE nodeid = ? OR nodeparentid = ? ";
    private static final String SQL_GET_NODEID_IFINDEX = "SELECT atinterface.nodeid, atinterface.ipaddr, ipinterface.ifindex from atinterface left JOIN ipinterface ON atinterface.nodeid = ipinterface.nodeid AND atinterface.ipaddr = ipinterface.ipaddr WHERE atphysaddr = ? AND atinterface.status <> 'D'";
    private static final String SQL_GET_SNMPIFTYPE = "SELECT snmpiftype FROM snmpinterface WHERE nodeid = ? AND snmpifindex = ?";
    private static final String SQL_GET_IFINDEX_SNMPINTERFACE_NAME = "SELECT snmpifindex FROM snmpinterface WHERE nodeid = ? AND (snmpifname = ? OR snmpifdescr = ?) ";
    private static final String SQL_GET_SNMPPHYSADDR_SNMPINTERFACE = "SELECT snmpphysaddr FROM snmpinterface WHERE nodeid = ? AND  snmpphysaddr <> ''";
    private static final String SQL_SELECT_SNMP_NODES = "SELECT node.nodeid, nodesysoid, ipaddr FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE nodetype = 'A' AND issnmpprimary = 'P'";
    private static final String SQL_UPDATE_VLAN_D = "UPDATE vlan set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D' ";
    private static final String SQL_UPDATE_ATINTERFACE_D = "UPDATE atinterface set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D' ";
    private static final String SQL_UPDATE_STPNODE_D = "UPDATE stpnode set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D'";
    private static final String SQL_UPDATE_STPINTERFACE_D = "UPDATE stpinterface set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D'";
    private static final String SQL_UPDATE_IPROUTEINTERFACE_D = "UPDATE iprouteinterface set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D'";
    private static final String SQL_UPDATE_DATALINKINTERFACE_D = "UPDATE datalinkinterface set status = 'D' WHERE (nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) OR nodeparentid IN (SELECT nodeid from node WHERE nodetype = 'D' )) AND status <> 'D'";
    private static final String SQL_UPDATE_ATINTERFACE_STATUS_INTFC = "UPDATE atinterface set status = ?  WHERE nodeid = ? AND ipaddr = ?";
    private static final String SQL_UPDATE_ATINTERFACE_STATUS_SRC_INTFC = "UPDATE atinterface set status = ?  WHERE sourcenodeid = ? AND ifindex = ?";
    private static final String SQL_UPDATE_STPINTERFACE_STATUS_INTFC = "UPDATE stpinterface set status = ? WHERE nodeid = ? AND ifindex = ?";
    private static final String SQL_UPDATE_IPROUTEINTERFACE_STATUS_INTFC = "UPDATE iprouteinterface set status = ? WHERE nodeid = ? AND routeifindex = ?";
    private static final String SQL_UPDATE_DATALINKINTERFACE_STATUS_INTFC = "UPDATE datalinkinterface set status = ? WHERE (nodeid = ? and ifindex = ?) OR (nodeparentid = ? AND parentifindex = ?)";

    public void setLinkd(Linkd linkd) {
        this.m_linkd = linkd;
    }

    public Linkd getLinkd() {
        return this.m_linkd;
    }

    private Connection getConnection() throws SQLException {
        return this.jdbcTemplate.getDataSource().getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeDiscoveryLink(DiscoveryLink discovery) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            int i;
            Connection dbConn = this.getConnection();
            d.watch((Object)dbConn);
            Timestamp now = new Timestamp(System.currentTimeMillis());
            PreparedStatement stmt = null;
            ResultSet rs = null;
            NodeToNodeLink[] links = discovery.getLinks();
            LogUtils.debugf((Object)this, (String)"storelink: Storing %d NodeToNodeLink information into database", (Object[])new Object[]{links.length});
            for (int i2 = 0; i2 < links.length; ++i2) {
                NodeToNodeLink lk = links[i2];
                int nodeid = lk.getNodeId();
                int ifindex = lk.getIfindex();
                int nodeparentid = lk.getNodeparentid();
                int parentifindex = lk.getParentifindex();
                DbDataLinkInterfaceEntry dbentry = DbDataLinkInterfaceEntry.get(dbConn, nodeid, ifindex);
                if (dbentry == null) {
                    dbentry = DbDataLinkInterfaceEntry.create(nodeid, ifindex);
                }
                dbentry.updateNodeParentId(nodeparentid);
                dbentry.updateParentIfIndex(parentifindex);
                dbentry.updateStatus('A');
                dbentry.set_lastpolltime(now);
                dbentry.store(dbConn);
                dbentry = DbDataLinkInterfaceEntry.get(dbConn, nodeparentid, parentifindex);
                if (dbentry == null || dbentry.get_nodeparentid() != nodeid || dbentry.get_parentifindex() != ifindex || dbentry.get_status() == 'D') continue;
                dbentry.updateStatus('D');
                dbentry.store(dbConn);
            }
            MacToNodeLink[] linkmacs = discovery.getMacLinks();
            LogUtils.debugf((Object)this, (String)("storelink: Storing " + linkmacs.length + " MacToNodeLink information into database"), (Object[])new Object[0]);
            for (i = 0; i < linkmacs.length; ++i) {
                MacToNodeLink lkm = linkmacs[i];
                String macaddr = lkm.getMacAddress();
                LogUtils.debugf((Object)this, (String)("storelink: finding nodeid,ifindex on DB using mac address: " + macaddr), (Object[])new Object[0]);
                stmt = dbConn.prepareStatement(SQL_GET_NODEID_IFINDEX);
                d.watch((Object)stmt);
                stmt.setString(1, macaddr);
                rs = stmt.executeQuery();
                d.watch((Object)rs);
                LogUtils.debugf((Object)this, (String)("storelink: finding nodeid,ifindex on DB. Sql Statement SELECT atinterface.nodeid, atinterface.ipaddr, ipinterface.ifindex from atinterface left JOIN ipinterface ON atinterface.nodeid = ipinterface.nodeid AND atinterface.ipaddr = ipinterface.ipaddr WHERE atphysaddr = ? AND atinterface.status <> 'D' with mac address " + macaddr), (Object[])new Object[0]);
                if (!rs.next()) {
                    LogUtils.debugf((Object)this, (String)("storelink: no nodeid found on DB for mac address " + macaddr + " on link. .... Skipping"), (Object[])new Object[0]);
                    continue;
                }
                int ndx = 1;
                int nodeid = rs.getInt(ndx++);
                if (rs.wasNull()) {
                    LogUtils.debugf((Object)this, (String)("storelink: no nodeid found on DB for mac address " + macaddr + " on link. .... Skipping"), (Object[])new Object[0]);
                    continue;
                }
                String ipaddr = rs.getString(ndx++);
                if (rs.wasNull()) {
                    LogUtils.debugf((Object)this, (String)("storelink: no ipaddr found on DB for mac address " + macaddr + " on link. .... Skipping"), (Object[])new Object[0]);
                    continue;
                }
                if (!this.m_linkd.isInterfaceInPackage(ipaddr, discovery.getPackageName())) {
                    LogUtils.debugf((Object)this, (String)("storelink: not in package ipaddr found: " + ipaddr + " on link. .... Skipping"), (Object[])new Object[0]);
                    continue;
                }
                int ifindex = rs.getInt(ndx++);
                if (rs.wasNull()) {
                    LogUtils.debugf((Object)this, (String)("storelink: no ifindex found on DB for mac address " + macaddr + " on link."), (Object[])new Object[0]);
                    ifindex = -1;
                }
                int nodeparentid = lkm.getNodeparentid();
                int parentifindex = lkm.getParentifindex();
                DbDataLinkInterfaceEntry dbentry = DbDataLinkInterfaceEntry.get(dbConn, nodeid, ifindex);
                if (dbentry == null) {
                    dbentry = DbDataLinkInterfaceEntry.create(nodeid, ifindex);
                }
                dbentry.updateNodeParentId(nodeparentid);
                dbentry.updateParentIfIndex(parentifindex);
                dbentry.updateStatus('A');
                dbentry.set_lastpolltime(now);
                dbentry.store(dbConn);
            }
            stmt = dbConn.prepareStatement(SQL_UPDATE_DATALINKINTERFACE);
            d.watch((Object)stmt);
            stmt.setTimestamp(1, now);
            i = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)("storelink: datalinkinterface - updated to NOT ACTIVE status " + i + " rows "), (Object[])new Object[0]);
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkableNode storeSnmpCollection(LinkableNode node, SnmpCollection snmpcoll) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            Iterator<SnmpTableEntry> ite3;
            SnmpTableEntry ent;
            Connection dbConn = this.getConnection();
            d.watch((Object)dbConn);
            Timestamp now = new Timestamp(System.currentTimeMillis());
            if (snmpcoll.hasIpNetToMediaTable()) {
                Iterator ite1 = snmpcoll.getIpNetToMediaTable().getEntries().iterator();
                LogUtils.debugf((Object)this, (String)"store: saving IpNetToMediaTable to atinterface table in DB", (Object[])new Object[0]);
                ArrayList<AtInterface> atInterfaces = new ArrayList<AtInterface>();
                while (ite1.hasNext()) {
                    ent = (IpNetToMediaTableEntry)((Object)ite1.next());
                    int ifindex = ((IpNetToMediaTableEntry)ent).getIpNetToMediaIfIndex();
                    if (ifindex < 0) {
                        LogUtils.warnf((Object)this, (String)("store: invalid ifindex " + ifindex), (Object[])new Object[0]);
                        continue;
                    }
                    InetAddress ipaddress = ((IpNetToMediaTableEntry)ent).getIpNetToMediaNetAddress();
                    if (ipaddress == null || ipaddress.isLoopbackAddress() || ipaddress.getHostAddress().equals("0.0.0.0")) {
                        LogUtils.warnf((Object)this, (String)("store: ipNetToMedia invalid ip " + ipaddress.getHostAddress()), (Object[])new Object[0]);
                        continue;
                    }
                    String physAddr = ((IpNetToMediaTableEntry)ent).getIpNetToMediaPhysAddress();
                    if (physAddr == null || physAddr.equals("000000000000") || physAddr.equalsIgnoreCase("ffffffffffff")) {
                        LogUtils.warnf((Object)this, (String)("store: ipNetToMedia invalid mac address " + physAddr + " for ip " + ipaddress.getHostAddress()), (Object[])new Object[0]);
                        continue;
                    }
                    LogUtils.debugf((Object)this, (String)("store: trying save ipNetToMedia info: ipaddr " + ipaddress.getHostName() + " mac address " + physAddr + " ifindex " + ifindex), (Object[])new Object[0]);
                    AtInterface at = this.getNodeidIfindexFromIp(dbConn, ipaddress);
                    if (at == null) {
                        LogUtils.warnf((Object)this, (String)("getNodeidIfindexFromIp: no nodeid found for ipaddress " + ipaddress + "."), (Object[])new Object[0]);
                        this.sendNewSuspectEvent(ipaddress, snmpcoll.getTarget(), snmpcoll.getPackageName());
                        continue;
                    }
                    at.setMacAddress(physAddr);
                    atInterfaces.add(at);
                    DbAtInterfaceEntry atInterfaceEntry = DbAtInterfaceEntry.get(dbConn, at.getNodeId(), ipaddress.getHostAddress());
                    if (atInterfaceEntry == null) {
                        atInterfaceEntry = DbAtInterfaceEntry.create(at.getNodeId(), ipaddress.getHostAddress());
                    }
                    atInterfaceEntry.updateAtPhysAddr(physAddr);
                    atInterfaceEntry.updateSourceNodeId(node.getNodeId());
                    atInterfaceEntry.updateIfIndex(ifindex);
                    atInterfaceEntry.updateStatus('A');
                    atInterfaceEntry.set_lastpolltime(now);
                    atInterfaceEntry.store(dbConn);
                }
                node.setAtInterfaces(atInterfaces);
            }
            if (snmpcoll.hasCdpCacheTable()) {
                LogUtils.debugf((Object)this, (String)"store: saving CdpCacheTable into SnmpLinkableNode", (Object[])new Object[0]);
                ArrayList<CdpInterface> cdpInterfaces = new ArrayList<CdpInterface>();
                for (CdpCacheTableEntry cdpEntry : snmpcoll.getCdpCacheTable().getEntries()) {
                    int cdpAddrType = cdpEntry.getCdpCacheAddressType();
                    if (cdpAddrType != 1) {
                        LogUtils.warnf((Object)this, (String)("cdp Address Type not valid " + cdpAddrType), (Object[])new Object[0]);
                        continue;
                    }
                    InetAddress cdpTargetIpAddr = cdpEntry.getCdpCacheAddress();
                    if (cdpTargetIpAddr == null || cdpTargetIpAddr.isLoopbackAddress() || cdpTargetIpAddr.getHostAddress().equals("0.0.0.0")) {
                        LogUtils.warnf((Object)this, (String)("cdp Ip Address is not valid " + cdpTargetIpAddr), (Object[])new Object[0]);
                        continue;
                    }
                    LogUtils.debugf((Object)this, (String)("cdp ip address found " + cdpTargetIpAddr.getHostAddress()), (Object[])new Object[0]);
                    int cdpIfIndex = cdpEntry.getCdpCacheIfIndex();
                    if (cdpIfIndex < 0) {
                        LogUtils.warnf((Object)this, (String)("cdpIfIndex not valid " + cdpIfIndex), (Object[])new Object[0]);
                        continue;
                    }
                    LogUtils.debugf((Object)this, (String)("cdp ifindex found " + cdpIfIndex), (Object[])new Object[0]);
                    String cdpTargetDevicePort = cdpEntry.getCdpCacheDevicePort();
                    if (cdpTargetDevicePort == null) {
                        LogUtils.warnf((Object)this, (String)"cdpTargetDevicePort null. Skipping. ", (Object[])new Object[0]);
                        continue;
                    }
                    LogUtils.debugf((Object)this, (String)("cdp Target device port name found " + cdpTargetDevicePort), (Object[])new Object[0]);
                    int targetCdpNodeId = this.getNodeidFromIp(dbConn, cdpTargetIpAddr);
                    if (targetCdpNodeId == -1) {
                        LogUtils.warnf((Object)this, (String)"No nodeid found: cdp interface not added to Linkable Snmp Node. Skipping", (Object[])new Object[0]);
                        this.sendNewSuspectEvent(cdpTargetIpAddr, snmpcoll.getTarget(), snmpcoll.getPackageName());
                        continue;
                    }
                    int cdpTargetIfindex = this.getIfIndexByName(dbConn, targetCdpNodeId, cdpTargetDevicePort);
                    if (cdpTargetIfindex == -1) {
                        LogUtils.warnf((Object)this, (String)"No valid if target index found: cdp interface not added to Linkable Snmp Node. Skipping", (Object[])new Object[0]);
                        continue;
                    }
                    CdpInterface cdpIface = new CdpInterface(cdpIfIndex);
                    cdpIface.setCdpTargetNodeId(targetCdpNodeId);
                    cdpIface.setCdpTargetIpAddr(cdpTargetIpAddr);
                    cdpIface.setCdpTargetIfIndex(cdpTargetIfindex);
                    LogUtils.debugf((Object)this, (String)("Adding cdp interface to Linkable Snmp Node." + cdpIface.toString()), (Object[])new Object[0]);
                    cdpInterfaces.add(cdpIface);
                }
                node.setCdpInterfaces(cdpInterfaces);
            }
            if (snmpcoll.hasRouteTable()) {
                ArrayList<RouterInterface> routeInterfaces = new ArrayList<RouterInterface>();
                ite3 = snmpcoll.getIpRouteTable().getEntries().iterator();
                LogUtils.debugf((Object)this, (String)"store: saving ipRouteTable to iprouteinterface table in DB", (Object[])new Object[0]);
                while (ite3.hasNext()) {
                    ent = ite3.next();
                    Integer ifindex = ent.getInt32("ipRouteIfIndex");
                    if (ifindex == null || ifindex < 0) {
                        LogUtils.warnf((Object)this, (String)("store: Not valid ifindex " + ifindex + ", skipping..."), (Object[])new Object[0]);
                        continue;
                    }
                    InetAddress nexthop = ent.getIPAddress("ipRouteNextHop");
                    if (nexthop == null) {
                        LogUtils.warnf((Object)this, (String)"storeSnmpCollection: next hop null found skipping.", (Object[])new Object[0]);
                        continue;
                    }
                    InetAddress routedest = ent.getIPAddress("ipRouteDest");
                    if (routedest == null) {
                        LogUtils.warnf((Object)this, (String)"storeSnmpCollection: route dest null found skipping.", (Object[])new Object[0]);
                        continue;
                    }
                    InetAddress routemask = ent.getIPAddress("ipRouteMask");
                    if (routemask == null) {
                        LogUtils.warnf((Object)this, (String)"storeSnmpCollection: route dest null found skipping.", (Object[])new Object[0]);
                        continue;
                    }
                    LogUtils.debugf((Object)this, (String)("storeSnmpCollection: parsing routedest/routemask/nexthop: " + routedest + "/" + routemask + "/" + nexthop + " ifindex " + (ifindex < 1 ? "less than 1" : ifindex)), (Object[])new Object[0]);
                    Integer routemetric1 = ent.getInt32("ipRouteMetric1");
                    RouterInterface routeIface = this.getNodeidMaskFromIp(dbConn, nexthop);
                    if (routeIface == null) {
                        routeIface = this.getNodeFromIp(dbConn, nexthop);
                    }
                    if (routeIface == null) {
                        LogUtils.warnf((Object)this, (String)("store: No nodeid found for next hop ip" + nexthop + " Skipping ip route interface add to Linkable Snmp Node"), (Object[])new Object[0]);
                        this.sendNewSuspectEvent(nexthop, snmpcoll.getTarget(), snmpcoll.getPackageName());
                    } else {
                        int snmpiftype = -2;
                        if (ifindex > 0) {
                            snmpiftype = this.getSnmpIfType(dbConn, node.getNodeId(), ifindex);
                        }
                        if (snmpiftype == -1) {
                            LogUtils.warnf((Object)this, (String)("store: interface has wrong or null snmpiftype " + snmpiftype + " . Skipping saving to discoverylink. "), (Object[])new Object[0]);
                        } else if (nexthop.isLoopbackAddress()) {
                            LogUtils.infof((Object)this, (String)"storeSnmpCollection: next hop loopbackaddress found. Skipping saving \tto discoverylink.", (Object[])new Object[0]);
                        } else if (nexthop.getHostAddress().equals("0.0.0.0")) {
                            LogUtils.infof((Object)this, (String)"storeSnmpCollection: next hop broadcast address found. Skipping saving to discoverylink.", (Object[])new Object[0]);
                        } else if (nexthop.isMulticastAddress()) {
                            LogUtils.infof((Object)this, (String)"storeSnmpCollection: next hop multicast address found. Skipping saving to discoverylink.", (Object[])new Object[0]);
                        } else if (routemetric1 == null || routemetric1 < 0) {
                            LogUtils.infof((Object)this, (String)"storeSnmpCollection: route metric is invalid. Skipping saving to discoverylink.", (Object[])new Object[0]);
                        } else {
                            LogUtils.debugf((Object)this, (String)("store: interface has snmpiftype " + snmpiftype + " . Adding to DiscoverLink "), (Object[])new Object[0]);
                            routeIface.setRouteDest(routedest);
                            routeIface.setRoutemask(routemask);
                            routeIface.setSnmpiftype(snmpiftype);
                            routeIface.setIfindex(ifindex);
                            routeIface.setMetric(routemetric1);
                            routeIface.setNextHop(nexthop);
                            routeInterfaces.add(routeIface);
                        }
                    }
                    if (!snmpcoll.getSaveIpRouteTable()) continue;
                    Integer routemetric2 = ent.getInt32("ipRouteMetric2");
                    Integer routemetric3 = ent.getInt32("ipRouteMetric3");
                    Integer routemetric4 = ent.getInt32("ipRouteMetric4");
                    Integer routemetric5 = ent.getInt32("ipRouteMetric5");
                    Integer routetype = ent.getInt32("ipRouteType");
                    Integer routeproto = ent.getInt32("ipRouteProto");
                    DbIpRouteInterfaceEntry iprouteInterfaceEntry = DbIpRouteInterfaceEntry.get(dbConn, node.getNodeId(), routedest.getHostAddress());
                    if (iprouteInterfaceEntry == null) {
                        iprouteInterfaceEntry = DbIpRouteInterfaceEntry.create(node.getNodeId(), routedest.getHostAddress());
                    }
                    iprouteInterfaceEntry.updateRouteMask(routemask.getHostAddress());
                    iprouteInterfaceEntry.updateRouteNextHop(nexthop.getHostAddress());
                    iprouteInterfaceEntry.updateIfIndex(ifindex);
                    if (routemetric1 != null) {
                        iprouteInterfaceEntry.updateRouteMetric1(routemetric1);
                    }
                    if (routemetric2 != null) {
                        iprouteInterfaceEntry.updateRouteMetric2(routemetric2);
                    }
                    if (routemetric3 != null) {
                        iprouteInterfaceEntry.updateRouteMetric3(routemetric3);
                    }
                    if (routemetric4 != null) {
                        iprouteInterfaceEntry.updateRouteMetric4(routemetric4);
                    }
                    if (routemetric5 != null) {
                        iprouteInterfaceEntry.updateRouteMetric5(routemetric5);
                    }
                    if (routetype != null) {
                        iprouteInterfaceEntry.updateRouteType(routetype);
                    }
                    if (routeproto != null) {
                        iprouteInterfaceEntry.updateRouteProto(routeproto);
                    }
                    iprouteInterfaceEntry.updateStatus('A');
                    iprouteInterfaceEntry.set_lastpolltime(now);
                    iprouteInterfaceEntry.store(dbConn);
                }
                node.setRouteInterfaces(routeInterfaces);
            }
            LogUtils.debugf((Object)this, (String)"store: saving VlanTable in DB", (Object[])new Object[0]);
            if (snmpcoll.hasVlanTable()) {
                ArrayList<Vlan> vlans = new ArrayList<Vlan>();
                ite3 = snmpcoll.getVlanTable().getEntries().iterator();
                LogUtils.debugf((Object)this, (String)"store: saving Snmp Vlan Table to vlan table in DB", (Object[])new Object[0]);
                while (ite3.hasNext()) {
                    ent = ite3.next();
                    Integer vlanindex = ent.getInt32("vtpVlanIndex");
                    if (vlanindex == null || vlanindex < 0) {
                        LogUtils.warnf((Object)this, (String)("store: Not valid vlan ifindex" + vlanindex + " Skipping..."), (Object[])new Object[0]);
                        continue;
                    }
                    String vlanName = ent.getDisplayString("vtpVlanName");
                    if (vlanName == null) {
                        LogUtils.warnf((Object)this, (String)"store: Null vlan name. forcing to default...", (Object[])new Object[0]);
                        vlanName = "default-" + vlanindex;
                    }
                    Integer vlantype = ent.getInt32("vtpVlanType");
                    Integer vlanstatus = ent.getInt32("vtpVlanStatus");
                    DbVlanEntry vlanEntry = DbVlanEntry.get(dbConn, node.getNodeId(), vlanindex);
                    if (vlanEntry == null) {
                        vlanEntry = DbVlanEntry.create(node.getNodeId(), vlanindex);
                    }
                    vlanEntry.updateVlanName(vlanName);
                    if (vlantype != null) {
                        vlanEntry.updateVlanType(vlantype);
                    } else {
                        vlantype = 0;
                    }
                    if (vlanstatus != null) {
                        vlanEntry.updateVlanStatus(vlanstatus);
                    } else {
                        vlanstatus = 0;
                    }
                    vlanEntry.updateStatus('A');
                    vlanEntry.set_lastpolltime(now);
                    LogUtils.debugf((Object)this, (String)"vlanEntry = %s", (Object[])new Object[]{vlanEntry});
                    vlanEntry.store(dbConn);
                    Vlan vlan = new Vlan(vlanindex, vlanName, vlanstatus, vlantype);
                    vlans.add(vlan);
                }
                node.setVlans(vlans);
            }
            LogUtils.debugf((Object)this, (String)"store: saving SnmpVlanCollection's in DB", (Object[])new Object[0]);
            Iterator<Map.Entry<Vlan, SnmpVlanCollection>> ite4 = snmpcoll.getSnmpVlanCollections().entrySet().iterator();
            SnmpVlanCollection snmpVlanColl = null;
            Vlan vlan = null;
            while (ite4.hasNext()) {
                int curfdbstatus;
                Map.Entry<Vlan, SnmpVlanCollection> entry = ite4.next();
                vlan = entry.getKey();
                int vlanid = vlan.getVlanIndex();
                String vlanname = vlan.getVlanName();
                String vlanindex = Integer.toString(vlanid);
                LogUtils.debugf((Object)this, (String)("store: parsing VLAN " + vlanindex + " VLAN_NAME " + vlanname), (Object[])new Object[0]);
                snmpVlanColl = entry.getValue();
                if (!snmpVlanColl.hasDot1dBase()) continue;
                LogUtils.debugf((Object)this, (String)"store: saving Dot1dBaseGroup in stpnode table", (Object[])new Object[0]);
                Dot1dBaseGroup dod1db = snmpVlanColl.getDot1dBase();
                DbStpNodeEntry dbStpNodeEntry = null;
                String baseBridgeAddress = dod1db.getBridgeAddress();
                if (baseBridgeAddress == null || baseBridgeAddress == "000000000000") {
                    LogUtils.warnf((Object)this, (String)"store: invalid base bridge address: %s", (Object[])new Object[]{baseBridgeAddress});
                    continue;
                }
                node.addBridgeIdentifier(baseBridgeAddress, vlanindex);
                int basenumports = dod1db.getNumberOfPorts();
                int bridgetype = dod1db.getBridgeType();
                if (snmpcoll.getSaveStpNodeTable()) {
                    dbStpNodeEntry = DbStpNodeEntry.get(dbConn, node.getNodeId(), vlanid);
                    if (dbStpNodeEntry == null) {
                        dbStpNodeEntry = DbStpNodeEntry.create(node.getNodeId(), vlanid);
                    }
                    dbStpNodeEntry.updateBaseBridgeAddress(baseBridgeAddress);
                    dbStpNodeEntry.updateBaseNumPorts(basenumports);
                    dbStpNodeEntry.updateBaseType(bridgetype);
                    dbStpNodeEntry.updateBaseVlanName(vlanname);
                }
                if (snmpVlanColl.hasDot1dStp()) {
                    LogUtils.debugf((Object)this, (String)"store: adding Dot1dStpGroup in stpnode table", (Object[])new Object[0]);
                    Dot1dStpGroup dod1stp = snmpVlanColl.getDot1dStp();
                    int protospec = dod1stp.getStpProtocolSpecification();
                    int stppriority = dod1stp.getStpPriority();
                    int stprootcost = dod1stp.getStpRootCost();
                    int stprootport = dod1stp.getStpRootPort();
                    String stpDesignatedRoot = dod1stp.getStpDesignatedRoot();
                    if (stpDesignatedRoot == null || stpDesignatedRoot == "0000000000000000") {
                        LogUtils.debugf((Object)this, (String)("store: Dot1dStpGroup found stpDesignatedRoot " + stpDesignatedRoot + " not adding to Linkable node"), (Object[])new Object[0]);
                        stpDesignatedRoot = "0000000000000000";
                    } else {
                        node.setVlanStpRoot(vlanindex, stpDesignatedRoot);
                    }
                    if (snmpcoll.getSaveStpNodeTable()) {
                        dbStpNodeEntry.updateStpProtocolSpecification(protospec);
                        dbStpNodeEntry.updateStpPriority(stppriority);
                        dbStpNodeEntry.updateStpDesignatedRoot(stpDesignatedRoot);
                        dbStpNodeEntry.updateStpRootCost(stprootcost);
                        dbStpNodeEntry.updateStpRootPort(stprootport);
                    }
                }
                if (snmpcoll.getSaveStpNodeTable()) {
                    dbStpNodeEntry.updateStatus('A');
                    dbStpNodeEntry.set_lastpolltime(now);
                    dbStpNodeEntry.store(dbConn);
                }
                if (snmpVlanColl.hasDot1dBasePortTable()) {
                    Iterator sub_ite = snmpVlanColl.getDot1dBasePortTable().getEntries().iterator();
                    LogUtils.debugf((Object)this, (String)"store: saving Dot1dBasePortTable in stpinterface table", (Object[])new Object[0]);
                    while (sub_ite.hasNext()) {
                        Dot1dBasePortTableEntry dot1dbaseptentry = (Dot1dBasePortTableEntry)((Object)sub_ite.next());
                        int baseport = dot1dbaseptentry.getBaseBridgePort();
                        int ifindex = dot1dbaseptentry.getBaseBridgePortIfindex();
                        if (baseport == -1 || ifindex == -1) {
                            LogUtils.warnf((Object)this, (String)("store: Dot1dBasePortTable invalid baseport or ifindex " + baseport + " / " + ifindex), (Object[])new Object[0]);
                            continue;
                        }
                        node.setIfIndexBridgePort(ifindex, baseport);
                        if (!snmpcoll.getSaveStpInterfaceTable()) continue;
                        DbStpInterfaceEntry dbStpIntEntry = DbStpInterfaceEntry.get(dbConn, node.getNodeId(), baseport, vlanid);
                        if (dbStpIntEntry == null) {
                            dbStpIntEntry = DbStpInterfaceEntry.create(node.getNodeId(), baseport, vlanid);
                        }
                        dbStpIntEntry.updateIfIndex(ifindex);
                        dbStpIntEntry.updateStatus('A');
                        dbStpIntEntry.set_lastpolltime(now);
                        dbStpIntEntry.store(dbConn);
                    }
                }
                if (snmpVlanColl.hasDot1dStpPortTable()) {
                    LogUtils.debugf((Object)this, (String)"store: adding Dot1dStpPortTable in stpinterface table", (Object[])new Object[0]);
                    for (Dot1dStpPortTableEntry dot1dstpptentry : snmpVlanColl.getDot1dStpPortTable().getEntries()) {
                        DbStpInterfaceEntry dbStpIntEntry = null;
                        int stpport = dot1dstpptentry.getDot1dStpPort();
                        if (stpport == -1) {
                            LogUtils.warnf((Object)this, (String)"store: Dot1dStpPortTable found invalid stp port. Skipping", (Object[])new Object[0]);
                            continue;
                        }
                        if (snmpcoll.getSaveStpInterfaceTable() && (dbStpIntEntry = DbStpInterfaceEntry.get(dbConn, node.getNodeId(), stpport, vlanid)) == null) {
                            LogUtils.warnf((Object)this, (String)("store: StpInterface not found in database when storing STP info for bridge node with nodeid " + node.getNodeId() + " bridgeport number " + stpport + " and vlan index " + vlanindex + " skipping."), (Object[])new Object[0]);
                        }
                        String stpPortDesignatedBridge = dot1dstpptentry.getDot1dStpPortDesignatedBridge();
                        String stpPortDesignatedPort = dot1dstpptentry.getDot1dStpPortDesignatedPort();
                        if (stpPortDesignatedBridge == null || stpPortDesignatedBridge.equals("0000000000000000")) {
                            LogUtils.warnf((Object)this, (String)("store: " + stpPortDesignatedBridge + " designated bridge is invalid not adding to discoveryLink"), (Object[])new Object[0]);
                            stpPortDesignatedBridge = "0000000000000000";
                        } else if (stpPortDesignatedPort == null || stpPortDesignatedPort.equals("0000")) {
                            LogUtils.warnf((Object)this, (String)("store: " + stpPortDesignatedPort + " designated port is invalid not adding to discoveryLink"), (Object[])new Object[0]);
                            stpPortDesignatedPort = "0000";
                        } else {
                            BridgeStpInterface stpIface = new BridgeStpInterface(stpport, vlanindex);
                            stpIface.setStpPortDesignatedBridge(stpPortDesignatedBridge);
                            stpIface.setStpPortDesignatedPort(stpPortDesignatedPort);
                            node.addStpInterface(stpIface);
                        }
                        if (!snmpcoll.getSaveStpInterfaceTable()) continue;
                        dbStpIntEntry.updateStpPortState(dot1dstpptentry.getDot1dStpPortState());
                        dbStpIntEntry.updateStpPortPathCost(dot1dstpptentry.getDot1dStpPortPathCost());
                        dbStpIntEntry.updateStpportDesignatedBridge(stpPortDesignatedBridge);
                        dbStpIntEntry.updateStpportDesignatedRoot(dot1dstpptentry.getDot1dStpPortDesignatedRoot());
                        dbStpIntEntry.updateStpPortDesignatedCost(dot1dstpptentry.getDot1dStpPortDesignatedCost());
                        dbStpIntEntry.updateStpportDesignatedPort(stpPortDesignatedPort);
                        dbStpIntEntry.updateStatus('A');
                        dbStpIntEntry.set_lastpolltime(now);
                        dbStpIntEntry.store(dbConn);
                    }
                }
                if (snmpVlanColl.hasDot1dTpFdbTable()) {
                    LogUtils.debugf((Object)this, (String)"store: parsing Dot1dTpFdbTable", (Object[])new Object[0]);
                    for (Dot1dTpFdbTableEntry dot1dfdbentry : snmpVlanColl.getDot1dFdbTable().getEntries()) {
                        String curMacAddress = dot1dfdbentry.getDot1dTpFdbAddress();
                        if (curMacAddress == null || curMacAddress.equals("000000000000")) {
                            LogUtils.warnf((Object)this, (String)("store: Dot1dTpFdbTable invalid macaddress " + curMacAddress + " Skipping."), (Object[])new Object[0]);
                            continue;
                        }
                        LogUtils.debugf((Object)this, (String)("store: Dot1dTpFdbTable found macaddress " + curMacAddress), (Object[])new Object[0]);
                        int fdbport = dot1dfdbentry.getDot1dTpFdbPort();
                        if (fdbport == 0 || fdbport == -1) {
                            LogUtils.debugf((Object)this, (String)("store: Dot1dTpFdbTable mac learned on invalid port " + fdbport + " . Skipping"), (Object[])new Object[0]);
                            continue;
                        }
                        LogUtils.debugf((Object)this, (String)("store: Dot1dTpFdbTable mac address found  on bridge port " + fdbport), (Object[])new Object[0]);
                        curfdbstatus = dot1dfdbentry.getDot1dTpFdbStatus();
                        if (curfdbstatus == 3) {
                            node.addMacAddress(fdbport, curMacAddress, vlanindex);
                            LogUtils.debugf((Object)this, (String)"store: Dot1dTpFdbTable found learned status on bridge port ", (Object[])new Object[0]);
                            continue;
                        }
                        if (curfdbstatus == 4) {
                            node.addBridgeIdentifier(curMacAddress);
                            LogUtils.debugf((Object)this, (String)"store: Dot1dTpFdbTable mac is bridge identifier", (Object[])new Object[0]);
                            continue;
                        }
                        if (curfdbstatus == 2) {
                            LogUtils.debugf((Object)this, (String)"store: Dot1dTpFdbTable found INVALID status. Skipping", (Object[])new Object[0]);
                            continue;
                        }
                        if (curfdbstatus == 5) {
                            LogUtils.debugf((Object)this, (String)"store: Dot1dTpFdbTable found MGMT status. Skipping", (Object[])new Object[0]);
                            continue;
                        }
                        if (curfdbstatus == 1) {
                            LogUtils.debugf((Object)this, (String)"store: Dot1dTpFdbTable found OTHER status. Skipping", (Object[])new Object[0]);
                            continue;
                        }
                        if (curfdbstatus != -1) continue;
                        LogUtils.warnf((Object)this, (String)"store: Dot1dTpFdbTable null status found. Skipping", (Object[])new Object[0]);
                    }
                }
                if (snmpVlanColl.hasQBridgeDot1dTpFdbTable()) {
                    LogUtils.debugf((Object)this, (String)"store: parsing QBridgeDot1dTpFdbTable", (Object[])new Object[0]);
                    for (QBridgeDot1dTpFdbTableEntry dot1dfdbentry : snmpVlanColl.getQBridgeDot1dFdbTable().getEntries()) {
                        String curMacAddress = dot1dfdbentry.getQBridgeDot1dTpFdbAddress();
                        if (curMacAddress == null || curMacAddress.equals("000000000000")) {
                            LogUtils.warnf((Object)this, (String)("store: QBridgeDot1dTpFdbTable invalid macaddress " + curMacAddress + " Skipping."), (Object[])new Object[0]);
                            continue;
                        }
                        LogUtils.debugf((Object)this, (String)("store: Dot1dTpFdbTable found macaddress " + curMacAddress), (Object[])new Object[0]);
                        int fdbport = dot1dfdbentry.getQBridgeDot1dTpFdbPort();
                        if (fdbport == 0 || fdbport == -1) {
                            LogUtils.debugf((Object)this, (String)("store: QBridgeDot1dTpFdbTable mac learned on invalid port " + fdbport + " . Skipping"), (Object[])new Object[0]);
                            continue;
                        }
                        LogUtils.debugf((Object)this, (String)("store: QBridgeDot1dTpFdbTable mac address found  on bridge port " + fdbport), (Object[])new Object[0]);
                        curfdbstatus = dot1dfdbentry.getQBridgeDot1dTpFdbStatus();
                        if (curfdbstatus == 3) {
                            node.addMacAddress(fdbport, curMacAddress, vlanindex);
                            LogUtils.debugf((Object)this, (String)"store: QBridgeDot1dTpFdbTable found learned status on bridge port ", (Object[])new Object[0]);
                            continue;
                        }
                        if (curfdbstatus == 4) {
                            node.addBridgeIdentifier(curMacAddress);
                            LogUtils.debugf((Object)this, (String)"store: QBridgeDot1dTpFdbTable mac is bridge identifier", (Object[])new Object[0]);
                            continue;
                        }
                        if (curfdbstatus == 2) {
                            LogUtils.debugf((Object)this, (String)"store: QBridgeDot1dTpFdbTable found INVALID status. Skipping", (Object[])new Object[0]);
                            continue;
                        }
                        if (curfdbstatus == 5) {
                            LogUtils.debugf((Object)this, (String)"store: QBridgeDot1dTpFdbTable found MGMT status. Skipping", (Object[])new Object[0]);
                            continue;
                        }
                        if (curfdbstatus == 1) {
                            LogUtils.debugf((Object)this, (String)"store: QBridgeDot1dTpFdbTable found OTHER status. Skipping", (Object[])new Object[0]);
                            continue;
                        }
                        if (curfdbstatus != -1) continue;
                        LogUtils.warnf((Object)this, (String)"store: QBridgeDot1dTpFdbTable null status found. Skipping", (Object[])new Object[0]);
                    }
                }
                PreparedStatement stmt = null;
                stmt = dbConn.prepareStatement(SQL_GET_SNMPPHYSADDR_SNMPINTERFACE);
                d.watch((Object)stmt);
                stmt.setInt(1, node.getNodeId());
                ResultSet rs = stmt.executeQuery();
                d.watch((Object)rs);
                while (rs.next()) {
                    String macaddr = rs.getString("snmpphysaddr");
                    if (macaddr == null) continue;
                    node.addBridgeIdentifier(macaddr);
                    LogUtils.debugf((Object)this, (String)("setBridgeIdentifierFromSnmpInterface: found bridge identifier " + macaddr + " from snmpinterface db table"), (Object[])new Object[0]);
                }
            }
            this.update(dbConn, now, node.getNodeId());
            LinkableNode linkableNode = node;
            return linkableNode;
        }
        catch (Throwable e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"Unexpected exception while storing SNMP collections: %s", (Object[])new Object[]{e.getMessage()});
            LinkableNode linkableNode = null;
            return linkableNode;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Connection dbConn, Timestamp now, int nodeid) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement stmt = null;
            int i = 0;
            stmt = dbConn.prepareStatement(SQL_UPDATE_ATINTERFACE);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            stmt.setTimestamp(2, now);
            i = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)("store: SQL statement UPDATE atinterface set status = 'N'  WHERE sourcenodeid = ? AND lastpolltime < ? AND status = 'A'. " + i + " rows UPDATED for nodeid=" + nodeid + "."), (Object[])new Object[0]);
            stmt = dbConn.prepareStatement(SQL_UPDATE_VLAN);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            stmt.setTimestamp(2, now);
            i = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)("store: SQL statement UPDATE vlan set status = 'N'  WHERE nodeid =? AND lastpolltime < ? AND status = 'A'. " + i + " rows UPDATED for nodeid=" + nodeid + "."), (Object[])new Object[0]);
            stmt = dbConn.prepareStatement(SQL_UPDATE_IPROUTEINTERFACE);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            stmt.setTimestamp(2, now);
            i = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)("store: SQL statement UPDATE iprouteinterface set status = 'N'  WHERE nodeid = ? AND lastpolltime < ? AND status = 'A'. " + i + " rows UPDATED for nodeid=" + nodeid + "."), (Object[])new Object[0]);
            stmt = dbConn.prepareStatement(SQL_UPDATE_STPNODE);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            stmt.setTimestamp(2, now);
            i = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)("store: SQL statement UPDATE stpnode set status = 'N'  WHERE nodeid = ? AND lastpolltime < ? AND status = 'A'. " + i + " rows UPDATED for nodeid=" + nodeid + "."), (Object[])new Object[0]);
            stmt = dbConn.prepareStatement(SQL_UPDATE_STPINTERFACE);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            stmt.setTimestamp(2, now);
            i = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)("store: SQL statement UPDATE stpinterface set status = 'N'  WHERE nodeid = ? AND lastpolltime < ? AND status = 'A'. " + i + " rows UPDATED for nodeid=" + nodeid + "."), (Object[])new Object[0]);
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(int nodeid, char status) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection dbConn = this.getConnection();
            d.watch((Object)dbConn);
            PreparedStatement stmt = null;
            int i = 0;
            stmt = dbConn.prepareStatement(SQL_UPDATE_VLAN_STATUS);
            d.watch((Object)stmt);
            stmt.setString(1, new String(new char[]{status}));
            stmt.setInt(2, nodeid);
            i = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)("update: SQL statement UPDATE vlan set status = ?  WHERE nodeid = ? . " + i + " rows UPDATED for nodeid=" + nodeid + "."), (Object[])new Object[0]);
            stmt = dbConn.prepareStatement(SQL_UPDATE_ATINTERFACE_STATUS);
            d.watch((Object)stmt);
            stmt.setString(1, new String(new char[]{status}));
            stmt.setInt(2, nodeid);
            stmt.setInt(3, nodeid);
            i = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)("update: SQL statement UPDATE atinterface set status = ?  WHERE sourcenodeid = ? OR nodeid = ?. " + i + " rows UPDATED for nodeid=" + nodeid + "."), (Object[])new Object[0]);
            stmt = dbConn.prepareStatement(SQL_UPDATE_IPROUTEINTERFACE_STATUS);
            d.watch((Object)stmt);
            stmt.setString(1, new String(new char[]{status}));
            stmt.setInt(2, nodeid);
            i = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)("update: SQL statement UPDATE iprouteinterface set status = ? WHERE nodeid = ? . " + i + " rows UPDATED for nodeid=" + nodeid + "."), (Object[])new Object[0]);
            stmt = dbConn.prepareStatement(SQL_UPDATE_STPNODE_STATUS);
            d.watch((Object)stmt);
            stmt.setString(1, new String(new char[]{status}));
            stmt.setInt(2, nodeid);
            i = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)("update: SQL statement UPDATE stpnode set status = ?  WHERE nodeid = ? . " + i + " rows UPDATED for nodeid=" + nodeid + "."), (Object[])new Object[0]);
            stmt = dbConn.prepareStatement(SQL_UPDATE_STPINTERFACE_STATUS);
            d.watch((Object)stmt);
            stmt.setString(1, new String(new char[]{status}));
            stmt.setInt(2, nodeid);
            i = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)("update: SQL statement UPDATE stpinterface set status = ? WHERE nodeid = ? . " + i + " rows UPDATED for nodeid=" + nodeid + "."), (Object[])new Object[0]);
            stmt = dbConn.prepareStatement(SQL_UPDATE_DATALINKINTERFACE_STATUS);
            d.watch((Object)stmt);
            stmt.setString(1, new String(new char[]{status}));
            stmt.setInt(2, nodeid);
            stmt.setInt(3, nodeid);
            i = stmt.executeUpdate();
            LogUtils.debugf((Object)this, (String)("update: SQL statement UPDATE datalinkinterface set status = ? WHERE nodeid = ? OR nodeparentid = ? . " + i + " rows UPDATED for nodeid=" + nodeid + "."), (Object[])new Object[0]);
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNodeidFromIp(Connection dbConn, InetAddress ipaddr) throws SQLException {
        if (ipaddr.isLoopbackAddress() || ipaddr.getHostAddress().equals("0.0.0.0")) {
            return -1;
        }
        int nodeid = -1;
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement stmt = null;
            stmt = dbConn.prepareStatement(SQL_GET_NODEID);
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr.getHostAddress());
            LogUtils.debugf((Object)this, (String)("getNodeidFromIp: executing query SELECT node.nodeid FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE nodetype = 'A' AND ipaddr = ? with ip address=" + ipaddr.getHostAddress()), (Object[])new Object[0]);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (!rs.next()) {
                LogUtils.debugf((Object)this, (String)"getNodeidFromIp: no entries found in ipinterface", (Object[])new Object[0]);
                int n = -1;
                return n;
            }
            int ndx = 1;
            nodeid = rs.getInt(ndx++);
            if (rs.wasNull()) {
                nodeid = -1;
            }
            LogUtils.debugf((Object)this, (String)("getNodeidFromIp: found nodeid " + nodeid), (Object[])new Object[0]);
        }
        finally {
            d.cleanUp();
        }
        return nodeid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RouterInterface getNodeidMaskFromIp(Connection dbConn, InetAddress ipaddr) throws SQLException {
        if (ipaddr.isLoopbackAddress() || ipaddr.getHostAddress().equals("0.0.0.0")) {
            return null;
        }
        int nodeid = -1;
        int ifindex = -1;
        String netmask = null;
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement(SQL_GET_NODEID__IFINDEX_MASK);
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr.getHostAddress());
            LogUtils.debugf((Object)this, (String)("getNodeidMaskFromIp: executing query SELECT node.nodeid,snmpinterface.snmpifindex,snmpinterface.snmpipadentnetmask FROM node LEFT JOIN snmpinterface ON node.nodeid = snmpinterface.nodeid WHERE nodetype = 'A' AND ipaddr = ? with ip address=" + ipaddr.getHostAddress()), (Object[])new Object[0]);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (!rs.next()) {
                LogUtils.debugf((Object)this, (String)"getNodeidMaskFromIp: no entries found in snmpinterface", (Object[])new Object[0]);
                RouterInterface routerInterface = null;
                return routerInterface;
            }
            nodeid = rs.getInt("nodeid");
            if (rs.wasNull()) {
                LogUtils.debugf((Object)this, (String)"getNodeidMaskFromIp: no nodeid found", (Object[])new Object[0]);
                RouterInterface routerInterface = null;
                return routerInterface;
            }
            ifindex = rs.getInt("snmpifindex");
            if (rs.wasNull()) {
                LogUtils.debugf((Object)this, (String)"getNodeidMaskFromIp: no snmsnmpifindex found", (Object[])new Object[0]);
                ifindex = -1;
            }
            netmask = rs.getString("snmpipadentnetmask");
            if (rs.wasNull()) {
                LogUtils.debugf((Object)this, (String)"getNodeidMaskFromIp: no snmpipadentnetmask found", (Object[])new Object[0]);
                netmask = "255.255.255.255";
            }
        }
        finally {
            d.cleanUp();
        }
        RouterInterface ri = new RouterInterface(nodeid, ifindex, netmask);
        return ri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RouterInterface getNodeFromIp(Connection dbConn, InetAddress ipaddr) throws SQLException {
        if (ipaddr.isLoopbackAddress() || ipaddr.getHostAddress().equals("0.0.0.0")) {
            return null;
        }
        int nodeid = -1;
        int ifindex = -1;
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement(SQL_GET_NODEID);
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr.getHostAddress());
            LogUtils.debugf((Object)this, (String)("getNodeFromIp: executing query SELECT node.nodeid FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE nodetype = 'A' AND ipaddr = ? with ip address=" + ipaddr.getHostAddress()), (Object[])new Object[0]);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (!rs.next()) {
                LogUtils.debugf((Object)this, (String)"getNodeFromIp: no entries found in snmpinterface", (Object[])new Object[0]);
                RouterInterface routerInterface = null;
                return routerInterface;
            }
            nodeid = rs.getInt("nodeid");
            if (rs.wasNull()) {
                LogUtils.debugf((Object)this, (String)"getNodeFromIp: no nodeid found", (Object[])new Object[0]);
                RouterInterface routerInterface = null;
                return routerInterface;
            }
        }
        finally {
            d.cleanUp();
        }
        RouterInterface ri = new RouterInterface(nodeid, ifindex);
        return ri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AtInterface getNodeidIfindexFromIp(Connection dbConn, InetAddress ipaddr) throws SQLException {
        if (ipaddr.isLoopbackAddress() || ipaddr.getHostAddress().equals("0.0.0.0")) {
            return null;
        }
        int atnodeid = -1;
        int atifindex = -1;
        AtInterface ati = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement stmt = dbConn.prepareStatement(SQL_GET_NODEID_IFINDEX_IPINT);
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr.getHostAddress());
            LogUtils.debugf((Object)this, (String)("getNodeidIfindexFromIp: executing SQL Statement SELECT node.nodeid,ipinterface.ifindex FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE nodetype = 'A' AND ipaddr = ? with ip address=" + ipaddr.getHostAddress()), (Object[])new Object[0]);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (!rs.next()) {
                AtInterface atInterface = null;
                return atInterface;
            }
            atnodeid = rs.getInt("nodeid");
            if (rs.wasNull()) {
                AtInterface atInterface = null;
                return atInterface;
            }
            ati = new AtInterface(atnodeid, ipaddr.getHostAddress());
            atifindex = rs.getInt("ifindex");
            if (rs.wasNull()) {
                LogUtils.infof((Object)this, (String)("getNodeidIfindexFromIp: nodeid " + atnodeid + " no ifindex (-1) found for ipaddress " + ipaddr + "."), (Object[])new Object[0]);
            } else {
                LogUtils.infof((Object)this, (String)("getNodeidIfindexFromIp: nodeid " + atnodeid + " ifindex " + atifindex + " found for ipaddress " + ipaddr + "."), (Object[])new Object[0]);
                ati.setIfindex(atifindex);
            }
        }
        finally {
            d.cleanUp();
        }
        return ati;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSnmpIfType(Connection dbConn, int nodeid, int ifindex) throws SQLException {
        int snmpiftype = -1;
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement(SQL_GET_SNMPIFTYPE);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            stmt.setInt(2, ifindex);
            LogUtils.debugf((Object)this, (String)("getSnmpIfType: executing query SELECT snmpiftype FROM snmpinterface WHERE nodeid = ? AND snmpifindex = ? with nodeid=" + nodeid + " and ifindex=" + ifindex), (Object[])new Object[0]);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (!rs.next()) {
                LogUtils.debugf((Object)this, (String)"getSnmpIfType: no entries found in snmpinterface", (Object[])new Object[0]);
                int n = -1;
                return n;
            }
            int ndx = 1;
            snmpiftype = rs.getInt(ndx++);
            if (rs.wasNull()) {
                snmpiftype = -1;
            }
            LogUtils.debugf((Object)this, (String)("getSnmpIfType: found in snmpinterface snmpiftype=" + snmpiftype), (Object[])new Object[0]);
            int n = snmpiftype;
            return n;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIfIndexByName(Connection dbConn, int nodeid, String ifName) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement stmt = null;
            stmt = dbConn.prepareStatement(SQL_GET_IFINDEX_SNMPINTERFACE_NAME);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            stmt.setString(2, ifName);
            stmt.setString(3, ifName);
            LogUtils.debugf((Object)this, (String)("getIfIndexByName: executing querySELECT snmpifindex FROM snmpinterface WHERE nodeid = ? AND (snmpifname = ? OR snmpifdescr = ?) nodeid =" + nodeid + "and ifName=" + ifName), (Object[])new Object[0]);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (!rs.next()) {
                LogUtils.debugf((Object)this, (String)"getIfIndexByName: no entries found in snmpinterface", (Object[])new Object[0]);
                int n = -1;
                return n;
            }
            int ndx = 1;
            if (rs.wasNull()) {
                LogUtils.debugf((Object)this, (String)"getIfIndexByName: no entries found in snmpinterface", (Object[])new Object[0]);
                int n = -1;
                return n;
            }
            int ifindex = rs.getInt(ndx++);
            LogUtils.debugf((Object)this, (String)("getIfIndexByName: found ifindex=" + ifindex), (Object[])new Object[0]);
            int n = ifindex;
            return n;
        }
        finally {
            d.cleanUp();
        }
    }

    private void sendNewSuspectEvent(InetAddress ipaddress, InetAddress ipowner, String name) {
        this.m_linkd.sendNewSuspectEvent(ipaddress.getHostAddress(), ipowner.getHostAddress(), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkableNode getSnmpNode(int nodeid) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection dbConn = this.getConnection();
            d.watch((Object)dbConn);
            LinkableNode node = null;
            PreparedStatement stmt = dbConn.prepareStatement(SQL_SELECT_SNMP_NODE);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            LogUtils.debugf((Object)this, (String)("getSnmpCollection: execute 'SELECT nodesysoid, ipaddr FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE node.nodeid = ? AND nodetype = 'A' AND issnmpprimary = 'P'' with nodeid =" + nodeid), (Object[])new Object[0]);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                String sysoid = rs.getString("nodesysoid");
                if (sysoid == null) {
                    sysoid = "-1";
                }
                String ipaddr = rs.getString("ipaddr");
                LogUtils.debugf((Object)this, (String)("getSnmpCollection: found nodeid " + nodeid + " ipaddr " + ipaddr + " sysoid " + sysoid), (Object[])new Object[0]);
                node = new LinkableNode(nodeid, ipaddr, sysoid);
            }
            LinkableNode linkableNode = node;
            return linkableNode;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LinkableNode> getSnmpNodeList() throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection dbConn = this.getConnection();
            d.watch((Object)dbConn);
            ArrayList<LinkableNode> linknodes = new ArrayList<LinkableNode>();
            PreparedStatement ps = dbConn.prepareStatement(SQL_SELECT_SNMP_NODES);
            d.watch((Object)ps);
            ResultSet rs = ps.executeQuery();
            d.watch((Object)rs);
            LogUtils.debugf((Object)this, (String)"getNodesInfo: execute query: \" SELECT node.nodeid, nodesysoid, ipaddr FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE nodetype = 'A' AND issnmpprimary = 'P'\"", (Object[])new Object[0]);
            while (rs.next()) {
                int nodeid = rs.getInt("nodeid");
                String ipaddr = rs.getString("ipaddr");
                String sysoid = rs.getString("nodesysoid");
                if (sysoid == null) {
                    sysoid = "-1";
                }
                LogUtils.debugf((Object)this, (String)("getNodesInfo: found node element: nodeid " + nodeid + " ipaddr " + ipaddr + " sysoid " + sysoid), (Object[])new Object[0]);
                LinkableNode node = new LinkableNode(nodeid, ipaddr, sysoid);
                linknodes.add(node);
            }
            LogUtils.debugf((Object)this, (String)("getNodesInfo: found " + linknodes.size() + " snmp primary ip nodes"), (Object[])new Object[0]);
            ArrayList<LinkableNode> arrayList = linknodes;
            return arrayList;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDeletedNodes() throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection dbConn = this.getConnection();
            d.watch((Object)dbConn);
            int i = 0;
            PreparedStatement ps = dbConn.prepareStatement(SQL_UPDATE_ATINTERFACE_D);
            d.watch((Object)ps);
            i = ps.executeUpdate();
            LogUtils.infof((Object)this, (String)("updateDeletedNodes: execute 'UPDATE atinterface set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D' ' updated rows: " + i), (Object[])new Object[0]);
            ps = dbConn.prepareStatement(SQL_UPDATE_VLAN_D);
            d.watch((Object)ps);
            i = ps.executeUpdate();
            LogUtils.infof((Object)this, (String)("updateDeletedNodes: execute 'UPDATE vlan set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D' ' updated rows: " + i), (Object[])new Object[0]);
            ps = dbConn.prepareStatement(SQL_UPDATE_STPNODE_D);
            d.watch((Object)ps);
            i = ps.executeUpdate();
            LogUtils.infof((Object)this, (String)("updateDeletedNodes: execute 'UPDATE stpnode set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D'' updated rows: " + i), (Object[])new Object[0]);
            ps = dbConn.prepareStatement(SQL_UPDATE_STPINTERFACE_D);
            d.watch((Object)ps);
            i = ps.executeUpdate();
            LogUtils.infof((Object)this, (String)("updateDeletedNodes: execute 'UPDATE stpinterface set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D'' updated rows: " + i), (Object[])new Object[0]);
            ps = dbConn.prepareStatement(SQL_UPDATE_IPROUTEINTERFACE_D);
            d.watch((Object)ps);
            i = ps.executeUpdate();
            LogUtils.infof((Object)this, (String)("updateDeletedNodes: execute 'UPDATE iprouteinterface set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D''updated rows: " + i), (Object[])new Object[0]);
            ps = dbConn.prepareStatement(SQL_UPDATE_DATALINKINTERFACE_D);
            d.watch((Object)ps);
            i = ps.executeUpdate();
            LogUtils.infof((Object)this, (String)("updateDeletedNodes: execute 'UPDATE datalinkinterface set status = 'D' WHERE (nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) OR nodeparentid IN (SELECT nodeid from node WHERE nodetype = 'D' )) AND status <> 'D'' updated rows: " + i), (Object[])new Object[0]);
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateForInterface(int nodeId, String ipAddr, int ifIndex, char status) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection dbConn = this.getConnection();
            d.watch((Object)dbConn);
            PreparedStatement ps = null;
            int i = 0;
            if (!EventUtils.isNonIpInterface(ipAddr)) {
                ps = dbConn.prepareStatement(SQL_UPDATE_ATINTERFACE_STATUS_INTFC);
                d.watch((Object)ps);
                ps.setString(1, new String(new char[]{status}));
                ps.setInt(2, nodeId);
                ps.setString(3, ipAddr);
                i = ps.executeUpdate();
                LogUtils.infof((Object)this, (String)("updateForInterface: atinterface: node = " + nodeId + ", IP Address = " + ipAddr + ", status = " + status + ": updated rows = " + i), (Object[])new Object[0]);
            }
            if (ifIndex > -1) {
                ps = dbConn.prepareStatement(SQL_UPDATE_ATINTERFACE_STATUS_SRC_INTFC);
                d.watch((Object)ps);
                ps.setString(1, new String(new char[]{status}));
                ps.setInt(2, nodeId);
                ps.setInt(3, ifIndex);
                i = ps.executeUpdate();
                LogUtils.infof((Object)this, (String)("updateForInterface: atinterface: source node = " + nodeId + ", ifIndex = " + ifIndex + ", status = " + status + ": updated rows = " + i), (Object[])new Object[0]);
                ps = dbConn.prepareStatement(SQL_UPDATE_STPINTERFACE_STATUS_INTFC);
                d.watch((Object)ps);
                ps.setString(1, new String(new char[]{status}));
                ps.setInt(2, nodeId);
                ps.setInt(3, ifIndex);
                i = ps.executeUpdate();
                LogUtils.infof((Object)this, (String)("updateForInterface: stpinterface: node = " + nodeId + ", ifIndex = " + ifIndex + ", status = " + status + ": updated rows = " + i), (Object[])new Object[0]);
                ps = dbConn.prepareStatement(SQL_UPDATE_IPROUTEINTERFACE_STATUS_INTFC);
                d.watch((Object)ps);
                ps.setString(1, new String(new char[]{status}));
                ps.setInt(2, nodeId);
                ps.setInt(3, ifIndex);
                i = ps.executeUpdate();
                LogUtils.infof((Object)this, (String)("updateForInterface: iprouteinterface: node = " + nodeId + ", rpouteIfIndex = " + ifIndex + ", status = " + status + ": updated rows = " + i), (Object[])new Object[0]);
                ps = dbConn.prepareStatement(SQL_UPDATE_DATALINKINTERFACE_STATUS_INTFC);
                d.watch((Object)ps);
                ps.setString(1, new String(new char[]{status}));
                ps.setInt(2, nodeId);
                ps.setInt(3, ifIndex);
                ps.setInt(4, nodeId);
                ps.setInt(5, ifIndex);
                i = ps.executeUpdate();
                LogUtils.infof((Object)this, (String)("updateForInterface: datalinkinterface: node = " + nodeId + ", ifIndex = " + ifIndex + ", status = " + status + ": updated rows = " + i), (Object[])new Object[0]);
            }
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSnmpPrimaryIp(int nodeid) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection dbConn = this.getConnection();
            d.watch((Object)dbConn);
            String ipaddr = null;
            PreparedStatement stmt = dbConn.prepareStatement(SQL_SELECT_SNMP_IP_ADDR);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            LogUtils.debugf((Object)this, (String)("getSnmpPrimaryIp: SQL statement = " + stmt.toString()), (Object[])new Object[0]);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                ipaddr = rs.getString("ipaddr");
                if (ipaddr == null) {
                    String string = null;
                    return string;
                }
                LogUtils.debugf((Object)this, (String)("getSnmpPrimaryIp: found node element: nodeid " + nodeid + " ipaddr " + ipaddr), (Object[])new Object[0]);
            }
            String string = ipaddr;
            return string;
        }
        finally {
            d.cleanUp();
        }
    }

    @Override
    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

