/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.SnmpInterfacePollerConfig;
import org.opennms.netmgt.config.SnmpInterfacePollerConfigManager;

public final class SnmpInterfacePollerConfigFactory
extends SnmpInterfacePollerConfigManager {
    private static SnmpInterfacePollerConfig m_singleton = null;
    private static boolean m_loaded = false;
    private long m_currentVersion = -1L;

    @Deprecated
    public SnmpInterfacePollerConfigFactory(long currentVersion, Reader reader, String localServer, boolean verifyServer) throws MarshalException, ValidationException, IOException {
        super(reader, localServer, verifyServer);
        this.m_currentVersion = currentVersion;
    }

    public SnmpInterfacePollerConfigFactory(long currentVersion, InputStream stream, String localServer, boolean verifyServer) throws MarshalException, ValidationException, IOException {
        super(stream, localServer, verifyServer);
        this.m_currentVersion = currentVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        OpennmsServerConfigFactory.init();
        OpennmsServerConfigFactory onmsSvrConfig = OpennmsServerConfigFactory.getInstance();
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SNMP_INTERFACE_POLLER_CONFIG_FILE_NAME);
        SnmpInterfacePollerConfigFactory.logStatic().debug("init: config file path: " + cfgFile.getPath());
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(cfgFile);
            SnmpInterfacePollerConfigFactory config = new SnmpInterfacePollerConfigFactory(cfgFile.lastModified(), stream, onmsSvrConfig.getServerName(), onmsSvrConfig.verifyServer());
            SnmpInterfacePollerConfigFactory.setInstance(config);
        }
        finally {
            if (stream != null) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }

    private static ThreadCategory logStatic() {
        return ThreadCategory.getInstance(SnmpInterfacePollerConfigFactory.class);
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        SnmpInterfacePollerConfigFactory.init();
        SnmpInterfacePollerConfigFactory.getInstance().update();
    }

    protected synchronized void saveXml(String xml) throws IOException {
        if (xml != null) {
            long timestamp = System.currentTimeMillis();
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SNMP_INTERFACE_POLLER_CONFIG_FILE_NAME);
            SnmpInterfacePollerConfigFactory.logStatic().debug("saveXml: saving config file at " + timestamp + ": " + cfgFile.getPath());
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(cfgFile), "UTF-8");
            fileWriter.write(xml);
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
            SnmpInterfacePollerConfigFactory.logStatic().debug("saveXml: finished saving config file: " + cfgFile.getPath());
        }
    }

    public static synchronized SnmpInterfacePollerConfig getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(SnmpInterfacePollerConfig instance) {
        m_singleton = instance;
        m_loaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update() throws IOException, MarshalException, ValidationException {
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SNMP_INTERFACE_POLLER_CONFIG_FILE_NAME);
        if (cfgFile.lastModified() > this.m_currentVersion) {
            this.m_currentVersion = cfgFile.lastModified();
            SnmpInterfacePollerConfigFactory.logStatic().debug("init: config file path: " + cfgFile.getPath());
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(cfgFile);
                this.reloadXML(stream);
            }
            finally {
                if (stream != null) {
                    IOUtils.closeQuietly((InputStream)stream);
                }
            }
            SnmpInterfacePollerConfigFactory.logStatic().debug("init: finished loading config file: " + cfgFile.getPath());
        }
    }
}

