/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.OwnedInterval;
import org.opennms.netmgt.config.OwnedIntervalSequence;
import org.opennms.netmgt.config.Owner;
import org.opennms.netmgt.config.TimeInterval;
import org.opennms.netmgt.config.common.BasicSchedule;
import org.opennms.netmgt.config.common.Time;

public class BasicScheduleUtils {
    protected static Map<String, Integer> m_dayOfWeekMap;
    public static String FORMAT1;
    public static String FORMAT2;

    public static boolean isTimeInSchedule(Calendar cal, BasicSchedule sched) {
        LogUtils.debugf(BasicScheduleUtils.class, (String)"isTimeInOutage: checking for time '%s' in schedule '%s'", (Object[])new Object[]{cal.getTime(), sched.getName()});
        if (cal == null || sched == null) {
            return false;
        }
        GregorianCalendar outCalBegin = new GregorianCalendar();
        GregorianCalendar outCalEnd = new GregorianCalendar();
        long curCalTime = cal.getTimeInMillis();
        boolean inOutage = false;
        Enumeration e = sched.enumerateTime();
        while (e.hasMoreElements() && !inOutage) {
            outCalBegin.setTimeInMillis(curCalTime);
            outCalEnd.setTimeInMillis(curCalTime);
            Time oTime = (Time)e.nextElement();
            String oTimeDay = oTime.getDay();
            String begins = oTime.getBegins();
            String ends = oTime.getEnds();
            if (oTimeDay != null) {
                Integer dayInMap = BasicScheduleUtils.getDayOfWeekIndex(oTimeDay);
                if (dayInMap != null) {
                    if (cal.get(7) == dayInMap.intValue()) {
                        inOutage = true;
                    }
                    outCalBegin.set(7, dayInMap);
                    outCalEnd.set(7, dayInMap);
                } else {
                    int intOTimeDay = Integer.valueOf(oTimeDay);
                    if (cal.get(5) == intOTimeDay) {
                        inOutage = true;
                    }
                    outCalBegin.set(5, intOTimeDay);
                    outCalEnd.set(5, intOTimeDay);
                }
            }
            if (oTimeDay != null && !inOutage) continue;
            BasicScheduleUtils.setOutCalTime(outCalBegin, begins);
            BasicScheduleUtils.setOutCalTime(outCalEnd, ends);
            LogUtils.debugf(BasicScheduleUtils.class, (String)"isTimeInOutage: checking begin/end time...\n current: %s\n begin: %s\n end: %s", (Object[])new Object[]{cal.getTime(), outCalBegin.getTime(), outCalEnd.getTime()});
            long outCalBeginTime = outCalBegin.getTimeInMillis() / 1000L * 1000L;
            long outCalEndTime = (outCalEnd.getTimeInMillis() / 1000L + 1L) * 1000L;
            if (curCalTime >= outCalBeginTime && curCalTime < outCalEndTime) {
                inOutage = true;
                continue;
            }
            inOutage = false;
        }
        return inOutage;
    }

    public static void setOutCalTime(Calendar outCal, String timeStr) {
        if (timeStr.length() == FORMAT1.length()) {
            SimpleDateFormat format = new SimpleDateFormat(FORMAT1);
            Date tempDate = null;
            try {
                tempDate = format.parse(timeStr);
            }
            catch (ParseException pE) {
                tempDate = null;
            }
            if (tempDate == null) {
                return;
            }
            GregorianCalendar tempCal = new GregorianCalendar();
            tempCal.setTime(tempDate);
            outCal.set(1, tempCal.get(1));
            outCal.set(2, tempCal.get(2));
            outCal.set(5, tempCal.get(5));
            outCal.set(11, tempCal.get(11));
            outCal.set(12, tempCal.get(12));
            outCal.set(13, tempCal.get(13));
            outCal.set(14, 0);
        } else if (timeStr.length() == FORMAT2.length()) {
            SimpleDateFormat format = new SimpleDateFormat(FORMAT2);
            Date tempDate = null;
            try {
                tempDate = format.parse(timeStr);
            }
            catch (ParseException pE) {
                tempDate = null;
            }
            if (tempDate == null) {
                return;
            }
            GregorianCalendar tempCal = new GregorianCalendar();
            tempCal.setTime(tempDate);
            outCal.set(11, tempCal.get(11));
            outCal.set(12, tempCal.get(12));
            outCal.set(13, tempCal.get(13));
            outCal.set(14, 0);
        }
    }

    public static Integer getDayOfWeekIndex(String dayName) {
        BasicScheduleUtils.createDayOfWeekMapping();
        return m_dayOfWeekMap.get(dayName);
    }

    public static Calendar getEndOfSchedule(BasicSchedule out) {
        long curCalTime = System.currentTimeMillis();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(curCalTime);
        boolean inOutage = false;
        Enumeration en = out.enumerateTime();
        while (en.hasMoreElements() && !inOutage) {
            GregorianCalendar outCalBegin = new GregorianCalendar();
            GregorianCalendar outCalEnd = new GregorianCalendar();
            Time oTime = (Time)en.nextElement();
            String oTimeDay = oTime.getDay();
            String begins = oTime.getBegins();
            String ends = oTime.getEnds();
            if (oTimeDay != null) {
                Integer dayInMap = BasicScheduleUtils.getDayOfWeekIndex(oTimeDay);
                if (dayInMap != null) {
                    if (cal.get(7) == dayInMap.intValue()) {
                        inOutage = true;
                    }
                    outCalBegin.set(7, dayInMap);
                    outCalEnd.set(7, dayInMap);
                } else {
                    int intOTimeDay = new Integer(oTimeDay);
                    if (cal.get(5) == intOTimeDay) {
                        inOutage = true;
                    }
                    outCalBegin.set(5, intOTimeDay);
                    outCalEnd.set(5, intOTimeDay);
                }
            }
            if (oTimeDay != null && !inOutage) continue;
            BasicScheduleUtils.setOutCalTime(outCalBegin, begins);
            BasicScheduleUtils.setOutCalTime(outCalEnd, ends);
            long outCalBeginTime = outCalBegin.getTime().getTime() / 1000L * 1000L;
            long outCalEndTime = (outCalEnd.getTime().getTime() / 1000L + 1L) * 1000L;
            if (curCalTime < outCalBeginTime || curCalTime >= outCalEndTime) continue;
            return outCalEnd;
        }
        return null;
    }

    private static void createDayOfWeekMapping() {
        if (m_dayOfWeekMap == null) {
            m_dayOfWeekMap = new HashMap<String, Integer>();
            m_dayOfWeekMap.put("sunday", 1);
            m_dayOfWeekMap.put("monday", 2);
            m_dayOfWeekMap.put("tuesday", 3);
            m_dayOfWeekMap.put("wednesday", 4);
            m_dayOfWeekMap.put("thursday", 5);
            m_dayOfWeekMap.put("friday", 6);
            m_dayOfWeekMap.put("saturday", 7);
        }
    }

    public static boolean isTimeInSchedule(Date time, BasicSchedule sched) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        return BasicScheduleUtils.isTimeInSchedule(cal, sched);
    }

    public static boolean isDaily(Time time) {
        return time.getDay() == null && !BasicScheduleUtils.isSpecific(time);
    }

    public static boolean isWeekly(Time time) {
        return time.getDay() != null && BasicScheduleUtils.getDayOfWeekIndex(time.getDay()) != null;
    }

    public static boolean isMonthly(Time time) {
        return time.getDay() != null && BasicScheduleUtils.getDayOfWeekIndex(time.getDay()) == null;
    }

    public static boolean isSpecific(Time time) {
        if (time.getDay() == null) {
            if (time.getBegins().matches("^\\d\\d\\d\\d-\\d\\d-\\d\\d .*$")) {
                return true;
            }
            if (time.getBegins().matches("^\\d\\d-...-\\d\\d\\d\\d .*$")) {
                return true;
            }
        }
        return false;
    }

    public static Date getSpecificTime(String specificString) {
        Calendar cal = Calendar.getInstance();
        BasicScheduleUtils.setOutCalTime(cal, specificString);
        return cal.getTime();
    }

    public static Date getMonthlyTime(Date referenceTime, String day, String timeString) {
        Calendar ref = Calendar.getInstance();
        ref.setTime(referenceTime);
        ref.set(5, Integer.parseInt(day));
        BasicScheduleUtils.setOutCalTime(ref, timeString);
        return ref.getTime();
    }

    public static Date getWeeklyTime(Date referenceTime, String day, String timeString) {
        Calendar ref = Calendar.getInstance();
        ref.setTime(referenceTime);
        ref.set(7, BasicScheduleUtils.getDayOfWeekIndex(day));
        BasicScheduleUtils.setOutCalTime(ref, timeString);
        return ref.getTime();
    }

    public static Date getDailyTime(Date referenceTime, String timeString) {
        Calendar ref = Calendar.getInstance();
        ref.setTime(referenceTime);
        BasicScheduleUtils.setOutCalTime(ref, timeString);
        return ref.getTime();
    }

    public static OwnedInterval getInterval(Date ref, Time time, Owner owner) {
        if (BasicScheduleUtils.isWeekly(time)) {
            return new OwnedInterval(owner, BasicScheduleUtils.getWeeklyTime(ref, time.getDay(), time.getBegins()), BasicScheduleUtils.getWeeklyTime(ref, time.getDay(), time.getEnds()));
        }
        if (BasicScheduleUtils.isMonthly(time)) {
            return new OwnedInterval(owner, BasicScheduleUtils.getMonthlyTime(ref, time.getDay(), time.getBegins()), BasicScheduleUtils.getMonthlyTime(ref, time.getDay(), time.getEnds()));
        }
        if (BasicScheduleUtils.isDaily(time)) {
            return new OwnedInterval(owner, BasicScheduleUtils.getDailyTime(ref, time.getBegins()), BasicScheduleUtils.getDailyTime(ref, time.getEnds()));
        }
        return new OwnedInterval(owner, BasicScheduleUtils.getSpecificTime(time.getBegins()), BasicScheduleUtils.getSpecificTime(time.getEnds()));
    }

    public static Date nextDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, 1);
        return cal.getTime();
    }

    public static Date nextWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(6, 7);
        return cal.getTime();
    }

    public static Date nextMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, 1);
        return cal.getTime();
    }

    public static OwnedIntervalSequence getIntervals(Date start, Date end, Time time, Owner owner) {
        OwnedIntervalSequence seq = new OwnedIntervalSequence();
        if (time.getBegins().equals(time.getEnds())) {
            return seq;
        }
        if (BasicScheduleUtils.isWeekly(time)) {
            Date done = BasicScheduleUtils.nextWeek(end);
            Date ref = start;
            while (done.after(ref)) {
                seq.addInterval(BasicScheduleUtils.getInterval(ref, time, owner));
                ref = BasicScheduleUtils.nextWeek(ref);
            }
        } else if (BasicScheduleUtils.isMonthly(time)) {
            Date done = BasicScheduleUtils.nextMonth(end);
            Date ref = start;
            while (done.after(ref)) {
                seq.addInterval(BasicScheduleUtils.getInterval(ref, time, owner));
                ref = BasicScheduleUtils.nextMonth(ref);
            }
        } else if (BasicScheduleUtils.isDaily(time)) {
            Date done = BasicScheduleUtils.nextDay(end);
            Date ref = start;
            while (done.after(ref)) {
                seq.addInterval(BasicScheduleUtils.getInterval(ref, time, owner));
                ref = BasicScheduleUtils.nextDay(ref);
            }
        } else {
            seq.addInterval(BasicScheduleUtils.getInterval(start, time, owner));
        }
        seq.bound(start, end);
        return seq;
    }

    public static OwnedIntervalSequence getIntervals(TimeInterval interval, Time time, Owner owner) {
        return BasicScheduleUtils.getIntervals(interval.getStart(), interval.getEnd(), time, owner);
    }

    public static OwnedIntervalSequence getIntervalsCovering(Date start, Date end, BasicSchedule sched, Owner owner) {
        OwnedIntervalSequence seq = new OwnedIntervalSequence();
        for (int i = 0; i < sched.getTimeCount(); ++i) {
            Time time = sched.getTime(i);
            Owner thisOwner = owner.addTimeIndex(i);
            seq.addAll(BasicScheduleUtils.getIntervals(start, end, time, thisOwner));
        }
        return seq;
    }

    public static OwnedIntervalSequence getIntervalsCovering(TimeInterval interval, BasicSchedule sched, Owner owner) {
        return BasicScheduleUtils.getIntervalsCovering(interval.getStart(), interval.getEnd(), sched, owner);
    }

    static {
        FORMAT1 = "dd-MMM-yyyy HH:mm:ss";
        FORMAT2 = "HH:mm:ss";
    }
}

