/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.IPLike;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.PeerFactory;
import org.opennms.netmgt.config.ami.AmiConfig;
import org.opennms.netmgt.config.ami.Definition;
import org.opennms.netmgt.config.common.Range;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.protocols.ami.AmiAgentConfig;
import org.opennms.protocols.ip.IPv4Address;

public class AmiPeerFactory
extends PeerFactory {
    private static AmiPeerFactory m_singleton = null;
    private static AmiConfig m_config;
    private static boolean m_loaded;

    private AmiPeerFactory(String configFile) throws IOException, MarshalException, ValidationException {
        FileInputStream cfgIn = new FileInputStream(configFile);
        m_config = (AmiConfig)CastorUtils.unmarshal(AmiConfig.class, (InputStream)cfgIn);
        ((InputStream)cfgIn).close();
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.AMI_CONFIG_FILE_NAME);
        AmiPeerFactory.log().debug("init: config file path: " + cfgFile.getPath());
        m_singleton = new AmiPeerFactory(cfgFile.getPath());
        m_loaded = true;
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(AmiPeerFactory.class);
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        AmiPeerFactory.init();
    }

    public static synchronized void saveCurrent() throws Exception {
        AmiPeerFactory.optimize();
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)m_config, (Writer)stringWriter);
        if (stringWriter.toString() != null) {
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.AMI_CONFIG_FILE_NAME)), "UTF-8");
            fileWriter.write(stringWriter.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        AmiPeerFactory.reload();
    }

    private static void optimize() throws UnknownHostException {
        ThreadCategory log = AmiPeerFactory.log();
        Iterator definitionsIterator = m_config.getDefinitionCollection().iterator();
        while (definitionsIterator.hasNext()) {
            Definition definition = (Definition)definitionsIterator.next();
            if (definition.getSpecificCount() != 0 || definition.getRangeCount() != 0) continue;
            if (log.isDebugEnabled()) {
                log.debug("optimize: Removing empty definition element");
            }
            definitionsIterator.remove();
        }
        for (Definition definition : m_config.getDefinitionCollection()) {
            Iterator rangesIterator = definition.getRangeCollection().iterator();
            while (rangesIterator.hasNext()) {
                Range range = (Range)rangesIterator.next();
                if (!range.getBegin().equals(range.getEnd())) continue;
                definition.addSpecific(range.getBegin());
                rangesIterator.remove();
            }
        }
        for (Definition definition : m_config.getDefinitionCollection()) {
            int specificInt;
            TreeMap<Integer, String> specificsMap = new TreeMap<Integer, String>();
            for (String specific : definition.getSpecificCollection()) {
                specificsMap.put(new Integer(new IPv4Address(specific).getAddress()), specific.trim());
            }
            TreeMap<Integer, Range> rangesMap = new TreeMap<Integer, Range>();
            for (Range range : definition.getRangeCollection()) {
                rangesMap.put(new IPv4Address(range.getBegin()).getAddress(), range);
            }
            Integer priorSpecific = null;
            Range addedRange = null;
            for (Integer specific : specificsMap.keySet()) {
                int priorSpecificInt;
                if (priorSpecific == null) {
                    priorSpecific = specific;
                    continue;
                }
                specificInt = specific;
                if (specificInt == (priorSpecificInt = priorSpecific.intValue()) + 1) {
                    if (addedRange == null) {
                        addedRange = new Range();
                        addedRange.setBegin(IPv4Address.addressToString((int)priorSpecificInt));
                        rangesMap.put(priorSpecific, addedRange);
                        specificsMap.remove(priorSpecific);
                    }
                    addedRange.setEnd(IPv4Address.addressToString((int)specificInt));
                    specificsMap.remove(specific);
                } else {
                    addedRange = null;
                }
                priorSpecific = specific;
            }
            block7: for (Integer specific : new ArrayList(specificsMap.keySet())) {
                specificInt = specific;
                for (Integer begin : new ArrayList(rangesMap.keySet())) {
                    Range range;
                    int endInt;
                    int beginInt = begin;
                    if (specificInt < beginInt - 1 || specificInt > (endInt = new IPv4Address((range = (Range)rangesMap.get(begin)).getEnd()).getAddress()) + 1) continue;
                    if (specificInt >= beginInt && specificInt <= endInt) {
                        specificsMap.remove(specific);
                        continue block7;
                    }
                    if (specificInt == beginInt - 1) {
                        rangesMap.remove(begin);
                        rangesMap.put(specific, range);
                        range.setBegin(IPv4Address.addressToString((int)specificInt));
                        specificsMap.remove(specific);
                        continue block7;
                    }
                    if (specificInt != endInt + 1) continue;
                    range.setEnd(IPv4Address.addressToString((int)specificInt));
                    specificsMap.remove(specific);
                    continue block7;
                }
            }
            Range priorRange = null;
            int priorBegin = 0;
            int priorEnd = 0;
            Iterator rangesIterator = rangesMap.keySet().iterator();
            while (rangesIterator.hasNext()) {
                Integer rangeKey = (Integer)rangesIterator.next();
                Range range = (Range)rangesMap.get(rangeKey);
                int begin = rangeKey;
                int end = new IPv4Address(range.getEnd()).getAddress();
                if (priorRange != null && begin - priorEnd <= 1) {
                    priorRange.setBegin(IPv4Address.addressToString((int)Math.min(priorBegin, begin)));
                    priorRange.setEnd(IPv4Address.addressToString((int)Math.max(priorEnd, end)));
                    rangesIterator.remove();
                    continue;
                }
                priorRange = range;
                priorBegin = begin;
                priorEnd = end;
            }
            definition.setSpecific(specificsMap.values().toArray(new String[0]));
            definition.setRange(rangesMap.values().toArray(new Range[0]));
        }
    }

    public static synchronized AmiPeerFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The AmiPeerFactory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(AmiPeerFactory singleton) {
        m_singleton = singleton;
        m_loaded = true;
    }

    public void define(InetAddress ip, String username, String password) throws UnknownHostException {
        ThreadCategory log = AmiPeerFactory.log();
        int address = new IPv4Address(ip).getAddress();
        ArrayList<Definition> definitions = new ArrayList<Definition>(m_config.getDefinitionCollection());
        Definition definition = null;
        for (Definition currentDefinition : definitions) {
            if ((currentDefinition.getPassword() == null || !currentDefinition.getPassword().equals(password)) && (currentDefinition.getPassword() != null || m_config.getPassword() == null || !m_config.getPassword().equals(password))) continue;
            if (log.isDebugEnabled()) {
                log.debug("define: Found existing definition with password " + password);
            }
            definition = currentDefinition;
            break;
        }
        if (definition == null) {
            if (log.isDebugEnabled()) {
                log.debug("define: Creating new definition");
            }
            definition = new Definition();
            definition.setPassword(password);
            definition.setUsername(username);
            definitions.add(definition);
        }
        definition.addSpecific(ip.getHostAddress());
        for (Definition currentDefinition : definitions) {
            if (currentDefinition == definition) continue;
            while (currentDefinition.removeSpecific(ip.getHostAddress())) {
                if (!log.isDebugEnabled()) continue;
                log.debug("define: Removed an existing specific element with IP " + ip);
            }
            ArrayList<Range> ranges = new ArrayList<Range>(currentDefinition.getRangeCollection());
            Range[] rangesArray = currentDefinition.getRange();
            for (int rangesArrayIndex = 0; rangesArrayIndex < rangesArray.length; ++rangesArrayIndex) {
                Range range = rangesArray[rangesArrayIndex];
                int begin = new IPv4Address(range.getBegin()).getAddress();
                int end = new IPv4Address(range.getEnd()).getAddress();
                if (address < begin || address > end) continue;
                if (log.isDebugEnabled()) {
                    log.debug(String.format("define: Splitting range element with begin %s and end %s", range.getBegin(), range.getEnd()));
                }
                if (begin == end) {
                    ranges.remove(range);
                    continue;
                }
                if (address == begin) {
                    range.setBegin(IPv4Address.addressToString((int)(address + 1)));
                    continue;
                }
                if (address == end) {
                    range.setEnd(IPv4Address.addressToString((int)(address - 1)));
                    continue;
                }
                Range head = new Range();
                head.setBegin(range.getBegin());
                head.setEnd(IPv4Address.addressToString((int)(address - 1)));
                Range tail = new Range();
                tail.setBegin(IPv4Address.addressToString((int)(address + 1)));
                tail.setEnd(range.getEnd());
                ranges.remove(range);
                ranges.add(head);
                ranges.add(tail);
            }
            currentDefinition.setRange(ranges.toArray(new Range[0]));
        }
        m_config.setDefinition(definitions.toArray(new Definition[0]));
    }

    public synchronized AmiAgentConfig getAgentConfig(InetAddress agentInetAddress) {
        Definition def;
        if (m_config == null) {
            return new AmiAgentConfig(agentInetAddress);
        }
        AmiAgentConfig agentConfig = new AmiAgentConfig(agentInetAddress);
        this.setAmiAgentConfig(agentConfig, new Definition());
        Enumeration edef = m_config.enumerateDefinition();
        block4: while (edef.hasMoreElements()) {
            def = (Definition)edef.nextElement();
            for (String saddr : def.getSpecificCollection()) {
                saddr = saddr.trim();
                try {
                    InetAddress addr = InetAddress.getByName(saddr);
                    if (!addr.equals(agentConfig.getAddress())) continue;
                    this.setAmiAgentConfig(agentConfig, def);
                    break block4;
                }
                catch (UnknownHostException e) {
                    AmiPeerFactory.log().warn(String.format("AmiPeerFactory: could not convert host %s to InetAddress", saddr), (Throwable)e);
                }
            }
            long lhost = InetAddressUtils.toIpAddrLong((InetAddress)agentConfig.getAddress());
            for (Range rng : def.getRangeCollection()) {
                try {
                    InetAddress begin = InetAddress.getByName(rng.getBegin());
                    InetAddress end = InetAddress.getByName(rng.getEnd());
                    long start = InetAddressUtils.toIpAddrLong((InetAddress)begin);
                    long stop = InetAddressUtils.toIpAddrLong((InetAddress)end);
                    if (start > lhost || lhost > stop) continue;
                    this.setAmiAgentConfig(agentConfig, def);
                    break block4;
                }
                catch (UnknownHostException e) {
                    AmiPeerFactory.log().warn(String.format("AmiPeerFactory: could not convert host(s) %s - %s to InetAddress", rng.getBegin(), rng.getEnd()), (Throwable)e);
                }
            }
            for (String ipMatch : def.getIpMatchCollection()) {
                if (!IPLike.matches((String)agentInetAddress.getHostAddress(), (String)ipMatch)) continue;
                this.setAmiAgentConfig(agentConfig, def);
                break block4;
            }
        }
        if (agentConfig == null) {
            def = new Definition();
            this.setAmiAgentConfig(agentConfig, def);
        }
        return agentConfig;
    }

    private void setAmiAgentConfig(AmiAgentConfig agentConfig, Definition def) {
        this.setCommonAttributes(agentConfig, def);
        agentConfig.setPassword(this.determinePassword(def));
    }

    private void setCommonAttributes(AmiAgentConfig agentConfig, Definition def) {
        agentConfig.setRetries(this.determineRetries(def));
        agentConfig.setTimeout((int)this.determineTimeout(def));
        agentConfig.setUsername(this.determineUsername(def));
        agentConfig.setPassword(this.determinePassword(def));
    }

    private String determineUsername(Definition def) {
        return def.getPassword() == null ? (m_config.getUsername() == null ? "opennms" : m_config.getUsername()) : def.getUsername();
    }

    private String determinePassword(Definition def) {
        return def.getPassword() == null ? (m_config.getPassword() == null ? "" : m_config.getPassword()) : def.getPassword();
    }

    private long determineTimeout(Definition def) {
        long timeout = 3000L;
        return def.getTimeout() == 0 ? (m_config.getTimeout() == 0 ? timeout : (long)m_config.getTimeout()) : (long)def.getTimeout();
    }

    private int determineRetries(Definition def) {
        int retries = 1;
        return def.getRetry() == 0 ? (m_config.getRetry() == 0 ? retries : m_config.getRetry()) : def.getRetry();
    }

    public static AmiConfig getAmiConfig() {
        return m_config;
    }

    public static synchronized void setAmiConfig(AmiConfig m_config) {
        AmiPeerFactory.m_config = m_config;
    }

    static {
        m_loaded = false;
    }
}

