/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import jcifs.netbios.NbtAddress;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SmbPlugin
extends AbstractPlugin {
    private static final String PROTOCOL_NAME = "SMB";

    private boolean isSmb(InetAddress host) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        boolean isAServer = false;
        try {
            log.debug("host.getHostAddress(): " + host.getHostAddress());
            NbtAddress nbtAddr = NbtAddress.getByName((String)host.getHostAddress());
            log.debug("nbtAddr.getHostNamer(): " + nbtAddr.getHostName());
            if (nbtAddr.getHostName().equals(host.getHostAddress())) {
                if (log.isDebugEnabled()) {
                    log.debug("SmbPlugin: failed to retrieve SMB name for " + host.getHostAddress());
                }
            } else {
                isAServer = true;
            }
        }
        catch (UnknownHostException e) {
            if (log.isDebugEnabled()) {
                log.debug("SmbPlugin: UnknownHostException: " + e.getMessage());
            }
        }
        catch (Throwable t) {
            log.error("SmbPlugin: An undeclared throwable exception was caught checking host " + host.getHostAddress(), t);
        }
        return isAServer;
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        return this.isSmb(address);
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        return this.isSmb(address);
    }
}

