/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPSocketFactory;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LdapPlugin
extends AbstractPlugin {
    private static final String PROTOCOL_NAME = "LDAP";
    private static final int[] DEFAULT_PORTS = new int[]{389};
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServer(InetAddress host, int port, int retries, int timeout) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        boolean isAServer = false;
        Socket socket = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress(host, port), timeout);
            socket.setSoTimeout(timeout);
            log.debug("LDAPPlugin.isServer: connect successful");
            for (int attempts = 0; attempts <= retries && !isAServer; ++attempts) {
                log.debug("LDAPPlugin.isServer: attempt " + attempts + " to connect host " + host.getHostAddress());
                LDAPConnection lc = null;
                try {
                    lc = new LDAPConnection((LDAPSocketFactory)new TimeoutLDAPSocket(timeout));
                    lc.connect(host.getHostAddress(), port);
                    isAServer = true;
                    continue;
                }
                catch (LDAPException e) {
                    isAServer = false;
                    continue;
                }
                finally {
                    try {
                        if (lc != null) {
                            lc.disconnect();
                        }
                    }
                    catch (LDAPException e) {}
                }
            }
        }
        catch (ConnectException e) {
            log.debug(this.getClass().getName() + ": connection refused to " + host.getHostAddress() + ":" + port);
        }
        catch (NoRouteToHostException e) {
            e.fillInStackTrace();
            log.info(this.getClass().getName() + ": No route to host " + host.getHostAddress(), (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (InterruptedIOException e) {
            log.debug("LDAPPlugin: failed to connect within specified timeout");
        }
        catch (Throwable t) {
            log.warn(this.getClass().getName() + ": An undeclared throwable exception caught contacting host " + host.getHostAddress(), t);
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException e) {}
        }
        return isAServer;
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        for (int i = 0; i < DEFAULT_PORTS.length; ++i) {
            if (!this.isServer(address, DEFAULT_PORTS[i], 0, 5000)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        int retries = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)0);
        int timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)5000);
        int[] ports = ParameterMap.getKeyedIntegerArray(qualifiers, (String)"port", (int[])DEFAULT_PORTS);
        for (int i = 0; i < ports.length; ++i) {
            if (!this.isServer(address, ports[i], retries, timeout)) continue;
            qualifiers.put("port", ports[i]);
            return true;
        }
        return false;
    }

    private class TimeoutLDAPSocket
    implements LDAPSocketFactory {
        private int m_timeout;

        public TimeoutLDAPSocket(int timeout) {
            this.m_timeout = timeout;
        }

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            Socket socket = new Socket(host, port);
            socket.setSoTimeout(this.m_timeout);
            return socket;
        }
    }
}

