/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.netmgt.ping.Pinger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IcmpPlugin
extends AbstractPlugin {
    private static final String PROTOCOL_NAME = "ICMP";

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        try {
            Long retval = Pinger.ping((InetAddress)address);
            if (retval != null) {
                return true;
            }
        }
        catch (Exception e) {
            ThreadCategory log = ThreadCategory.getInstance(this.getClass());
            log.warn("Pinger failed to ping " + address, (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        try {
            long timeout;
            int retries;
            if (qualifiers != null) {
                retries = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)2);
                timeout = ParameterMap.getKeyedLong(qualifiers, (String)"timeout", (long)800L);
            } else {
                retries = 2;
                timeout = 800L;
            }
            Long retval = Pinger.ping((InetAddress)address, (long)timeout, (int)retries);
            if (retval != null) {
                return true;
            }
        }
        catch (Exception e) {
            ThreadCategory log = ThreadCategory.getInstance(this.getClass());
            log.warn("Pinger failed to ping " + address, (Throwable)e);
        }
        return false;
    }
}

