/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.DbIfServiceEntry;
import org.opennms.netmgt.capsd.DbIpInterfaceEntry;
import org.opennms.netmgt.capsd.DbNodeEntry;
import org.opennms.netmgt.capsd.EventUtils;
import org.opennms.netmgt.capsd.FailedOperationException;
import org.opennms.netmgt.capsd.InsufficientInformationException;
import org.opennms.netmgt.capsd.RescanProcessor;
import org.opennms.netmgt.capsd.Scheduler;
import org.opennms.netmgt.capsd.SuspectEventProcessor;
import org.opennms.netmgt.capsd.SuspectEventProcessorFactory;
import org.opennms.netmgt.config.CapsdConfigFactory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.model.events.annotations.EventHandler;
import org.opennms.netmgt.model.events.annotations.EventListener;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EventListener(name="Capsd:BroadcastEventProcessor")
public class BroadcastEventProcessor
implements InitializingBean {
    private static String SQL_ADD_INTERFACE_TO_SERVER = "INSERT INTO serverMap VALUES (?, ?)";
    private static String SQL_ADD_SERVICE_TO_MAPPING = "INSERT INTO serviceMap VALUES (?, ?)";
    private static String SQL_DELETE_ALL_SERVICES_INTERFACE_MAPPING = "DELETE FROM serviceMap WHERE ipaddr = ?";
    private static String SQL_DELETE_INTERFACE_ON_SERVER = "DELETE FROM serverMap WHERE ipaddr = ? AND servername = ?";
    private static String SQL_DELETE_SERVICE_INTERFACE_MAPPING = "DELETE FROM serviceMap WHERE ipaddr = ? AND servicemapname = ?";
    private static String SQL_QUERY_IPADDRESS_EXIST = "SELECT nodeid FROM ipinterface WHERE ipaddr = ? AND isManaged !='D'";
    private static String SQL_QUERY_IPINTERFACE_EXIST = "SELECT nodelabel, ipaddr FROM node, ipinterface WHERE node.nodeid = ipinterface.nodeid AND node.nodelabel = ? AND ipinterface.ipaddr = ? AND isManaged !='D' AND nodeType !='D'";
    private static String SQL_QUERY_NODE_EXIST = "SELECT nodeid, dpname FROM node WHERE nodelabel = ? AND nodeType !='D'";
    private static String SQL_QUERY_SERVICE_EXIST = "SELECT nodeid FROM ifservices, service WHERE ifservices.serviceid = service.serviceid AND ipaddr = ? AND servicename = ? AND status !='D'";
    private static String SQL_QUERY_SERVICE_MAPPING_EXIST = "SELECT * FROM serviceMap WHERE ipaddr = ? AND servicemapname = ?";
    private static String SQL_RETRIEVE_NODEID = "select nodeid from ipinterface where ipaddr=? and isManaged!='D'";
    private static String SQL_RETRIEVE_SERVICE_ID = "SELECT serviceid FROM service WHERE servicename = ?";
    private String m_localServer = null;
    private Scheduler m_scheduler;
    private FifoQueue<Runnable> m_suspectQ;
    private SuspectEventProcessorFactory m_suspectEventProcessorFactory;

    public static boolean isPropagationEnabled() {
        return CapsdConfigFactory.getInstance().getDeletePropagationEnabled();
    }

    public static boolean isXmlRpcEnabled() {
        return CapsdConfigFactory.getInstance().getXmlrpc().equals("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countOtherInterfacesOnNode(Connection dbConn, long nodeId, String ipAddr) throws SQLException {
        String DB_COUNT_OTHER_INTERFACES_ON_NODE = "SELECT count(*) FROM ipinterface WHERE nodeID=? and ipAddr != ? and isManaged != 'D'";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement("SELECT count(*) FROM ipinterface WHERE nodeID=? and ipAddr != ? and isManaged != 'D'");
            d.watch((Object)stmt);
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            int count = 0;
            while (rs.next()) {
                count = rs.getInt(1);
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("countServicesForInterface: count services for interface " + nodeId + "/" + ipAddr + ": found " + count);
            }
            int n = count;
            return n;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countOtherServicesOnInterface(Connection dbConn, long nodeId, String ipAddr, String service) throws SQLException {
        String DB_COUNT_OTHER_SERVICES_ON_IFACE = "SELECT count(*) FROM ifservices, service WHERE ifservices.serviceId = service.serviceId AND ifservices.status != 'D' AND ifservices.nodeID=? AND ifservices.ipAddr=? AND service.servicename != ?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement("SELECT count(*) FROM ifservices, service WHERE ifservices.serviceId = service.serviceId AND ifservices.status != 'D' AND ifservices.nodeID=? AND ifservices.ipAddr=? AND service.servicename != ?");
            d.watch((Object)stmt);
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            stmt.setString(3, service);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            int count = 0;
            while (rs.next()) {
                count = rs.getInt(1);
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("countServicesForInterface: count services for interface " + nodeId + "/" + ipAddr + ": found " + count);
            }
            int n = count;
            return n;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countServicesOnOtherInterfaces(Connection dbConn, long nodeId, String ipAddr) throws SQLException {
        String DB_COUNT_SERVICES_ON_OTHER_INTERFACES = "SELECT count(*) FROM ifservices WHERE nodeID=? and ipAddr != ? and status != 'D'";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement("SELECT count(*) FROM ifservices WHERE nodeID=? and ipAddr != ? and status != 'D'");
            d.watch((Object)stmt);
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            int count = 0;
            while (rs.next()) {
                count = rs.getInt(1);
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("countServicesOnOtherInterfaces: count services for node " + nodeId + ": found " + count);
            }
            int n = count;
            return n;
        }
        finally {
            d.cleanUp();
        }
    }

    private List<Event> createInterfaceOnNode(Connection dbConn, String nodeLabel, String ipaddr) throws SQLException, FailedOperationException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement(SQL_QUERY_NODE_EXIST);
            d.watch((Object)stmt);
            stmt.setString(1, nodeLabel);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            LinkedList<Event> eventsToSend = new LinkedList<Event>();
            while (rs.next()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("addInterfaceHandler:  add interface: " + ipaddr + " to the database.");
                }
                InetAddress ifaddr = InetAddress.getByName(ipaddr);
                int nodeId = rs.getInt(1);
                String dpName = rs.getString(2);
                DbIpInterfaceEntry ipInterface = DbIpInterfaceEntry.create(nodeId, ifaddr);
                ipInterface.setHostname(ifaddr.getHostName());
                ipInterface.setManagedState('M');
                ipInterface.setPrimaryState('N');
                ipInterface.store(dbConn);
                DbNodeEntry nodeEntry = DbNodeEntry.get(nodeId, dpName);
                Event newEvent = EventUtils.createNodeGainedInterfaceEvent(nodeEntry, ifaddr);
                eventsToSend.add(newEvent);
            }
            LinkedList<Event> linkedList = eventsToSend;
            return linkedList;
        }
        catch (UnknownHostException e) {
            throw new FailedOperationException("unable to resolve host " + ipaddr + ": " + e.getMessage(), e);
        }
        finally {
            d.cleanUp();
        }
    }

    private List<Event> createNodeWithInterface(Connection conn, String nodeLabel, String ipaddr) throws SQLException, FailedOperationException {
        if (nodeLabel == null) {
            return Collections.emptyList();
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug("addNode:  Add a node " + nodeLabel + " to the database");
        }
        LinkedList<Event> eventsToSend = new LinkedList<Event>();
        DbNodeEntry node = DbNodeEntry.create();
        Date now = new Date();
        node.setCreationTime(now);
        node.setNodeType('A');
        node.setLabel(nodeLabel);
        node.setLabelSource('U');
        node.store(conn);
        Event newEvent = EventUtils.createNodeAddedEvent(node);
        eventsToSend.add(newEvent);
        if (ipaddr != null) {
            try {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("addNode:  Add an IP Address " + ipaddr + " to the database");
                }
                InetAddress ifaddress = InetAddress.getByName(ipaddr);
                DbIpInterfaceEntry ipInterface = DbIpInterfaceEntry.create(node.getNodeId(), ifaddress);
                ipInterface.setHostname(ifaddress.getHostName());
                ipInterface.setManagedState('M');
                ipInterface.setPrimaryState('N');
                ipInterface.store(conn);
                Event gainIfEvent = EventUtils.createNodeGainedInterfaceEvent(node, ifaddress);
                eventsToSend.add(gainIfEvent);
            }
            catch (UnknownHostException e) {
                throw new FailedOperationException("unable to resolve host " + ipaddr + ": " + e.getMessage(), e);
            }
        }
        return eventsToSend;
    }

    private List<Event> doAddInterface(Connection dbConn, String nodeLabel, String ipaddr) throws SQLException, FailedOperationException {
        List<Event> eventsToSend;
        if (this.interfaceExists(dbConn, nodeLabel, ipaddr)) {
            if (this.log().isDebugEnabled()) {
                this.log().debug("addInterfaceHandler: node " + nodeLabel + " with IPAddress " + ipaddr + " already exist in the database.");
            }
            eventsToSend = Collections.emptyList();
        } else {
            eventsToSend = this.nodeExists(dbConn, nodeLabel) ? this.createInterfaceOnNode(dbConn, nodeLabel, ipaddr) : this.createNodeWithInterface(dbConn, nodeLabel, ipaddr);
        }
        return eventsToSend;
    }

    private List<Event> doAddNode(Connection dbConn, String nodeLabel, String ipaddr) throws SQLException, FailedOperationException {
        List<Event> eventsToSend;
        if (!this.nodeExists(dbConn, nodeLabel)) {
            eventsToSend = this.createNodeWithInterface(dbConn, nodeLabel, ipaddr);
        } else {
            eventsToSend = Collections.emptyList();
            if (this.log().isDebugEnabled()) {
                this.log().debug("doAddNode: node " + nodeLabel + " with IPAddress " + ipaddr + " already exist in the database.");
            }
        }
        return eventsToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> doAddServiceMapping(Connection dbConn, String ipaddr, String serviceName, long txNo) throws SQLException, FailedOperationException {
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement(SQL_ADD_SERVICE_TO_MAPPING);
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr);
            stmt.setString(2, serviceName);
            stmt.executeUpdate();
            if (this.log().isDebugEnabled()) {
                this.log().debug("updateServiceHandler: add service " + serviceName + " to interface: " + ipaddr);
            }
            List<Event> list = this.doChangeService(dbConn, ipaddr, serviceName, "ADD", txNo);
            return list;
        }
        finally {
            d.cleanUp();
        }
    }

    private List<Event> doAddServiceToInterface(Connection dbConn, String ipaddr, String serviceName, int serviceId, long txNo) throws SQLException, FailedOperationException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement(SQL_QUERY_IPADDRESS_EXIST);
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            LinkedList<Event> eventsToSend = new LinkedList<Event>();
            while (rs.next()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("changeServiceHandler: add service " + serviceName + " to interface: " + ipaddr);
                }
                int nodeId = rs.getInt(1);
                DbIfServiceEntry service = DbIfServiceEntry.create(nodeId, InetAddress.getByName(ipaddr), serviceId);
                service.setSource('P');
                service.setStatus('A');
                service.setNotify('Y');
                service.store(dbConn);
                DbNodeEntry nodeEntry = DbNodeEntry.get(nodeId);
                Event newEvent = EventUtils.createNodeGainedServiceEvent(nodeEntry, InetAddress.getByName(ipaddr), serviceName, txNo);
                eventsToSend.add(newEvent);
            }
            LinkedList<Event> linkedList = eventsToSend;
            return linkedList;
        }
        catch (UnknownHostException e) {
            throw new FailedOperationException("Unable to resolve host: " + e.getMessage(), e);
        }
        finally {
            d.cleanUp();
        }
    }

    private List<Event> doChangeService(Connection dbConn, String ipaddr, String serviceName, String action, long txNo) throws SQLException, FailedOperationException {
        List<Object> eventsToSend = null;
        int serviceId = this.verifyServiceExists(dbConn, serviceName);
        if (action.equalsIgnoreCase("DELETE")) {
            eventsToSend = new LinkedList();
            int[] nodeIds = this.findNodeIdForServiceAndInterface(dbConn, ipaddr, serviceName);
            for (int i = 0; i < nodeIds.length; ++i) {
                int nodeId = nodeIds[i];
                eventsToSend.addAll(this.doDeleteService(dbConn, "OpenNMS.Capsd", nodeId, ipaddr, serviceName, txNo));
            }
        } else {
            eventsToSend = action.equalsIgnoreCase("ADD") ? this.doAddServiceToInterface(dbConn, ipaddr, serviceName, serviceId, txNo) : Collections.emptyList();
        }
        return eventsToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> doCreateInterfaceMappings(Connection dbConn, String nodeLabel, String ipaddr, String hostName, long txNo) throws SQLException {
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement(SQL_ADD_INTERFACE_TO_SERVER);
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr);
            stmt.setString(2, hostName);
            stmt.executeUpdate();
            if (this.log().isDebugEnabled()) {
                this.log().debug("updateServerHandler: added interface " + ipaddr + " into NMS server: " + hostName);
            }
            Event newEvent = EventUtils.createAddInterfaceEvent("OpenNMS.Capsd", nodeLabel, ipaddr, hostName, txNo);
            List<Event> list = Collections.singletonList(newEvent);
            return list;
        }
        finally {
            d.cleanUp();
        }
    }

    private List<Event> doDeleteInterface(Connection dbConn, String source, long nodeid, String ipAddr, long txNo) throws SQLException {
        return this.doDeleteInterface(dbConn, source, nodeid, ipAddr, -1, txNo);
    }

    private List<Event> doDeleteInterface(Connection dbConn, String source, long nodeid, String ipAddr, int ifIndex, long txNo) throws SQLException {
        LinkedList<Event> eventsToSend = new LinkedList<Event>();
        if (!EventUtils.isNonIpInterface(ipAddr) && BroadcastEventProcessor.isPropagationEnabled() && this.countOtherInterfacesOnNode(dbConn, nodeid, ipAddr) == 0) {
            eventsToSend = this.doDeleteNode(dbConn, source, nodeid, txNo);
        } else {
            if (!EventUtils.isNonIpInterface(ipAddr)) {
                eventsToSend.addAll(this.markAllServicesForInterfaceDeleted(dbConn, source, nodeid, ipAddr, txNo));
            }
            eventsToSend.addAll(this.markInterfaceDeleted(dbConn, source, nodeid, ipAddr, ifIndex, txNo));
        }
        this.deleteAlarmsForInterface(dbConn, nodeid, ipAddr);
        if (ifIndex > -1) {
            this.deleteAlarmsForSnmpInterface(dbConn, nodeid, ifIndex);
        }
        return eventsToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> doDeleteInterfaceMappings(Connection dbConn, String nodeLabel, String ipaddr, String hostName, long txNo) throws SQLException {
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            LinkedList<Event> eventsToSend = new LinkedList<Event>();
            if (this.log().isDebugEnabled()) {
                this.log().debug("updateServer: delete all services on the interface: " + ipaddr + " in the interface/service mapping.");
            }
            stmt = dbConn.prepareStatement(SQL_DELETE_ALL_SERVICES_INTERFACE_MAPPING);
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr);
            stmt.executeUpdate();
            if (this.log().isDebugEnabled()) {
                this.log().debug("updateServer: delete interface: " + ipaddr + " on NMS server: " + hostName);
            }
            stmt = dbConn.prepareStatement(SQL_DELETE_INTERFACE_ON_SERVER);
            stmt.setString(1, ipaddr);
            stmt.setString(2, hostName);
            stmt.executeUpdate();
            long[] nodeIds = this.findNodeIdsForInterfaceAndLabel(dbConn, nodeLabel, ipaddr);
            for (int i = 0; i < nodeIds.length; ++i) {
                long nodeId = nodeIds[i];
                eventsToSend.addAll(this.doDeleteInterface(dbConn, "OpenNMS.Capsd", nodeId, ipaddr, txNo));
            }
            LinkedList<Event> linkedList = eventsToSend;
            return linkedList;
        }
        finally {
            d.cleanUp();
        }
    }

    private List<Event> doDeleteNode(Connection dbConn, String source, long nodeid, long txNo) throws SQLException {
        LinkedList<Event> eventsToSend = new LinkedList<Event>();
        eventsToSend.addAll(this.markInterfacesAndServicesDeleted(dbConn, source, nodeid, txNo));
        eventsToSend.addAll(this.markNodeDeleted(dbConn, source, nodeid, txNo));
        this.deleteAlarmsForNode(dbConn, nodeid);
        return eventsToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAlarmsForNode(Connection dbConn, long nodeId) throws SQLException {
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement("DELETE FROM alarms WHERE nodeid = ?");
            d.watch((Object)stmt);
            stmt.setLong(1, nodeId);
            int count = stmt.executeUpdate();
            this.log().debug("deleteAlarmsForNode: deleted: " + count + " alarms for node: " + nodeId);
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAlarmsForInterface(Connection dbConn, long nodeId, String ipAddr) throws SQLException {
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement("DELETE FROM alarms WHERE nodeid = ? AND ipaddr = ?");
            d.watch((Object)stmt);
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            int count = stmt.executeUpdate();
            this.log().debug("deleteAlarmsForInterace: deleted: " + count + " alarms for interface: " + ipAddr);
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAlarmsForSnmpInterface(Connection dbConn, long nodeId, int ifIndex) throws SQLException {
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement("DELETE FROM alarms WHERE nodeid = ? AND ifindex = ?");
            d.watch((Object)stmt);
            stmt.setLong(1, nodeId);
            stmt.setInt(2, ifIndex);
            int count = stmt.executeUpdate();
            if (this.log().isDebugEnabled()) {
                this.log().debug("deleteAlarmsForSnmpInterace: deleted: " + count + " alarms for node " + nodeId + "ifIndex: " + ifIndex);
            }
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAlarmsForService(Connection dbConn, long nodeId, String ipAddr, String service) throws SQLException {
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement("DELETE FROM alarms WHERE nodeid = ?  AND ipaddr = ?  AND serviceid   IN (SELECT serviceid FROM service WHERE servicename = ?)");
            d.watch((Object)stmt);
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            stmt.setString(3, service);
            int count = stmt.executeUpdate();
            this.log().debug("deleteAlarmsForService: deleted: " + count + " alarms for service: " + service);
        }
        finally {
            d.cleanUp();
        }
    }

    private List<Event> doDeleteService(Connection dbConn, String source, long nodeid, String ipAddr, String service, long txNo) throws SQLException {
        LinkedList<Event> eventsToSend = new LinkedList<Event>();
        if (BroadcastEventProcessor.isPropagationEnabled()) {
            int otherSvcsOnIfCnt = this.countOtherServicesOnInterface(dbConn, nodeid, ipAddr, service);
            if (otherSvcsOnIfCnt == 0 && this.countServicesOnOtherInterfaces(dbConn, nodeid, ipAddr) == 0) {
                this.log().debug("Propagating service delete to node " + nodeid);
                eventsToSend.addAll(this.doDeleteNode(dbConn, source, nodeid, txNo));
            } else if (otherSvcsOnIfCnt == 0) {
                this.log().debug("Propagting service delete to interface " + nodeid + "/" + ipAddr);
                eventsToSend.addAll(this.doDeleteInterface(dbConn, source, nodeid, ipAddr, txNo));
            } else {
                this.log().debug("No need to Propagate service delete " + nodeid + "/" + ipAddr + "/" + service);
                eventsToSend.addAll(this.markServiceDeleted(dbConn, source, nodeid, ipAddr, service, txNo));
            }
        } else {
            this.log().debug("Propagation disabled:  deleting only service " + nodeid + "/" + ipAddr + "/" + service);
            eventsToSend.addAll(this.markServiceDeleted(dbConn, source, nodeid, ipAddr, service, txNo));
        }
        this.deleteAlarmsForService(dbConn, nodeid, ipAddr, service);
        return eventsToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> doDeleteServiceMapping(Connection dbConn, String ipaddr, String serviceName, long txNo) throws SQLException, FailedOperationException {
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            if (this.log().isDebugEnabled()) {
                this.log().debug("handleUpdateService: delete service: " + serviceName + " on IPAddress: " + ipaddr);
            }
            stmt = dbConn.prepareStatement(SQL_DELETE_SERVICE_INTERFACE_MAPPING);
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr);
            stmt.setString(2, serviceName);
            stmt.executeUpdate();
            List<Event> list = this.doChangeService(dbConn, ipaddr, serviceName, "DELETE", txNo);
            return list;
        }
        finally {
            d.cleanUp();
        }
    }

    private List<Event> doUpdateServer(Connection dbConn, String nodeLabel, String ipaddr, String action, String hostName, long txNo) throws SQLException, FailedOperationException {
        boolean exists = this.existsInServerMap(dbConn, hostName, ipaddr);
        if ("DELETE".equalsIgnoreCase(action)) {
            return this.doDeleteInterfaceMappings(dbConn, nodeLabel, ipaddr, hostName, txNo);
        }
        if ("ADD".equalsIgnoreCase(action)) {
            if (exists) {
                throw new FailedOperationException("Could not add interface " + ipaddr + " to NMS server: " + hostName + " because it already exists!");
            }
            return this.doCreateInterfaceMappings(dbConn, nodeLabel, ipaddr, hostName, txNo);
        }
        this.log().error("updateServerHandler: could not process interface: " + ipaddr + " on NMS server: " + hostName + ": action " + action + " unknown");
        throw new FailedOperationException("Undefined operation " + action + " for updateServer event!");
    }

    private List<Event> doUpdateService(Connection dbConn, String nodeLabel, String ipaddr, String serviceName, String action, long txNo) throws SQLException, FailedOperationException {
        this.verifyServiceExists(dbConn, serviceName);
        this.verifyInterfaceExists(dbConn, nodeLabel, ipaddr);
        boolean mapExists = this.serviceMappingExists(dbConn, ipaddr, serviceName);
        List<Event> eventsToSend = mapExists && "DELETE".equalsIgnoreCase(action) ? this.doDeleteServiceMapping(dbConn, ipaddr, serviceName, txNo) : (!mapExists && "ADD".equalsIgnoreCase(action) ? this.doAddServiceMapping(dbConn, ipaddr, serviceName, txNo) : Collections.emptyList());
        return eventsToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existsInServerMap(Connection dbConn, String hostName, String ipaddr) throws SQLException {
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            String SQL_QUERY_INTERFACE_ON_SERVER = "SELECT count(*)  FROM serverMap WHERE ipaddr = ? AND servername = ?";
            stmt = dbConn.prepareStatement("SELECT count(*)  FROM serverMap WHERE ipaddr = ? AND servername = ?");
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr);
            stmt.setString(2, hostName);
            ResultSet rs = stmt.executeQuery();
            int count = 0;
            while (rs.next()) {
                count = rs.getInt(1);
            }
            boolean bl = count > 0;
            return bl;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] findNodeIdForServiceAndInterface(Connection dbConn, String ipaddr, String serviceName) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement(SQL_QUERY_SERVICE_EXIST);
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr);
            stmt.setString(2, serviceName);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            LinkedList<Integer> nodeIdList = new LinkedList<Integer>();
            while (rs.next()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("changeService: service " + serviceName + " on IPAddress " + ipaddr + " already exists in the database.");
                }
                int nodeId = rs.getInt(1);
                nodeIdList.add(nodeId);
            }
            int[] nodeIds = new int[nodeIdList.size()];
            int i = 0;
            for (Integer n : nodeIdList) {
                nodeIds[i++] = n;
            }
            int[] nArray = nodeIds;
            return nArray;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] findNodeIdsForInterfaceAndLabel(Connection dbConn, String nodeLabel, String ipAddr) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement("SELECT node.nodeid FROM node, ipinterface WHERE node.nodeid = ipinterface.nodeid AND node.nodelabel = ? AND ipinterface.ipaddr = ? AND isManaged !='D' AND nodeType !='D'");
            d.watch((Object)stmt);
            stmt.setString(1, nodeLabel);
            stmt.setString(2, ipAddr);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            LinkedList<Long> nodeIdList = new LinkedList<Long>();
            while (rs.next()) {
                nodeIdList.add(rs.getLong(1));
            }
            long[] nodeIds = new long[nodeIdList.size()];
            int i = 0;
            for (Long nodeId : nodeIdList) {
                nodeIds[i++] = nodeId;
            }
            long[] lArray = nodeIds;
            return lArray;
        }
        finally {
            d.cleanUp();
        }
    }

    public String getName() {
        return "Capsd:BroadcastEventProcessor";
    }

    /*
     * Unable to fully structure code
     */
    @EventHandler(uei="uei.opennms.org/internal/capsd/addInterface")
    public void handleAddInterface(Event event) throws InsufficientInformationException, FailedOperationException {
        block26: {
            EventUtils.checkInterface(event);
            EventUtils.requireParm(event, "nodelabel");
            if (BroadcastEventProcessor.isXmlRpcEnabled()) {
                EventUtils.requireParm(event, "txno");
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("addInterfaceHandler:  processing addInterface event for " + event.getInterface());
            }
            nodeLabel = EventUtils.getParm(event, "nodelabel");
            txNo = EventUtils.getLongParm(event, "txno", -1L);
            dbConn = null;
            eventsToSend = null;
            dbConn = this.getConnection();
            dbConn.setAutoCommit(false);
            eventsToSend = this.doAddInterface(dbConn, nodeLabel, event.getInterface());
            var9_6 = null;
            if (dbConn == null) break block26;
            try {
                block27: {
                    if (eventsToSend != null) {
                        dbConn.commit();
                        for (Event e : eventsToSend) {
                            EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                        }
                        break block27;
                    }
                    dbConn.rollback();
                }
                var13_14 = null;
                ** if (dbConn == null) goto lbl-1000
            }
            catch (Throwable var12_22) {
                var13_15 = null;
                if (dbConn != null) {
                    try {
                        dbConn.setAutoCommit(true);
                        dbConn.close();
                    }
                    catch (SQLException ex) {
                        this.log().error("handleAddInterface: Threw Exception during close: ", (Throwable)ex);
                    }
                }
                throw var12_22;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    dbConn.setAutoCommit(true);
                    dbConn.close();
                }
                catch (SQLException ex) {
                    this.log().error("handleAddInterface: Threw Exception during close: ", (Throwable)ex);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block26;
                catch (SQLException ex) {
                    this.log().error("handleAddInterface: Threw Exception during commit: ", (Throwable)ex);
                    throw new FailedOperationException("Database error: " + ex.getMessage(), ex);
                }
            }
            {
                catch (SQLException sqlE) {
                    this.log().error("addInterfaceHandler: SQLException during add node and ipaddress to the database.", (Throwable)sqlE);
                    throw new FailedOperationException("Database error: " + sqlE.getMessage(), sqlE);
                }
            }
            catch (Throwable var8_25) {
                block30: {
                    var9_7 = null;
                    if (dbConn != null) {
                        try {
                            block29: {
                                if (eventsToSend != null) {
                                    dbConn.commit();
                                    for (Event e : eventsToSend) {
                                        EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                                    }
                                    break block29;
                                }
                                dbConn.rollback();
                            }
                            var13_16 = null;
                            ** if (dbConn == null) goto lbl-1000
                        }
                        catch (Throwable var12_23) {
                            var13_17 = null;
                            if (dbConn != null) {
                                try {
                                    dbConn.setAutoCommit(true);
                                    dbConn.close();
                                }
                                catch (SQLException ex) {
                                    this.log().error("handleAddInterface: Threw Exception during close: ", (Throwable)ex);
                                }
                            }
                            throw var12_23;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                dbConn.setAutoCommit(true);
                                dbConn.close();
                            }
                            catch (SQLException ex) {
                                this.log().error("handleAddInterface: Threw Exception during close: ", (Throwable)ex);
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block30;
                            catch (SQLException ex) {
                                this.log().error("handleAddInterface: Threw Exception during commit: ", (Throwable)ex);
                                throw new FailedOperationException("Database error: " + ex.getMessage(), ex);
                            }
                        }
                    }
                }
                throw var8_25;
            }
        }
    }

    private Connection getConnection() throws SQLException {
        return DataSourceFactory.getInstance().getConnection();
    }

    /*
     * Unable to fully structure code
     */
    @EventHandler(uei="uei.opennms.org/internal/capsd/addNode")
    public void handleAddNode(Event event) throws InsufficientInformationException, FailedOperationException {
        block25: {
            EventUtils.requireParm(event, "nodelabel");
            if (BroadcastEventProcessor.isXmlRpcEnabled()) {
                EventUtils.requireParm(event, "txno");
            }
            ipaddr = event.getInterface();
            nodeLabel = EventUtils.getParm(event, "nodelabel");
            txNo = EventUtils.getLongParm(event, "txno", -1L);
            this.log().debug("addNodeHandler:  processing addNode event for " + ipaddr);
            dbConn = null;
            eventsToSend = null;
            dbConn = this.getConnection();
            dbConn.setAutoCommit(false);
            eventsToSend = this.doAddNode(dbConn, nodeLabel, ipaddr);
            var10_7 = null;
            if (dbConn == null) break block25;
            try {
                block26: {
                    if (eventsToSend != null) {
                        dbConn.commit();
                        for (Event e : eventsToSend) {
                            EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                        }
                        break block26;
                    }
                    dbConn.rollback();
                }
                var14_15 = null;
                ** if (dbConn == null) goto lbl-1000
            }
            catch (Throwable var13_23) {
                var14_16 = null;
                if (dbConn != null) {
                    try {
                        dbConn.close();
                    }
                    catch (SQLException ex) {
                        this.log().error("handleAddNode: Threw Exception during close: ", (Throwable)ex);
                    }
                }
                throw var13_23;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    dbConn.close();
                }
                catch (SQLException ex) {
                    this.log().error("handleAddNode: Threw Exception during close: ", (Throwable)ex);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block25;
                catch (SQLException ex) {
                    this.log().error("handleAddNode: Threw Exception during commit: ", (Throwable)ex);
                    throw new FailedOperationException("database error: " + ex.getMessage(), ex);
                }
            }
            {
                catch (SQLException sqlE) {
                    this.log().error("addNodeHandler: SQLException during add node and ipaddress to tables", (Throwable)sqlE);
                    throw new FailedOperationException("database error: " + sqlE.getMessage(), sqlE);
                }
            }
            catch (Throwable var9_26) {
                block29: {
                    var10_8 = null;
                    if (dbConn != null) {
                        try {
                            block28: {
                                if (eventsToSend != null) {
                                    dbConn.commit();
                                    for (Event e : eventsToSend) {
                                        EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                                    }
                                    break block28;
                                }
                                dbConn.rollback();
                            }
                            var14_17 = null;
                            ** if (dbConn == null) goto lbl-1000
                        }
                        catch (Throwable var13_24) {
                            var14_18 = null;
                            if (dbConn != null) {
                                try {
                                    dbConn.close();
                                }
                                catch (SQLException ex) {
                                    this.log().error("handleAddNode: Threw Exception during close: ", (Throwable)ex);
                                }
                            }
                            throw var13_24;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                dbConn.close();
                            }
                            catch (SQLException ex) {
                                this.log().error("handleAddNode: Threw Exception during close: ", (Throwable)ex);
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block29;
                            catch (SQLException ex) {
                                this.log().error("handleAddNode: Threw Exception during commit: ", (Throwable)ex);
                                throw new FailedOperationException("database error: " + ex.getMessage(), ex);
                            }
                        }
                    }
                }
                throw var9_26;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler(uei="uei.opennms.org/internal/capsd/changeService")
    public void handleChangeService(Event event) throws InsufficientInformationException, FailedOperationException {
        List<Event> eventsToSend;
        Connection dbConn;
        long txNo;
        block20: {
            EventUtils.checkInterface(event);
            EventUtils.checkService(event);
            EventUtils.requireParm(event, "action");
            if (BroadcastEventProcessor.isXmlRpcEnabled()) {
                EventUtils.requireParm(event, "txno");
            }
            String action = EventUtils.getParm(event, "action");
            txNo = EventUtils.getLongParm(event, "txno", -1L);
            this.log().debug("changeServiceHandler:  processing changeService event on: " + event.getInterface());
            dbConn = null;
            eventsToSend = null;
            dbConn = this.getConnection();
            dbConn.setAutoCommit(false);
            eventsToSend = this.doChangeService(dbConn, event.getInterface(), event.getService(), action, txNo);
            Object var9_6 = null;
            if (dbConn == null) return;
            if (eventsToSend != null) {
                dbConn.commit();
                for (Event e : eventsToSend) {
                    EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
                break block20;
            }
            dbConn.rollback();
        }
        Object var13_14 = null;
        if (dbConn == null) return;
        try {
            dbConn.close();
            return;
        }
        catch (SQLException ex) {
            this.log().error("handleChangeService: Exception thrown closing connection: " + ex);
        }
        return;
        {
            catch (SQLException ex) {
                this.log().error("handleChangeService: Exception thrown during commit/rollback: ", (Throwable)ex);
                throw new FailedOperationException("exeption processing changeService: " + ex.getMessage(), ex);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (dbConn == null) throw throwable;
            try {
                dbConn.close();
                throw throwable;
            }
            catch (SQLException ex) {
                this.log().error("handleChangeService: Exception thrown closing connection: " + ex);
            }
            throw throwable;
        }
        {
            catch (SQLException sqlE) {
                this.log().error("SQLException during changeService on database.", (Throwable)sqlE);
                throw new FailedOperationException("exeption processing changeService: " + sqlE.getMessage(), sqlE);
            }
        }
        catch (Throwable throwable) {
            block21: {
                Object var9_7 = null;
                if (dbConn == null) throw throwable;
                if (eventsToSend != null) {
                    dbConn.commit();
                    for (Event e : eventsToSend) {
                        EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                    }
                    break block21;
                }
                dbConn.rollback();
            }
            Object var13_16 = null;
            if (dbConn == null) throw throwable;
            try {
                dbConn.close();
                throw throwable;
            }
            catch (SQLException ex) {
                this.log().error("handleChangeService: Exception thrown closing connection: " + ex);
            }
            throw throwable;
            {
                catch (SQLException ex) {
                    this.log().error("handleChangeService: Exception thrown during commit/rollback: ", (Throwable)ex);
                    throw new FailedOperationException("exeption processing changeService: " + ex.getMessage(), ex);
                }
            }
            catch (Throwable throwable2) {
                Object var13_17 = null;
                if (dbConn == null) throw throwable2;
                try {
                    dbConn.close();
                    throw throwable2;
                }
                catch (SQLException ex) {
                    this.log().error("handleChangeService: Exception thrown closing connection: " + ex);
                }
                throw throwable2;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @EventHandler(uei="uei.opennms.org/internal/capsd/deleteInterface")
    public void handleDeleteInterface(Event event) throws InsufficientInformationException, FailedOperationException {
        block27: {
            EventUtils.checkEventId(event);
            EventUtils.checkInterfaceOrIfIndex(event);
            EventUtils.checkNodeId(event);
            ifIndex = -1;
            if (event.hasIfIndex()) {
                ifIndex = event.getIfIndex();
            }
            if (BroadcastEventProcessor.isXmlRpcEnabled()) {
                EventUtils.requireParm(event, "txno");
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("handleDeleteInterface: Event\nuei\t\t" + event.getUei() + "\neventid\t\t" + event.getDbid() + "\nnodeId\t\t" + event.getNodeid() + "\nipaddr\t\t" + (event.getInterface() != null ? event.getInterface() : "N/A") + "\nifIndex\t\t" + (ifIndex > -1 ? Integer.valueOf(ifIndex) : "N/A") + "\neventtime\t" + (event.getTime() != null ? event.getTime() : "<null>"));
            }
            txNo = EventUtils.getLongParm(event, "txno", -1L);
            dbConn = null;
            eventsToSend = null;
            dbConn = this.getConnection();
            dbConn.setAutoCommit(false);
            source = event.getSource() == null ? "OpenNMS.Capsd" : event.getSource();
            eventsToSend = this.doDeleteInterface(dbConn, source, event.getNodeid(), event.getInterface(), ifIndex, txNo);
            var9_8 = null;
            if (dbConn == null) break block27;
            try {
                block28: {
                    if (eventsToSend != null) {
                        dbConn.commit();
                        for (Event e : eventsToSend) {
                            EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                        }
                        break block28;
                    }
                    dbConn.rollback();
                }
                var13_16 = null;
                ** if (dbConn == null) goto lbl-1000
            }
            catch (Throwable var12_24) {
                var13_17 = null;
                if (dbConn != null) {
                    try {
                        dbConn.close();
                    }
                    catch (SQLException ex) {
                        this.log().error("handleDeleteInterface: Exception thrown closing connection: ", (Throwable)ex);
                    }
                }
                throw var12_24;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    dbConn.close();
                }
                catch (SQLException ex) {
                    this.log().error("handleDeleteInterface: Exception thrown closing connection: ", (Throwable)ex);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block27;
                catch (SQLException ex) {
                    this.log().error("handleDeleteInterface: Exception thrown during commit/rollback: ", (Throwable)ex);
                    throw new FailedOperationException("exeption processing delete interface: " + ex.getMessage(), ex);
                }
            }
            {
                catch (SQLException ex) {
                    this.log().error("handleDeleteInterface:  Database error deleting interface on node " + event.getNodeid() + " with ip address " + (event.getInterface() != null ? event.getInterface() : "null") + " and ifIndex " + (event.hasIfIndex() != false ? Integer.valueOf(event.getIfIndex()) : "null"), (Throwable)ex);
                    throw new FailedOperationException("database error: " + ex.getMessage(), ex);
                }
            }
            catch (Throwable var8_26) {
                block31: {
                    var9_9 = null;
                    if (dbConn != null) {
                        try {
                            block30: {
                                if (eventsToSend != null) {
                                    dbConn.commit();
                                    for (Event e : eventsToSend) {
                                        EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                                    }
                                    break block30;
                                }
                                dbConn.rollback();
                            }
                            var13_18 = null;
                            ** if (dbConn == null) goto lbl-1000
                        }
                        catch (Throwable var12_25) {
                            var13_19 = null;
                            if (dbConn != null) {
                                try {
                                    dbConn.close();
                                }
                                catch (SQLException ex) {
                                    this.log().error("handleDeleteInterface: Exception thrown closing connection: ", (Throwable)ex);
                                }
                            }
                            throw var12_25;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                dbConn.close();
                            }
                            catch (SQLException ex) {
                                this.log().error("handleDeleteInterface: Exception thrown closing connection: ", (Throwable)ex);
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block31;
                            catch (SQLException ex) {
                                this.log().error("handleDeleteInterface: Exception thrown during commit/rollback: ", (Throwable)ex);
                                throw new FailedOperationException("exeption processing delete interface: " + ex.getMessage(), ex);
                            }
                        }
                    }
                }
                throw var8_26;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler(uei="uei.opennms.org/internal/capsd/deleteNode")
    public void handleDeleteNode(Event event) throws InsufficientInformationException, FailedOperationException {
        List<Event> eventsToSend;
        Connection dbConn;
        long txNo;
        long nodeid;
        block21: {
            EventUtils.checkEventId(event);
            EventUtils.checkNodeId(event);
            if (BroadcastEventProcessor.isXmlRpcEnabled()) {
                EventUtils.requireParm(event, "txno");
            }
            nodeid = event.getNodeid();
            if (this.log().isDebugEnabled()) {
                this.log().debug("handleDeleteNode: Event\nuei\t\t" + event.getUei() + "\neventid\t\t" + event.getDbid() + "\nnodeId\t\t" + nodeid + "\neventtime\t" + (event.getTime() != null ? event.getTime() : "<null>"));
            }
            txNo = EventUtils.getLongParm(event, "txno", -1L);
            dbConn = null;
            eventsToSend = null;
            dbConn = this.getConnection();
            dbConn.setAutoCommit(false);
            String source = event.getSource() == null ? "OpenNMS.Capsd" : event.getSource();
            eventsToSend = this.doDeleteNode(dbConn, source, nodeid, txNo);
            Object var10_8 = null;
            if (dbConn == null) return;
            if (eventsToSend != null) {
                dbConn.commit();
                for (Event e : eventsToSend) {
                    EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
                break block21;
            }
            dbConn.rollback();
        }
        Object var14_16 = null;
        if (dbConn == null) return;
        try {
            dbConn.close();
            return;
        }
        catch (SQLException ex) {
            this.log().error("handleDeleteNode: Exception thrown closing connection: ", (Throwable)ex);
        }
        return;
        {
            catch (SQLException ex) {
                this.log().error("handleDeleteNode: Exception thrown during commit/rollback: ", (Throwable)ex);
                throw new FailedOperationException("exeption processing deleteNode: " + ex.getMessage(), ex);
            }
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            if (dbConn == null) throw throwable;
            try {
                dbConn.close();
                throw throwable;
            }
            catch (SQLException ex) {
                this.log().error("handleDeleteNode: Exception thrown closing connection: ", (Throwable)ex);
            }
            throw throwable;
        }
        {
            catch (SQLException ex) {
                this.log().error("handleDeleteService:  Database error deleting service " + event.getService() + " on ipAddr " + event.getInterface() + " for node " + nodeid, (Throwable)ex);
                throw new FailedOperationException("database error: " + ex.getMessage(), ex);
            }
        }
        catch (Throwable throwable) {
            block22: {
                Object var10_9 = null;
                if (dbConn == null) throw throwable;
                if (eventsToSend != null) {
                    dbConn.commit();
                    for (Event e : eventsToSend) {
                        EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                    }
                    break block22;
                }
                dbConn.rollback();
            }
            Object var14_18 = null;
            if (dbConn == null) throw throwable;
            try {
                dbConn.close();
                throw throwable;
            }
            catch (SQLException ex) {
                this.log().error("handleDeleteNode: Exception thrown closing connection: ", (Throwable)ex);
            }
            throw throwable;
            {
                catch (SQLException ex) {
                    this.log().error("handleDeleteNode: Exception thrown during commit/rollback: ", (Throwable)ex);
                    throw new FailedOperationException("exeption processing deleteNode: " + ex.getMessage(), ex);
                }
            }
            catch (Throwable throwable2) {
                Object var14_19 = null;
                if (dbConn == null) throw throwable2;
                try {
                    dbConn.close();
                    throw throwable2;
                }
                catch (SQLException ex) {
                    this.log().error("handleDeleteNode: Exception thrown closing connection: ", (Throwable)ex);
                }
                throw throwable2;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventHandler(uei="uei.opennms.org/nodes/deleteService")
    public void handleDeleteService(Event event) throws InsufficientInformationException, FailedOperationException {
        EventUtils.checkEventId(event);
        EventUtils.checkNodeId(event);
        EventUtils.checkInterface(event);
        EventUtils.checkService(event);
        if (this.log().isDebugEnabled()) {
            this.log().debug("handleDeleteService: Event\nuei\t\t" + event.getUei() + "\neventid\t\t" + event.getDbid() + "\nnodeid\t\t" + event.getNodeid() + "\nipaddr\t\t" + event.getInterface() + "\nservice\t\t" + event.getService() + "\neventtime\t" + (event.getTime() != null ? event.getTime() : "<null>"));
        }
        txNo = EventUtils.getLongParm(event, "txno", -1L);
        dbConn = null;
        eventsToSend = null;
        try {
            dbConn = this.getConnection();
            dbConn.setAutoCommit(false);
            source = event.getSource() == null ? "OpenNMS.Capsd" : event.getSource();
            eventsToSend = this.doDeleteService(dbConn, source, event.getNodeid(), event.getInterface(), event.getService(), txNo);
            var8_7 = null;
            if (dbConn == null) return;
            try {
                block21: {
                    try {
                        if (eventsToSend != null) {
                            dbConn.commit();
                            for (Event e : eventsToSend) {
                                EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                            }
                            break block21;
                        }
                        dbConn.rollback();
                    }
                    catch (SQLException ex) {
                        this.log().error("handleDeleteService: Exception thrown during commit/rollback: ", (Throwable)ex);
                        throw new FailedOperationException("exeption processing deleteService: " + ex.getMessage(), ex);
                    }
                }
                var12_15 = null;
                if (dbConn == null) return;
                try {
                    dbConn.close();
                    return;
                }
                catch (SQLException ex) {
                    this.log().error("handleDeleteService: Exception thrown closing connection: ", (Throwable)ex);
                    return;
                }
            }
            catch (Throwable var11_23) {
                var12_16 = null;
                if (dbConn == null) throw var11_23;
                ** try [egrp 4[TRYBLOCK] [6 : 453->463)] { 
lbl46:
                // 1 sources

                dbConn.close();
                throw var11_23;
lbl48:
                // 1 sources

                catch (SQLException ex) {
                    this.log().error("handleDeleteService: Exception thrown closing connection: ", (Throwable)ex);
                }
                throw var11_23;
            }
            catch (SQLException ex) {
                this.log().error("handleDeleteService:  Database error deleting service " + event.getService() + " on ipAddr " + event.getInterface() + " for node " + event.getNodeid(), (Throwable)ex);
                throw new FailedOperationException("database error: " + ex.getMessage(), ex);
            }
        }
        catch (Throwable var7_25) {
            var8_8 = null;
            if (dbConn == null) throw var7_25;
            ** try [egrp 2[TRYBLOCK] [4 : 315->438)] { 
lbl59:
            // 1 sources

            ** try [egrp 3[TRYBLOCK] [3 : 315->384)] { 
lbl60:
            // 1 sources

            if (eventsToSend != null) {
                dbConn.commit();
                for (Event e : eventsToSend) {
                    EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
            } else {
                dbConn.rollback();
            }
            var12_17 = null;
            if (dbConn == null) throw var7_25;
            try {}
            catch (SQLException ex) {
                this.log().error("handleDeleteService: Exception thrown closing connection: ", (Throwable)ex);
                throw var7_25;
            }
            dbConn.close();
            throw var7_25;
lbl76:
            // 1 sources

            catch (SQLException ex) {
                this.log().error("handleDeleteService: Exception thrown during commit/rollback: ", (Throwable)ex);
                throw new FailedOperationException("exeption processing deleteService: " + ex.getMessage(), ex);
            }
lbl79:
            // 1 sources

            catch (Throwable var11_24) {
                var12_18 = null;
                if (dbConn == null) throw var11_24;
                ** try [egrp 4[TRYBLOCK] [6 : 453->463)] { 
lbl84:
                // 1 sources

                dbConn.close();
                throw var11_24;
lbl86:
                // 1 sources

                catch (SQLException ex) {
                    this.log().error("handleDeleteService: Exception thrown closing connection: ", (Throwable)ex);
                }
                throw var11_24;
            }
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/duplicateNodeDeleted")
    public void handleDupNodeDeleted(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        this.m_scheduler.unscheduleNode((int)event.getNodeid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventHandler(uei="uei.opennms.org/internal/capsd/forceRescan")
    public void handleForceRescan(Event event) throws InsufficientInformationException {
        int nodeid;
        block9: {
            nodeid = -1;
            if (event.hasNodeid()) {
                nodeid = (int)event.getNodeid();
            } else {
                EventUtils.checkInterface(event);
                Connection dbc = null;
                PreparedStatement stmt = null;
                ResultSet rs = null;
                DBUtils d = new DBUtils(this.getClass());
                try {
                    block8: {
                        try {
                            dbc = this.getConnection();
                            d.watch((Object)dbc);
                            stmt = dbc.prepareStatement(SQL_RETRIEVE_NODEID);
                            d.watch((Object)stmt);
                            stmt.setString(1, event.getInterface());
                            rs = stmt.executeQuery();
                            d.watch((Object)rs);
                            if (!rs.next()) break block8;
                            nodeid = rs.getInt(1);
                        }
                        catch (SQLException sqlE) {
                            this.log().error("handleForceRescan: Database error during nodeid retrieval for interface " + event.getInterface(), (Throwable)sqlE);
                            Object var9_8 = null;
                            d.cleanUp();
                            break block9;
                        }
                    }
                    Object var9_7 = null;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    d.cleanUp();
                    throw throwable;
                }
                d.cleanUp();
            }
        }
        if (nodeid == -1) {
            this.log().error("handleForceRescan: Nodeid retrieval for interface " + event.getInterface() + " failed.  Unable to perform rescan.");
            return;
        }
        if (RescanProcessor.isRescanQueuedForNode(nodeid)) {
            this.log().info("Ignoring forceRescan event for node " + nodeid + " because a forceRescan for that node already exists in the queue");
            return;
        }
        this.m_scheduler.forceRescan(nodeid);
    }

    @EventHandler(uei="uei.opennms.org/internal/discovery/newSuspect")
    public void handleNewSuspect(Event event) throws InsufficientInformationException {
        EventUtils.checkInterface(event);
        if (SuspectEventProcessor.isScanQueuedForAddress(event.getInterface())) {
            this.log().info("Ignoring newSuspect event for interface " + event.getInterface() + " because a newSuspect scan for that interface already exists in the queue");
            return;
        }
        try {
            this.log().debug("onMessage: Adding interface to suspectInterface Q: " + event.getInterface());
            this.m_suspectQ.add((Object)this.m_suspectEventProcessorFactory.createSuspectEventProcessor(event.getInterface()));
        }
        catch (Exception ex) {
            this.log().error("onMessage: Failed to add interface to suspect queue", (Throwable)ex);
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeAdded")
    public void handleNodeAdded(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        try {
            this.m_scheduler.scheduleNode((int)event.getNodeid());
        }
        catch (SQLException sqlE) {
            this.log().error("onMessage: SQL exception while attempting to schedule node " + event.getNodeid(), (Throwable)sqlE);
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeDeleted")
    public void handleNodeDeleted(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        this.m_scheduler.unscheduleNode((int)event.getNodeid());
    }

    /*
     * Unable to fully structure code
     */
    @EventHandler(uei="uei.opennms.org/internal/capsd/updateServer")
    public void handleUpdateServer(Event event) throws InsufficientInformationException, FailedOperationException {
        block26: {
            EventUtils.checkInterface(event);
            EventUtils.checkHost(event);
            EventUtils.requireParm(event, "action");
            EventUtils.requireParm(event, "nodelabel");
            if (BroadcastEventProcessor.isXmlRpcEnabled()) {
                EventUtils.requireParm(event, "txno");
            }
            action = EventUtils.getParm(event, "action");
            nodeLabel = EventUtils.getParm(event, "nodelabel");
            txNo = EventUtils.getLongParm(event, "txno", -1L);
            if (this.log().isDebugEnabled()) {
                this.log().debug("updateServerHandler:  processing updateServer event for: " + event.getInterface() + " on OpenNMS server: " + this.m_localServer);
            }
            dbConn = null;
            eventsToSend = null;
            dbConn = this.getConnection();
            dbConn.setAutoCommit(false);
            eventsToSend = this.doUpdateServer(dbConn, nodeLabel, event.getInterface(), action, this.m_localServer, txNo);
            var10_7 = null;
            if (dbConn == null) break block26;
            try {
                block27: {
                    if (eventsToSend != null) {
                        dbConn.commit();
                        for (Event e : eventsToSend) {
                            EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                        }
                        break block27;
                    }
                    dbConn.rollback();
                }
                var14_15 = null;
                ** if (dbConn == null) goto lbl-1000
            }
            catch (Throwable var13_23) {
                var14_16 = null;
                if (dbConn != null) {
                    try {
                        dbConn.close();
                    }
                    catch (SQLException ex) {
                        this.log().error("handleUpdateServer: Exception thrown closing connection: ", (Throwable)ex);
                    }
                }
                throw var13_23;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    dbConn.close();
                }
                catch (SQLException ex) {
                    this.log().error("handleUpdateServer: Exception thrown closing connection: ", (Throwable)ex);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block26;
                catch (SQLException ex) {
                    this.log().error("handleUpdateServer: Exception thrown during commit/rollback: ", (Throwable)ex);
                    throw new FailedOperationException("SQLException during updateServer on database.", ex);
                }
            }
            {
                catch (SQLException sqlE) {
                    this.log().error("SQLException during updateServer on database.", (Throwable)sqlE);
                    throw new FailedOperationException("SQLException during updateServer on database.", sqlE);
                }
            }
            catch (Throwable var9_26) {
                block30: {
                    var10_8 = null;
                    if (dbConn != null) {
                        try {
                            block29: {
                                if (eventsToSend != null) {
                                    dbConn.commit();
                                    for (Event e : eventsToSend) {
                                        EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                                    }
                                    break block29;
                                }
                                dbConn.rollback();
                            }
                            var14_17 = null;
                            ** if (dbConn == null) goto lbl-1000
                        }
                        catch (Throwable var13_24) {
                            var14_18 = null;
                            if (dbConn != null) {
                                try {
                                    dbConn.close();
                                }
                                catch (SQLException ex) {
                                    this.log().error("handleUpdateServer: Exception thrown closing connection: ", (Throwable)ex);
                                }
                            }
                            throw var13_24;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                dbConn.close();
                            }
                            catch (SQLException ex) {
                                this.log().error("handleUpdateServer: Exception thrown closing connection: ", (Throwable)ex);
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block30;
                            catch (SQLException ex) {
                                this.log().error("handleUpdateServer: Exception thrown during commit/rollback: ", (Throwable)ex);
                                throw new FailedOperationException("SQLException during updateServer on database.", ex);
                            }
                        }
                    }
                }
                throw var9_26;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @EventHandler(uei="uei.opennms.org/internal/capsd/updateService")
    public void handleUpdateService(Event event) throws InsufficientInformationException, FailedOperationException {
        block26: {
            EventUtils.checkInterface(event);
            EventUtils.checkService(event);
            EventUtils.requireParm(event, "nodelabel");
            EventUtils.requireParm(event, "action");
            if (BroadcastEventProcessor.isXmlRpcEnabled()) {
                EventUtils.requireParm(event, "txno");
            }
            txNo = EventUtils.getLongParm(event, "txno", -1L);
            action = EventUtils.getParm(event, "action");
            nodeLabel = EventUtils.getParm(event, "nodelabel");
            if (this.log().isDebugEnabled()) {
                this.log().debug("handleUpdateService:  processing updateService event for : " + event.getService() + " on : " + event.getInterface());
            }
            eventsToSend = null;
            dbConn = null;
            dbConn = this.getConnection();
            dbConn.setAutoCommit(false);
            eventsToSend = this.doUpdateService(dbConn, nodeLabel, event.getInterface(), event.getService(), action, txNo);
            var10_7 = null;
            if (dbConn == null) break block26;
            try {
                block27: {
                    if (eventsToSend != null) {
                        dbConn.commit();
                        for (Event e : eventsToSend) {
                            EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                        }
                        break block27;
                    }
                    dbConn.rollback();
                }
                var14_15 = null;
                ** if (dbConn == null) goto lbl-1000
            }
            catch (Throwable var13_23) {
                var14_16 = null;
                if (dbConn != null) {
                    try {
                        dbConn.close();
                    }
                    catch (SQLException ex) {
                        this.log().error("handleUpdateService: Exception thrown during close: ", (Throwable)ex);
                    }
                }
                throw var13_23;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    dbConn.close();
                }
                catch (SQLException ex) {
                    this.log().error("handleUpdateService: Exception thrown during close: ", (Throwable)ex);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block26;
                catch (SQLException ex) {
                    this.log().error("handleUpdateService: Exception thrown during commit/rollback: ", (Throwable)ex);
                    throw new FailedOperationException(ex.getMessage());
                }
            }
            {
                catch (SQLException sqlE) {
                    this.log().error("SQLException during handleUpdateService on database.", (Throwable)sqlE);
                    throw new FailedOperationException(sqlE.getMessage());
                }
            }
            catch (Throwable var9_26) {
                block30: {
                    var10_8 = null;
                    if (dbConn != null) {
                        try {
                            block29: {
                                if (eventsToSend != null) {
                                    dbConn.commit();
                                    for (Event e : eventsToSend) {
                                        EventUtils.sendEvent(e, event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                                    }
                                    break block29;
                                }
                                dbConn.rollback();
                            }
                            var14_17 = null;
                            ** if (dbConn == null) goto lbl-1000
                        }
                        catch (Throwable var13_24) {
                            var14_18 = null;
                            if (dbConn != null) {
                                try {
                                    dbConn.close();
                                }
                                catch (SQLException ex) {
                                    this.log().error("handleUpdateService: Exception thrown during close: ", (Throwable)ex);
                                }
                            }
                            throw var13_24;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                dbConn.close();
                            }
                            catch (SQLException ex) {
                                this.log().error("handleUpdateService: Exception thrown during close: ", (Throwable)ex);
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block30;
                            catch (SQLException ex) {
                                this.log().error("handleUpdateService: Exception thrown during commit/rollback: ", (Throwable)ex);
                                throw new FailedOperationException(ex.getMessage());
                            }
                        }
                    }
                }
                throw var9_26;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean interfaceExists(Connection dbConn, String nodeLabel, String ipaddr) throws SQLException {
        boolean bl;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement(SQL_QUERY_IPINTERFACE_EXIST);
            d.watch((Object)stmt);
            stmt.setString(1, nodeLabel);
            stmt.setString(2, ipaddr);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            bl = rs.next();
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            d.cleanUp();
            throw throwable;
        }
        d.cleanUp();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> markAllServicesForInterfaceDeleted(Connection dbConn, String source, long nodeId, String ipAddr, long txNo) throws SQLException {
        LinkedList<Event> linkedList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            LinkedList<Event> eventsToSend = new LinkedList<Event>();
            String DB_FIND_SERVICES_FOR_INTERFACE = "SELECT DISTINCT service.serviceName FROM ifservices as ifservices, service as service WHERE ifservices.nodeID = ? and ifservices.ipAddr = ? and ifservices.status != 'D' and ifservices.serviceID = service.serviceID";
            stmt = dbConn.prepareStatement("SELECT DISTINCT service.serviceName FROM ifservices as ifservices, service as service WHERE ifservices.nodeID = ? and ifservices.ipAddr = ? and ifservices.status != 'D' and ifservices.serviceID = service.serviceID");
            d.watch((Object)stmt);
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            HashSet<String> services = new HashSet<String>();
            while (rs.next()) {
                String serviceName = rs.getString(1);
                this.log().debug("found service " + serviceName + " for ipAddr " + ipAddr + " node " + nodeId);
                services.add(serviceName);
            }
            String DB_MARK_SERVICES_FOR_INTERFACE = "UPDATE ifservices SET status = 'D' where ifservices.nodeID = ? and ifservices.ipAddr = ?";
            stmt = dbConn.prepareStatement("UPDATE ifservices SET status = 'D' where ifservices.nodeID = ? and ifservices.ipAddr = ?");
            d.watch((Object)stmt);
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            stmt.executeUpdate();
            for (String serviceName : services) {
                this.log().debug("creating event for service " + serviceName + " for ipAddr " + ipAddr + " node " + nodeId);
                eventsToSend.add(EventUtils.createServiceDeletedEvent(source, nodeId, ipAddr, serviceName, txNo));
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("markServicesDeleted: marked service deleted: " + nodeId + "/" + ipAddr);
            }
            linkedList = eventsToSend;
            Object var18_15 = null;
        }
        catch (Throwable throwable) {
            Object var18_16 = null;
            d.cleanUp();
            throw throwable;
        }
        d.cleanUp();
        return linkedList;
    }

    private List<Event> markInterfaceDeleted(Connection dbConn, String source, long nodeId, String ipAddr, long txNo) throws SQLException {
        return this.markInterfaceDeleted(dbConn, source, nodeId, ipAddr, -1, txNo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> markInterfaceDeleted(Connection dbConn, String source, long nodeId, String ipAddr, int ifIndex, long txNo) throws SQLException {
        DBUtils d;
        block8: {
            List<Event> list;
            String DB_FIND_INTERFACE = "UPDATE ipinterface SET isManaged = 'D' WHERE nodeid = ? and ipAddr = ? and isManaged != 'D'";
            String DB_FIND_SNMPINTERFACE = "UPDATE snmpinterface SET snmpcollect = 'D' WHERE nodeid = ? and snmpifindex = ? and snmpcollect != 'D'";
            PreparedStatement stmt = null;
            d = new DBUtils(this.getClass());
            int countip = 0;
            int countsnmp = 0;
            try {
                if (!EventUtils.isNonIpInterface(ipAddr)) {
                    stmt = dbConn.prepareStatement("UPDATE ipinterface SET isManaged = 'D' WHERE nodeid = ? and ipAddr = ? and isManaged != 'D'");
                    d.watch((Object)stmt);
                    stmt.setLong(1, nodeId);
                    stmt.setString(2, ipAddr);
                    countip = stmt.executeUpdate();
                }
                if (ifIndex > -1) {
                    stmt = dbConn.prepareStatement("UPDATE snmpinterface SET snmpcollect = 'D' WHERE nodeid = ? and snmpifindex = ? and snmpcollect != 'D'");
                    d.watch((Object)stmt);
                    stmt.setLong(1, nodeId);
                    stmt.setInt(2, ifIndex);
                    countsnmp = stmt.executeUpdate();
                }
                if (countip > 0 && this.log().isDebugEnabled()) {
                    this.log().debug("markInterfaceDeleted: marked ip interface deleted: node = " + nodeId + ", IP address = " + ipAddr);
                }
                if (countsnmp > 0 && this.log().isDebugEnabled()) {
                    this.log().debug("markInterfaceDeleted: marked snmp interface deleted: node = " + nodeId + ", ifIndex = " + ifIndex);
                }
                if (countip <= 0 && countsnmp <= 0) break block8;
                list = Collections.singletonList(EventUtils.createInterfaceDeletedEvent(source, nodeId, ipAddr, ifIndex, txNo));
                Object var17_15 = null;
            }
            catch (Throwable throwable) {
                Object var17_17 = null;
                d.cleanUp();
                throw throwable;
            }
            d.cleanUp();
            return list;
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug("markInterfaceDeleted: Interface not found: node = " + nodeId + ", with ip address " + (ipAddr != null ? ipAddr : "null") + ", and ifIndex " + (ifIndex > -1 ? Integer.valueOf(ifIndex) : "N/A"));
        }
        List<Event> list = Collections.emptyList();
        Object var17_16 = null;
        d.cleanUp();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> markInterfacesAndServicesDeleted(Connection dbConn, String source, long nodeId, long txNo) throws SQLException {
        LinkedList<Event> linkedList;
        LinkedList<Event> eventsToSend = new LinkedList<Event>();
        String DB_FIND_IFS_FOR_NODE = "SELECT ipinterface.ipaddr FROM ipinterface WHERE ipinterface.nodeid = ? and ipinterface.ismanaged != 'D'";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement("SELECT ipinterface.ipaddr FROM ipinterface WHERE ipinterface.nodeid = ? and ipinterface.ismanaged != 'D'");
            d.watch((Object)stmt);
            stmt.setLong(1, nodeId);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            HashSet<String> ipAddrs = new HashSet<String>();
            while (rs.next()) {
                String ipAddr = rs.getString(1);
                this.log().debug("found interface " + ipAddr + " for node " + nodeId);
                ipAddrs.add(ipAddr);
            }
            for (String ipAddr : ipAddrs) {
                this.log().debug("deleting interface " + ipAddr + " for node " + nodeId);
                eventsToSend.addAll(this.markAllServicesForInterfaceDeleted(dbConn, source, nodeId, ipAddr, txNo));
                eventsToSend.addAll(this.markInterfaceDeleted(dbConn, source, nodeId, ipAddr, txNo));
            }
            linkedList = eventsToSend;
            Object var16_13 = null;
        }
        catch (Throwable throwable) {
            Object var16_14 = null;
            d.cleanUp();
            throw throwable;
        }
        d.cleanUp();
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> markNodeDeleted(Connection dbConn, String source, long nodeId, long txNo) throws SQLException {
        DBUtils d;
        block3: {
            List<Event> list;
            String DB_FIND_INTERFACE = "UPDATE node SET nodeType = 'D' WHERE nodeid = ? and nodeType != 'D'";
            PreparedStatement stmt = null;
            d = new DBUtils(this.getClass());
            try {
                stmt = dbConn.prepareStatement("UPDATE node SET nodeType = 'D' WHERE nodeid = ? and nodeType != 'D'");
                d.watch((Object)stmt);
                stmt.setLong(1, nodeId);
                int count = stmt.executeUpdate();
                this.log().debug("markServicesDeleted: marked service deleted: " + nodeId);
                if (count <= 0) break block3;
                list = Collections.singletonList(EventUtils.createNodeDeletedEvent(source, nodeId, txNo));
                Object var13_11 = null;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                d.cleanUp();
                throw throwable;
            }
            d.cleanUp();
            return list;
        }
        List<Event> list = Collections.emptyList();
        Object var13_12 = null;
        d.cleanUp();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Event> markServiceDeleted(Connection dbConn, String source, long nodeId, String ipAddr, String service, long txNo) throws SQLException {
        DBUtils d;
        block4: {
            List<Event> list;
            PreparedStatement stmt = null;
            String DB_MARK_SERVICE_DELETED = "UPDATE ifservices SET status='D' FROM service WHERE ifservices.serviceID = service.serviceID AND ifservices.nodeID=? AND ifservices.ipAddr=? AND service.serviceName=?";
            d = new DBUtils(this.getClass());
            try {
                stmt = dbConn.prepareStatement("UPDATE ifservices SET status='D' FROM service WHERE ifservices.serviceID = service.serviceID AND ifservices.nodeID=? AND ifservices.ipAddr=? AND service.serviceName=?");
                d.watch((Object)stmt);
                stmt.setLong(1, nodeId);
                stmt.setString(2, ipAddr);
                stmt.setString(3, service);
                int count = stmt.executeUpdate();
                if (this.log().isDebugEnabled()) {
                    this.log().debug("markServiceDeleted: marked service deleted: " + nodeId + "/" + ipAddr + "/" + service);
                }
                if (count <= 0) break block4;
                list = Collections.singletonList(EventUtils.createServiceDeletedEvent(source, nodeId, ipAddr, service, txNo));
                Object var15_13 = null;
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                d.cleanUp();
                throw throwable;
            }
            d.cleanUp();
            return list;
        }
        List<Event> list = Collections.emptyList();
        Object var15_14 = null;
        d.cleanUp();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean nodeExists(Connection dbConn, String nodeLabel) throws SQLException {
        boolean bl;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement(SQL_QUERY_NODE_EXIST);
            d.watch((Object)stmt);
            stmt.setString(1, nodeLabel);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            bl = rs.next();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            d.cleanUp();
            throw throwable;
        }
        d.cleanUp();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean serviceMappingExists(Connection dbConn, String ipaddr, String serviceName) throws SQLException {
        boolean bl;
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            boolean mapExists;
            stmt = dbConn.prepareStatement(SQL_QUERY_SERVICE_MAPPING_EXIST);
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr);
            stmt.setString(2, serviceName);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            bl = mapExists = rs.next();
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            d.cleanUp();
            throw throwable;
        }
        d.cleanUp();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int verifyServiceExists(Connection dbConn, String serviceName) throws SQLException, FailedOperationException {
        int n;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement(SQL_RETRIEVE_SERVICE_ID);
            d.watch((Object)stmt);
            stmt.setString(1, serviceName);
            rs = stmt.executeQuery();
            d.watch((Object)rs);
            int serviceId = -1;
            while (rs.next()) {
                this.log().debug("verifyServiceExists: retrieve serviceid for service " + serviceName);
                serviceId = rs.getInt(1);
            }
            if (serviceId < 0) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("verifyServiceExists: the specified service: " + serviceName + " does not exist in the database.");
                }
                throw new FailedOperationException("Invalid service: " + serviceName);
            }
            n = serviceId;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            d.cleanUp();
            throw throwable;
        }
        d.cleanUp();
        return n;
    }

    private void verifyInterfaceExists(Connection dbConn, String nodeLabel, String ipaddr) throws SQLException, FailedOperationException {
        if (!this.interfaceExists(dbConn, nodeLabel, ipaddr)) {
            throw new FailedOperationException("Interface " + ipaddr + " does not exist on a node with nodeLabel " + nodeLabel);
        }
    }

    public void setSuspectEventProcessorFactory(SuspectEventProcessorFactory suspectEventProcessorFactory) {
        this.m_suspectEventProcessorFactory = suspectEventProcessorFactory;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public void setSuspectQueue(FifoQueue<Runnable> suspectQ) {
        this.m_suspectQ = suspectQ;
    }

    public void setLocalServer(String localServer) {
        this.m_localServer = localServer;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_suspectEventProcessorFactory != null ? 1 : 0) != 0, (String)"The suspectEventProcessor must be set");
        Assert.state((this.m_scheduler != null ? 1 : 0) != 0, (String)"The schedule must be set");
        Assert.state((this.m_suspectQ != null ? 1 : 0) != 0, (String)"The suspectQueue must be set");
        Assert.state((this.m_localServer != null ? 1 : 0) != 0, (String)"The localServer must be set");
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

