/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.netmgt.capsd.ConnectionConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTcpPlugin
extends AbstractPlugin {
    int m_defaultPort;
    int m_defaultRetry;
    int m_defaultTimeout;
    String m_pluginName;
    String m_protocolName;

    protected AbstractTcpPlugin(String protocol, int defaultTimeout, int defaultRetry) {
        this(protocol, -1, defaultTimeout, defaultRetry);
    }

    protected AbstractTcpPlugin(String protocol, int defaultPort, int defaultTimeout, int defaultRetry) {
        if (protocol == null) {
            throw new NullPointerException("protocol is null");
        }
        this.m_protocolName = protocol;
        this.m_defaultPort = defaultPort;
        this.m_defaultTimeout = defaultTimeout;
        this.m_defaultRetry = defaultRetry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean checkConnection(ConnectionConfig config) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        int timeout = config.getTimeout() == 0 ? 10 : config.getTimeout();
        boolean isAServer = false;
        for (int attempts = 0; attempts <= config.getRetry() && !isAServer && this.preconnectCheck(config); ++attempts) {
            Socket socket = null;
            try {
                socket = new Socket();
                socket.connect(config.getSocketAddress(), timeout);
                socket.setSoTimeout(timeout);
                log.debug(this.getPluginName() + ": connected to host: " + config.getInetAddress() + " on port: " + config.getPort());
                socket = this.wrapSocket(socket, config);
                isAServer = this.checkProtocol(socket, config);
                continue;
            }
            catch (ConnectException cE) {
                log.debug(this.getPluginName() + ": connection refused to " + config.getInetAddress().getHostAddress() + ":" + config.getPort());
                isAServer = false;
                continue;
            }
            catch (NoRouteToHostException e) {
                e.fillInStackTrace();
                log.info(this.getPluginName() + ": Unable to test host " + config.getInetAddress().getHostAddress() + ", no route available", (Throwable)e);
                isAServer = false;
                throw new UndeclaredThrowableException(e);
            }
            catch (InterruptedIOException e) {
                log.debug(this.getPluginName() + ": did not connect to host within timeout: " + timeout + " attempt: " + attempts);
                isAServer = false;
                continue;
            }
            catch (IOException e) {
                log.info(this.getPluginName() + ": Error communicating with host " + config.getInetAddress().getHostAddress(), (Throwable)e);
                isAServer = false;
                continue;
            }
            catch (Throwable t) {
                log.warn(this.getPluginName() + ": Undeclared throwable exception caught contacting host " + config.getInetAddress().getHostAddress(), t);
                isAServer = false;
                continue;
            }
            finally {
                if (socket != null) {
                    this.closeSocket(socket, config);
                }
            }
        }
        return isAServer;
    }

    protected void closeSocket(Socket socket, ConnectionConfig config) {
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected abstract boolean checkProtocol(Socket var1, ConnectionConfig var2) throws Exception;

    protected ConnectionConfig createConnectionConfig(InetAddress address, int port) {
        return new ConnectionConfig(address, port);
    }

    protected List<ConnectionConfig> getConnectionConfigList(Map<String, Object> qualifiers, InetAddress address) {
        if (this.m_defaultPort == -1) {
            throw new IllegalStateException("m_defaultPort == -1");
        }
        int port = this.getKeyedInteger(qualifiers, "port", this.m_defaultPort);
        return Collections.singletonList(this.createConnectionConfig(address, port));
    }

    protected final int getKeyedInteger(Map<String, Object> qualifiers, String key, int defaultVal) {
        if (qualifiers == null) {
            return defaultVal;
        }
        return ParameterMap.getKeyedInteger(qualifiers, (String)key, (int)defaultVal);
    }

    protected final int[] getKeyedIntegerArray(Map<String, Object> qualifiers, String key, int[] defaultVal) {
        if (qualifiers == null) {
            return defaultVal;
        }
        return ParameterMap.getKeyedIntegerArray(qualifiers, (String)key, (int[])defaultVal);
    }

    public final String getPluginName() {
        if (this.m_pluginName == null) {
            String fullName = this.getClass().getName();
            int idx = fullName.lastIndexOf(46);
            this.m_pluginName = idx < 0 ? fullName : fullName.substring(idx + 1);
        }
        return this.m_pluginName;
    }

    @Override
    public final String getProtocolName() {
        return this.m_protocolName;
    }

    @Override
    public final boolean isProtocolSupported(InetAddress address) {
        return this.isProtocolSupported(address, null);
    }

    @Override
    public final boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        List<ConnectionConfig> connList = this.getConnectionConfigList(qualifiers, address);
        for (ConnectionConfig config : connList) {
            this.populateConnectionConfig(config, qualifiers);
            if (!this.checkConnection(config)) continue;
            if (qualifiers != null) {
                this.saveConfig(qualifiers, config);
            }
            return true;
        }
        return false;
    }

    protected void populateConnectionConfig(ConnectionConfig config, Map<String, Object> qualifiers) {
        config.setQualifiers(qualifiers);
        config.setTimeout(this.getKeyedInteger(qualifiers, "timeout", this.m_defaultTimeout));
        config.setRetry(this.getKeyedInteger(qualifiers, "retry", this.m_defaultRetry));
    }

    protected boolean preconnectCheck(ConnectionConfig config) {
        return true;
    }

    protected void saveConfig(Map<String, Object> qualifiers, ConnectionConfig config) {
        this.saveKeyedInteger(qualifiers, "port", config.getPort());
    }

    protected final void saveKeyedInteger(Map<String, Object> qualifiers, String key, int value) {
        if (qualifiers != null && !qualifiers.containsKey(key)) {
            qualifiers.put(key, value);
        }
    }

    public final void setPluginName(String pluginName) {
        this.m_pluginName = pluginName;
    }

    protected Socket wrapSocket(Socket socket, ConnectionConfig config) throws Exception {
        return socket;
    }
}

