/*
 * Decompiled with CFR 0.152.
 */
package simple.util.process;

import simple.util.MessageQueue;

final class Daemon
extends Thread {
    private MessageQueue slot = new MessageQueue();
    private volatile boolean alive = true;
    private MessageQueue ready;

    public Daemon(MessageQueue ready) {
        this.ready = ready;
        this.start();
    }

    public void process(Runnable target) throws InterruptedException {
        this.slot.enqueue(target);
    }

    private Runnable dequeue() throws InterruptedException {
        return (Runnable)this.slot.dequeue();
    }

    public void run() {
        while (this.alive) {
            this.execute();
        }
    }

    private void execute() {
        try {
            try {
                this.ready.enqueue(this);
                this.dequeue().run();
            }
            catch (Throwable throwable) {}
        }
        finally {
            Daemon.interrupted();
        }
    }

    public void kill() {
        this.alive = false;
    }
}

