/*
 * Decompiled with CFR 0.152.
 */
package simple.http.serve;

import simple.http.serve.Locator;
import simple.util.Resolver;
import simple.util.xml.Node;
import simple.util.xml.Traverser;

final class ContentResolver
extends Traverser {
    private Resolver list = new Resolver();
    private int size;

    public ContentResolver(Locator lookup) {
        this.init(lookup);
    }

    private void init(Locator lookup) {
        try {
            this.load(lookup);
        }
        catch (Exception e) {
            return;
        }
    }

    private void load(Locator lookup) throws Exception {
        try {
            this.load(lookup, "content.xml");
        }
        catch (Exception e) {
            this.load(lookup, "Content.xml");
        }
    }

    private void load(Locator lookup, String name) throws Exception {
        this.parse(lookup.getFile(name), "utf-8");
    }

    public String getContentType(String path) {
        if (this.size <= 0) {
            return null;
        }
        return this.list.resolve(path);
    }

    protected void start() {
        this.list.clear();
    }

    protected void process(Node node) {
        String name = node.getName();
        if (name.equals("resolve")) {
            this.resolve(node);
        }
    }

    private void resolve(Node node) {
        String match = node.getAttribute("match");
        String type = node.getAttribute("type");
        if (match != null) {
            this.list.insert(match, type);
        }
    }

    protected void finish() {
        this.size = this.list.size();
    }
}

