/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.LogUtils;

public class ProcessExec {
    PrintStream m_out = null;
    PrintStream m_err = null;

    public ProcessExec(PrintStream out, PrintStream err) {
        this.m_out = out;
        this.m_err = err;
    }

    public int exec(String[] cmd) throws IOException, InterruptedException {
        Process p = Runtime.getRuntime().exec(cmd);
        p.getOutputStream().close();
        PrintInputStream out = new PrintInputStream(p.getInputStream(), this.m_out);
        PrintInputStream err = new PrintInputStream(p.getErrorStream(), this.m_err);
        Thread t1 = new Thread((Runnable)out, this.getClass().getSimpleName() + "-stdout");
        Thread t2 = new Thread((Runnable)err, this.getClass().getSimpleName() + "-stderr");
        t1.start();
        t2.start();
        int exitVal = p.waitFor();
        t1.join();
        t2.join();
        return exitVal;
    }

    public class PrintInputStream
    implements Runnable {
        private InputStream m_inputStream;
        private PrintStream m_printStream;

        public PrintInputStream(InputStream inputStream, PrintStream printStream) {
            this.m_inputStream = inputStream;
            this.m_printStream = printStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            InputStreamReader isr = null;
            BufferedReader in = null;
            try {
                String line;
                isr = new InputStreamReader(this.m_inputStream);
                in = new BufferedReader(isr);
                while ((line = in.readLine()) != null) {
                    this.m_printStream.println(line);
                }
            }
            catch (Exception e) {
                try {
                    LogUtils.warnf((Object)this, (Throwable)e, (String)"an error occurred while reading the input stream", (Object[])new Object[0]);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly((Reader)isr);
                    IOUtils.closeQuietly((InputStream)this.m_inputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)in);
                IOUtils.closeQuietly((Reader)isr);
                IOUtils.closeQuietly((InputStream)this.m_inputStream);
            }
            IOUtils.closeQuietly((Reader)in);
            IOUtils.closeQuietly((Reader)isr);
            IOUtils.closeQuietly((InputStream)this.m_inputStream);
        }
    }
}

