/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DatabaseSchemaConfigFactory;
import org.opennms.netmgt.config.filter.Table;
import org.opennms.netmgt.dao.FilterDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.filter.FilterParseException;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcFilterDao
implements FilterDao,
InitializingBean {
    private DataSource m_dataSource;
    private DatabaseSchemaConfigFactory m_databaseSchemaConfigFactory;
    private NodeDao m_nodeDao;
    private static String sqlKeyWordRegex = "\\s+(?:AND|OR|(?:NOT )?(?:LIKE|IN)|IS (?:NOT )?DISTINCT FROM)\\s+|(?:\\s+IS (?:NOT )?NULL|::(?:TIMESTAMP|INET))(?!\\w)|(?<!\\w)(?:NOT\\s+|IPLIKE(?=\\())";

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    public void setDatabaseSchemaConfigFactory(DatabaseSchemaConfigFactory factory) {
        this.m_databaseSchemaConfigFactory = factory;
    }

    public DatabaseSchemaConfigFactory getDatabaseSchemaConfigFactory() {
        return this.m_databaseSchemaConfigFactory;
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_dataSource != null ? 1 : 0) != 0, (String)"property dataSource cannot be null");
        Assert.state((this.m_databaseSchemaConfigFactory != null ? 1 : 0) != 0, (String)"property databaseSchemaConfigFactory cannot be null");
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    @Override
    public void walkMatchingNodes(String rule, EntityVisitor visitor) {
        SortedMap<Integer, String> map;
        Assert.state((this.m_nodeDao != null ? 1 : 0) != 0, (String)"property nodeDao cannot be null");
        try {
            map = this.getNodeMap(rule);
        }
        catch (FilterParseException e) {
            throw new DataRetrievalFailureException("Could not parse rule '" + rule + "': " + e, (Throwable)e);
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug("got " + map.size() + " results");
        }
        for (Integer nodeId : map.keySet()) {
            OnmsNode node = (OnmsNode)this.getNodeDao().load(nodeId);
            visitor.visitNode(node);
        }
    }

    @Override
    public SortedMap<Integer, String> getNodeMap(String rule) throws FilterParseException {
        TreeMap<Integer, String> resultMap = new TreeMap<Integer, String>();
        if (this.log().isDebugEnabled()) {
            this.log().debug("Filter: rule: " + rule);
        }
        Connection conn = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            conn = this.getDataSource().getConnection();
            d.watch((Object)conn);
            String sqlString = this.getNodeMappingStatement(rule);
            if (this.log().isDebugEnabled()) {
                this.log().debug("Filter: SQL statement: " + sqlString);
            }
            Statement stmt = conn.createStatement();
            d.watch((Object)stmt);
            ResultSet rset = stmt.executeQuery(sqlString);
            d.watch((Object)rset);
            if (rset != null) {
                while (rset.next()) {
                    resultMap.put(new Integer(rset.getInt(1)), rset.getString(2));
                }
            }
        }
        catch (FilterParseException e) {
            this.log().info("Filter Parse Exception occurred getting node map: " + e, (Throwable)e);
            throw new FilterParseException("Filter Parse Exception occurred getting node map: " + e);
        }
        catch (SQLException e) {
            this.log().info("SQL Exception occurred getting node map: " + e, (Throwable)e);
            throw new FilterParseException("SQL Exception occurred getting node map: " + e);
        }
        catch (Exception e) {
            this.log().fatal("Exception getting database connection: " + e, (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        finally {
            d.cleanUp();
        }
        return resultMap;
    }

    @Override
    public Map<String, Set<String>> getIPServiceMap(String rule) throws FilterParseException {
        TreeMap<String, Set<String>> ipServices = new TreeMap<String, Set<String>>();
        if (this.log().isDebugEnabled()) {
            this.log().debug("Filter: rule: " + rule);
        }
        Connection conn = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            conn = this.getDataSource().getConnection();
            d.watch((Object)conn);
            String sqlString = this.getIPServiceMappingStatement(rule);
            if (this.log().isDebugEnabled()) {
                this.log().debug("Filter: SQL statement: " + sqlString);
            }
            Statement stmt = conn.createStatement();
            d.watch((Object)stmt);
            ResultSet rset = stmt.executeQuery(sqlString);
            d.watch((Object)rset);
            if (rset != null) {
                while (rset.next()) {
                    String ipaddr = rset.getString(1);
                    if (!ipServices.containsKey(ipaddr)) {
                        ipServices.put(ipaddr, new TreeSet());
                    }
                    ((Set)ipServices.get(ipaddr)).add(rset.getString(2));
                }
            }
        }
        catch (FilterParseException e) {
            this.log().info("Filter Parse Exception occurred getting IP Service List: " + e, (Throwable)e);
            throw new FilterParseException("Filter Parse Exception occurred getting IP Service List: " + e);
        }
        catch (SQLException e) {
            this.log().info("SQL Exception occurred getting IP Service List: " + e, (Throwable)e);
            throw new FilterParseException("SQL Exception occurred getting IP Service List: " + e);
        }
        catch (Exception e) {
            this.log().fatal("Exception getting database connection: " + e, (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        finally {
            d.cleanUp();
        }
        return ipServices;
    }

    @Override
    public List<String> getIPList(String rule) throws FilterParseException {
        ArrayList<String> resultList = new ArrayList<String>();
        if (this.log().isDebugEnabled()) {
            this.log().debug("Filter: rule: " + rule);
        }
        Connection conn = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            conn = this.getDataSource().getConnection();
            d.watch((Object)conn);
            String sqlString = this.getSQLStatement(rule);
            if (this.log().isDebugEnabled()) {
                this.log().debug("Filter: SQL statement: \n" + sqlString);
            }
            Statement stmt = conn.createStatement();
            d.watch((Object)stmt);
            ResultSet rset = stmt.executeQuery(sqlString);
            d.watch((Object)rset);
            if (rset != null) {
                while (rset.next()) {
                    resultList.add(rset.getString(1));
                }
            }
        }
        catch (FilterParseException e) {
            this.log().info("Filter Parse Exception occurred getting IP List: " + e, (Throwable)e);
            throw new FilterParseException("Filter Parse Exception occurred getting IP List: " + e);
        }
        catch (SQLException e) {
            this.log().info("SQL Exception occurred getting IP List: " + e, (Throwable)e);
            throw new FilterParseException("SQL Exception occurred getting IP List: " + e);
        }
        catch (Exception e) {
            this.log().fatal("Exception getting database connection: " + e, (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        finally {
            d.cleanUp();
        }
        return resultList;
    }

    @Override
    public boolean isValid(String addr, String rule) throws FilterParseException {
        if (rule.length() == 0) {
            return true;
        }
        return this.getIPList(rule).contains(addr);
    }

    @Override
    public boolean isRuleMatching(String rule) throws FilterParseException {
        boolean matches = false;
        if (this.log().isDebugEnabled()) {
            this.log().debug("Filter: rule: " + rule);
        }
        DBUtils d = new DBUtils(this.getClass());
        Connection conn = null;
        try {
            conn = this.getDataSource().getConnection();
            d.watch((Object)conn);
            String sqlString = this.getSQLStatement(rule) + " LIMIT 1";
            if (this.log().isDebugEnabled()) {
                this.log().debug("Filter: SQL statement: \n" + sqlString);
            }
            Statement stmt = conn.createStatement();
            d.watch((Object)stmt);
            ResultSet rset = stmt.executeQuery(sqlString);
            d.watch((Object)rset);
            matches = rset.next();
            if (this.log().isDebugEnabled()) {
                this.log().debug("isRuleMatching: rule \"" + rule + "\" " + (matches ? "matches" : "does not match") + " an entry in the database");
            }
        }
        catch (FilterParseException e) {
            this.log().info("Filter Parse Exception occurred testing rule \"" + rule + "\" for matching results: " + e, (Throwable)e);
            throw new FilterParseException("Filter Parse Exception occurred testing rule \"" + rule + "\" for matching results: " + e);
        }
        catch (SQLException e) {
            this.log().warn("SQL Exception occurred testing rule \"" + rule + "\" for matching results: " + e, (Throwable)e);
            throw new FilterParseException("SQL Exception occurred testing rule \"" + rule + "\" for matching results: " + e);
        }
        catch (Exception e) {
            this.log().fatal("Exception getting database connection: " + e, (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        finally {
            d.cleanUp();
        }
        return matches;
    }

    @Override
    public void validateRule(String rule) throws FilterParseException {
        this.isRuleMatching(rule);
    }

    private final ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    protected String getNodeMappingStatement(String rule) throws FilterParseException {
        ArrayList<Table> tables = new ArrayList<Table>();
        StringBuffer columns = new StringBuffer();
        columns.append(this.addColumn(tables, "nodeID"));
        columns.append(", " + this.addColumn(tables, "nodeLabel"));
        String where = this.parseRule(tables, rule);
        String from = this.m_databaseSchemaConfigFactory.constructJoinExprForTables(tables);
        return "SELECT DISTINCT " + columns.toString() + " " + from + " " + where;
    }

    protected String getIPServiceMappingStatement(String rule) throws FilterParseException {
        ArrayList<Table> tables = new ArrayList<Table>();
        StringBuffer columns = new StringBuffer();
        columns.append(this.addColumn(tables, "ipAddr"));
        columns.append(", " + this.addColumn(tables, "serviceName"));
        String where = this.parseRule(tables, rule);
        String from = this.m_databaseSchemaConfigFactory.constructJoinExprForTables(tables);
        return "SELECT " + columns.toString() + " " + from + " " + where;
    }

    protected String getInterfaceWithServiceStatement(String rule) throws FilterParseException {
        ArrayList<Table> tables = new ArrayList<Table>();
        StringBuffer columns = new StringBuffer();
        columns.append(this.addColumn(tables, "ipAddr"));
        columns.append(", " + this.addColumn(tables, "serviceName"));
        columns.append(", " + this.addColumn(tables, "nodeID"));
        String where = this.parseRule(tables, rule);
        String from = this.m_databaseSchemaConfigFactory.constructJoinExprForTables(tables);
        return "SELECT DISTINCT " + columns.toString() + " " + from + " " + where;
    }

    protected String getSQLStatement(String rule) throws FilterParseException {
        ArrayList<Table> tables = new ArrayList<Table>();
        StringBuffer columns = new StringBuffer();
        columns.append(this.addColumn(tables, "ipAddr"));
        String where = this.parseRule(tables, rule);
        String from = this.m_databaseSchemaConfigFactory.constructJoinExprForTables(tables);
        return "SELECT DISTINCT " + columns.toString() + " " + from + " " + where;
    }

    protected String getSQLStatement(String rule, long nodeId, String ipaddr, String service) throws FilterParseException {
        ArrayList<Table> tables = new ArrayList<Table>();
        StringBuffer columns = new StringBuffer();
        columns.append(this.addColumn(tables, "ipAddr"));
        StringBuffer where = new StringBuffer(this.parseRule(tables, rule));
        if (nodeId != 0L) {
            where.append(" AND " + this.addColumn(tables, "nodeID") + " = " + nodeId);
        }
        if (ipaddr != null && !ipaddr.equals("")) {
            where.append(" AND " + this.addColumn(tables, "ipAddr") + " = '" + ipaddr + "'");
        }
        if (service != null && !service.equals("")) {
            where.append(" AND " + this.addColumn(tables, "serviceName") + " = '" + service + "'");
        }
        String from = this.m_databaseSchemaConfigFactory.constructJoinExprForTables(tables);
        return "SELECT DISTINCT " + columns.toString() + " " + from + " " + where;
    }

    private String parseRule(List<Table> tables, String rule) throws FilterParseException {
        if (rule != null && rule.length() > 0) {
            String sqlRule = new String(rule);
            ArrayList<String> extractedStrings = new ArrayList<String>();
            Matcher regex = Pattern.compile("'(?:[^']|'')*'|\"(?:[^\"]|\"\")*\"").matcher(sqlRule);
            StringBuffer tempStringBuff = new StringBuffer();
            while (regex.find()) {
                String tempString = regex.group();
                if (tempString.charAt(0) == '\"') {
                    extractedStrings.add("'" + tempString.substring(1, tempString.length() - 1).replaceAll("\"\"", "\"").replaceAll("'", "''") + "'");
                } else {
                    extractedStrings.add(regex.group());
                }
                regex.appendReplacement(tempStringBuff, "###@" + (extractedStrings.size() - 1) + "@###");
            }
            int tempIndex = tempStringBuff.length();
            regex.appendTail(tempStringBuff);
            if (tempStringBuff.substring(tempIndex).indexOf(39) > -1) {
                this.log().error("Unmatched ' in filter rule '" + rule + "'");
                throw new FilterParseException("Unmatched ' in filter rule '" + rule + "'");
            }
            if (tempStringBuff.substring(tempIndex).indexOf(34) > -1) {
                this.log().error("Unmatched \" in filter rule '" + rule + "'");
                throw new FilterParseException("Unmatched \" in filter rule '" + rule + "'");
            }
            sqlRule = tempStringBuff.toString();
            sqlRule = sqlRule.replaceAll("\\s*(?:&|&&)\\s*", " AND ");
            sqlRule = sqlRule.replaceAll("\\s*(?:\\||\\|\\|)\\s*", " OR ");
            sqlRule = sqlRule.replaceAll("\\s*!(?!=)\\s*", " NOT ");
            sqlRule = sqlRule.replaceAll("==", "=");
            regex = Pattern.compile("(\\w+)\\s+IPLIKE\\s+([0-9.*,-]+|###@\\d+@###)", 66).matcher(sqlRule);
            tempStringBuff = new StringBuffer();
            while (regex.find()) {
                if (regex.group().charAt(0) == '#') {
                    regex.appendReplacement(tempStringBuff, "IPLIKE($1, $2)");
                    continue;
                }
                regex.appendReplacement(tempStringBuff, "IPLIKE($1, '$2')");
            }
            regex.appendTail(tempStringBuff);
            sqlRule = tempStringBuff.toString();
            regex = Pattern.compile(sqlKeyWordRegex, 66).matcher(sqlRule);
            tempStringBuff = new StringBuffer();
            while (regex.find()) {
                extractedStrings.add(regex.group().toUpperCase());
                regex.appendReplacement(tempStringBuff, "###@" + (extractedStrings.size() - 1) + "@###");
            }
            regex.appendTail(tempStringBuff);
            sqlRule = tempStringBuff.toString();
            regex = Pattern.compile("[a-zA-Z0-9_\\-]*[a-zA-Z][a-zA-Z0-9_\\-]*").matcher(sqlRule);
            tempStringBuff = new StringBuffer();
            while (regex.find()) {
                if (regex.group().startsWith("is")) {
                    regex.appendReplacement(tempStringBuff, this.addColumn(tables, "serviceName") + " = '" + regex.group().substring(2) + "'");
                    continue;
                }
                if (regex.group().startsWith("notis")) {
                    regex.appendReplacement(tempStringBuff, this.addColumn(tables, "ipAddr") + " NOT IN (SELECT ifServices.ipAddr FROM ifServices, service WHERE service.serviceName ='" + regex.group().substring(5) + "' AND service.serviceID = ifServices.serviceID)");
                    continue;
                }
                if (regex.group().startsWith("catinc")) {
                    regex.appendReplacement(tempStringBuff, this.addColumn(tables, "nodeID") + " IN (SELECT category_node.nodeID FROM category_node, categories WHERE categories.categoryID = category_node.categoryID AND categories.categoryName = '" + regex.group().substring(6) + "')");
                    continue;
                }
                regex.appendReplacement(tempStringBuff, this.addColumn(tables, regex.group()));
            }
            regex.appendTail(tempStringBuff);
            sqlRule = tempStringBuff.toString();
            regex = Pattern.compile("###@(\\d+)@###").matcher(sqlRule);
            tempStringBuff = new StringBuffer();
            while (regex.find()) {
                regex.appendReplacement(tempStringBuff, Matcher.quoteReplacement((String)extractedStrings.get(Integer.parseInt(regex.group(1)))));
            }
            regex.appendTail(tempStringBuff);
            sqlRule = tempStringBuff.toString();
            return "WHERE " + sqlRule;
        }
        return "";
    }

    private String addColumn(List<Table> tables, String column) throws FilterParseException {
        Table table = this.m_databaseSchemaConfigFactory.findTableByVisibleColumn(column);
        if (table == null) {
            this.log().error("Could not find the column '" + column + "' in filter rule");
            throw new FilterParseException("Could not find the column '" + column + "' in filter rule");
        }
        if (!tables.contains(table)) {
            tables.add(table);
        }
        return table.getName() + "." + column;
    }
}

