/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.AcknowledgmentDao;
import org.opennms.netmgt.model.Acknowledgeable;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.acknowledgments.AckService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAckService
implements AckService {
    private AcknowledgmentDao m_ackDao;

    public void processAcks(Collection<OnmsAcknowledgment> acks) {
        this.log().info("processAcks: Processing " + acks.size() + " acknowledgements...");
        for (OnmsAcknowledgment ack : acks) {
            try {
                this.processAck(ack);
            }
            catch (IllegalStateException e) {
                this.log().warn("processAcks: ", (Throwable)e);
            }
        }
    }

    public void processAck(OnmsAcknowledgment ack) throws IllegalStateException {
        this.log().info("processAck: Searching DB for acknowledgables for ack: " + ack);
        List<Acknowledgeable> ackables = this.m_ackDao.findAcknowledgables(ack);
        if (ackables == null || ackables.size() < 1) {
            this.log().debug("processAck: No acknowledgables found.");
            throw new IllegalStateException("No acknowlegables in the database for ack: " + ack);
        }
        this.log().debug("processAck: Found " + ackables.size() + ". Acknowledging...");
        Iterator<Acknowledgeable> it = ackables.iterator();
        while (it.hasNext()) {
            try {
                Acknowledgeable ackable = it.next();
                switch (ack.getAckAction()) {
                    case ACKNOWLEDGE: {
                        this.log().debug("processAck: Acknowledging ackable: " + ackable + "...");
                        ackable.acknowledge(ack.getAckUser());
                        this.log().debug("processAck: Acknowledged ackable: " + ackable);
                        break;
                    }
                    case UNACKNOWLEDGE: {
                        this.log().debug("processAck: Unacknowledging ackable: " + ackable + "...");
                        ackable.unacknowledge(ack.getAckUser());
                        this.log().debug("processAck: Unacknowledged ackable: " + ackable);
                        break;
                    }
                    case CLEAR: {
                        this.log().debug("processAck: Clearing ackable: " + ackable + "...");
                        ackable.clear(ack.getAckUser());
                        this.log().debug("processAck: Cleared ackable: " + ackable);
                        break;
                    }
                    case ESCALATE: {
                        this.log().debug("processAck: Escalating ackable: " + ackable + "...");
                        ackable.escalate(ack.getAckUser());
                        this.log().debug("processAck: Escalated ackable: " + ackable);
                        break;
                    }
                }
                this.m_ackDao.updateAckable(ackable);
                this.m_ackDao.save(ack);
                this.m_ackDao.flush();
            }
            catch (Throwable t) {
                this.log().error("processAck: exception while processing: " + ack + "; " + t, t);
            }
        }
        this.log().info("processAck: Found and processed acknowledgables for the acknowledgement: " + ack);
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance();
    }

    public void setAckDao(AcknowledgmentDao ackDao) {
        this.m_ackDao = ackDao;
    }

    public AcknowledgmentDao getAckDao() {
        return this.m_ackDao;
    }
}

