/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.io.IOException;
import java.net.InetAddress;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.SnmpEventInfo;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.config.snmp.SnmpConfig;
import org.opennms.netmgt.dao.SnmpConfigDao;
import org.opennms.netmgt.dao.castor.CastorExceptionTranslator;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpConfiguration;
import org.springframework.beans.factory.InitializingBean;

public class FactoryBasedSnmpConfigDao
implements SnmpConfigDao,
InitializingBean {
    private static final CastorExceptionTranslator TRANSLATOR = new CastorExceptionTranslator();

    private SnmpPeerFactory getSnmpPeerFactory() {
        return SnmpPeerFactory.getInstance();
    }

    public void afterPropertiesSet() throws Exception {
        SnmpPeerFactory.init();
    }

    public SnmpAgentConfig getAgentConfig(InetAddress agentAddress) {
        return this.getSnmpPeerFactory().getAgentConfig(agentAddress);
    }

    public SnmpConfiguration getDefaults() {
        SnmpConfig config = this.getSnmpConfig();
        SnmpConfiguration defaults = new SnmpConfiguration();
        if (config.getAuthPassphrase() != null) {
            defaults.setAuthPassPhrase(config.getAuthPassphrase());
        }
        if (config.getAuthProtocol() != null) {
            defaults.setAuthProtocol(config.getAuthProtocol());
        }
        if (config.hasMaxRepetitions()) {
            defaults.setMaxRepetitions(config.getMaxRepetitions());
        }
        if (config.hasMaxRequestSize()) {
            defaults.setMaxRequestSize(config.getMaxRequestSize());
        }
        if (config.hasMaxVarsPerPdu()) {
            defaults.setMaxVarsPerPdu(config.getMaxVarsPerPdu());
        }
        if (config.hasPort()) {
            defaults.setPort(config.getPort());
        }
        if (config.getPrivacyPassphrase() != null) {
            defaults.setPrivPassPhrase(config.getPrivacyPassphrase());
        }
        if (config.getPrivacyProtocol() != null) {
            defaults.setPrivProtocol(config.getPrivacyProtocol());
        }
        if (config.getReadCommunity() != null) {
            defaults.setReadCommunity(config.getReadCommunity());
        }
        if (config.hasRetry()) {
            defaults.setRetries(config.getRetry());
        }
        if (config.hasSecurityLevel()) {
            defaults.setSecurityLevel(config.getSecurityLevel());
        }
        if (config.getSecurityName() != null) {
            defaults.setSecurityName(config.getSecurityName());
        }
        if (config.hasTimeout()) {
            defaults.setTimeout(config.getTimeout());
        }
        if (config.getVersion() != null) {
            defaults.setVersionAsString(config.getVersion());
        }
        if (config.getWriteCommunity() != null) {
            defaults.setWriteCommunity(config.getWriteCommunity());
        }
        return defaults;
    }

    private boolean nullSafeEquals(String o1, String o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public void saveAsDefaults(SnmpConfiguration newDefaults) {
        SnmpConfig config = this.getSnmpConfig();
        SnmpConfiguration oldDefaults = this.getDefaults();
        if (!this.nullSafeEquals(oldDefaults.getAuthPassPhrase(), newDefaults.getAuthPassPhrase())) {
            config.setAuthPassphrase(newDefaults.getAuthPassPhrase());
        }
        if (!this.nullSafeEquals(oldDefaults.getAuthProtocol(), newDefaults.getAuthProtocol())) {
            config.setAuthProtocol(newDefaults.getAuthProtocol());
        }
        if (oldDefaults.getMaxRepetitions() != newDefaults.getMaxRepetitions()) {
            config.setMaxRepetitions(newDefaults.getMaxRepetitions());
        }
        if (oldDefaults.getMaxRequestSize() != newDefaults.getMaxRequestSize()) {
            config.setMaxRequestSize(newDefaults.getMaxRequestSize());
        }
        if (oldDefaults.getMaxVarsPerPdu() != newDefaults.getMaxVarsPerPdu()) {
            config.setMaxVarsPerPdu(newDefaults.getMaxVarsPerPdu());
        }
        if (oldDefaults.getPort() != newDefaults.getPort()) {
            config.setPort(newDefaults.getPort());
        }
        if (!this.nullSafeEquals(oldDefaults.getPrivPassPhrase(), newDefaults.getPrivPassPhrase())) {
            config.setPrivacyPassphrase(newDefaults.getPrivPassPhrase());
        }
        if (!this.nullSafeEquals(oldDefaults.getPrivProtocol(), newDefaults.getPrivProtocol())) {
            config.setPrivacyProtocol(newDefaults.getPrivProtocol());
        }
        if (!this.nullSafeEquals(oldDefaults.getReadCommunity(), newDefaults.getReadCommunity())) {
            config.setReadCommunity(newDefaults.getReadCommunity());
        }
        if (oldDefaults.getRetries() != newDefaults.getRetries()) {
            config.setRetry(newDefaults.getRetries());
        }
        if (oldDefaults.getSecurityLevel() != newDefaults.getSecurityLevel()) {
            config.setSecurityLevel(newDefaults.getSecurityLevel());
        }
        if (!this.nullSafeEquals(oldDefaults.getSecurityName(), newDefaults.getSecurityName())) {
            config.setSecurityName(newDefaults.getSecurityName());
        }
        if (oldDefaults.getTimeout() != newDefaults.getTimeout()) {
            config.setTimeout(newDefaults.getTimeout());
        }
        if (oldDefaults.getVersion() != newDefaults.getVersion()) {
            config.setVersion(newDefaults.getVersionAsString());
        }
        if (!this.nullSafeEquals(oldDefaults.getWriteCommunity(), newDefaults.getWriteCommunity())) {
            config.setWriteCommunity(newDefaults.getWriteCommunity());
        }
        this.saveCurrent();
    }

    public void saveOrUpdate(SnmpAgentConfig newConfig) {
        SnmpAgentConfig oldConfig = this.getAgentConfig(newConfig.getAddress());
        SnmpEventInfo eventInfo = new SnmpEventInfo();
        eventInfo.setFirstIPAddress(newConfig.getAddress());
        eventInfo.setLastIPAddress(newConfig.getAddress());
        boolean save = false;
        if (!this.nullSafeEquals(oldConfig.getReadCommunity(), newConfig.getReadCommunity())) {
            eventInfo.setCommunityString(newConfig.getReadCommunity());
            save = true;
        }
        if (oldConfig.getPort() != newConfig.getPort()) {
            eventInfo.setPort(newConfig.getPort());
            save = true;
        }
        if (oldConfig.getRetries() != newConfig.getRetries()) {
            eventInfo.setRetryCount(newConfig.getRetries());
            save = true;
        }
        if (oldConfig.getTimeout() != newConfig.getTimeout()) {
            eventInfo.setTimeout(newConfig.getTimeout());
            save = true;
        }
        if (oldConfig.getVersion() != newConfig.getVersion()) {
            eventInfo.setVersion(newConfig.getVersionAsString());
            save = true;
        }
        if (save) {
            this.getSnmpPeerFactory().define(eventInfo);
            this.saveCurrent();
        }
    }

    private SnmpConfig getSnmpConfig() {
        return SnmpPeerFactory.getSnmpConfig();
    }

    private void saveCurrent() {
        try {
            SnmpPeerFactory.saveCurrent();
        }
        catch (MarshalException e) {
            TRANSLATOR.translate("save current snmp configuraiton", e);
        }
        catch (ValidationException e) {
            TRANSLATOR.translate("save current snmp configuraiton", e);
        }
        catch (IOException e) {
            TRANSLATOR.translate("save current snmp configuraiton", e);
        }
    }
}

