/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.filter.Column;
import org.opennms.netmgt.config.filter.DatabaseSchema;
import org.opennms.netmgt.config.filter.Join;
import org.opennms.netmgt.config.filter.Table;
import org.opennms.netmgt.dao.castor.CastorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DatabaseSchemaConfigFactory {
    private static DatabaseSchemaConfigFactory m_singleton = null;
    private DatabaseSchema m_config;
    private Map<String, Join> m_primaryJoins = null;
    private static boolean m_loaded = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseSchemaConfigFactory(String configFile) throws IOException, MarshalException, ValidationException {
        FileInputStream cfgStream = null;
        try {
            cfgStream = new FileInputStream(configFile);
            this.m_config = CastorUtils.unmarshal(DatabaseSchema.class, cfgStream);
            this.finishConstruction();
        }
        finally {
            if (cfgStream != null) {
                IOUtils.closeQuietly((InputStream)cfgStream);
            }
        }
    }

    @Deprecated
    public DatabaseSchemaConfigFactory(Reader reader) throws IOException, MarshalException, ValidationException {
        this.m_config = CastorUtils.unmarshal(DatabaseSchema.class, reader);
        this.finishConstruction();
    }

    public DatabaseSchemaConfigFactory(InputStream is) throws MarshalException, ValidationException {
        this.m_config = CastorUtils.unmarshal(DatabaseSchema.class, is);
        this.finishConstruction();
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.DB_SCHEMA_FILE_NAME);
        m_singleton = new DatabaseSchemaConfigFactory(cfgFile.getPath());
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        DatabaseSchemaConfigFactory.init();
    }

    public static synchronized DatabaseSchemaConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(DatabaseSchemaConfigFactory instance) {
        m_singleton = instance;
        m_loaded = true;
    }

    public synchronized DatabaseSchema getDatabaseSchema() {
        return this.m_config;
    }

    public Table getPrimaryTable() {
        Enumeration<Table> e = this.getDatabaseSchema().enumerateTable();
        while (e.hasMoreElements()) {
            Table t = e.nextElement();
            if (t.getVisible() != null && !t.getVisible().equalsIgnoreCase("true") || t.getKey() == null || !t.getKey().equals("primary")) continue;
            return t;
        }
        return null;
    }

    private void finishConstruction() {
        HashSet<String> joinableSet = new HashSet<String>();
        HashMap<String, Join> primaryJoins = new HashMap<String, Join>();
        joinableSet.add(this.getPrimaryTable().getName());
        int joinableCount = 0;
        while (joinableCount < joinableSet.size()) {
            joinableCount = joinableSet.size();
            HashSet<String> newSet = new HashSet<String>(joinableSet);
            Enumeration<Table> e = this.getDatabaseSchema().enumerateTable();
            while (e.hasMoreElements()) {
                Table t = e.nextElement();
                if (joinableSet.contains(t.getName()) || t.getVisible() != null && !t.getVisible().equalsIgnoreCase("true")) continue;
                Enumeration<Join> ejoin = t.enumerateJoin();
                while (ejoin.hasMoreElements()) {
                    Join j = ejoin.nextElement();
                    if (!joinableSet.contains(j.getTable())) continue;
                    newSet.add(t.getName());
                    primaryJoins.put(t.getName(), j);
                }
            }
            joinableSet = newSet;
        }
        this.m_primaryJoins = Collections.synchronizedMap(primaryJoins);
    }

    public Table getTableByName(String name) {
        Enumeration<Table> e = this.getDatabaseSchema().enumerateTable();
        while (e.hasMoreElements()) {
            Table t = e.nextElement();
            if (t.getVisible() != null && !t.getVisible().equalsIgnoreCase("true") || t.getName() == null || !t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    public Table findTableByVisibleColumn(String colName) {
        Table table = null;
        Enumeration<Table> etbl = this.getDatabaseSchema().enumerateTable();
        block0: while (etbl.hasMoreElements()) {
            Table t = etbl.nextElement();
            Enumeration<Column> ecol = t.enumerateColumn();
            while (ecol.hasMoreElements()) {
                Column col = ecol.nextElement();
                if (col.getVisible() != null && !col.getVisible().equalsIgnoreCase("true") || !col.getName().equalsIgnoreCase(colName)) continue;
                table = t;
                break block0;
            }
        }
        return table;
    }

    public int getTableCount() {
        return this.getDatabaseSchema().getTableCount();
    }

    public List<String> getJoinTables(List<Table> tables) {
        ArrayList<String> joinedTables = new ArrayList<String>();
        for (int i = 0; i < tables.size(); ++i) {
            int insertPosition = joinedTables.size();
            String currentTable = tables.get(i).getName();
            while (currentTable != null && !joinedTables.contains(currentTable)) {
                joinedTables.add(insertPosition, currentTable);
                Join next = this.m_primaryJoins.get(currentTable);
                if (next != null) {
                    currentTable = next.getTable();
                    continue;
                }
                currentTable = null;
            }
        }
        return joinedTables;
    }

    public String constructJoinExprForTables(List<Table> tables) {
        StringBuffer joinExpr = new StringBuffer();
        List<String> joinTables = this.getJoinTables(tables);
        joinExpr.append(joinTables.get(0));
        for (int i = 1; i < joinTables.size(); ++i) {
            Join currentJoin = this.m_primaryJoins.get(joinTables.get(i));
            if (currentJoin.getType() != null && !currentJoin.getType().equalsIgnoreCase("inner")) {
                joinExpr.append(" " + currentJoin.getType().toUpperCase());
            }
            joinExpr.append(" JOIN " + joinTables.get(i) + " ON (");
            joinExpr.append(currentJoin.getTable() + "." + currentJoin.getTableColumn() + " = ");
            joinExpr.append(joinTables.get(i) + "." + currentJoin.getColumn() + ")");
        }
        if (joinExpr.length() > 0) {
            return "FROM " + joinExpr.toString();
        }
        return "";
    }
}

