/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.server.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.jradius.handler.chain.JRCommand;
import net.jradius.handler.chain.JRConfigParser;
import net.jradius.log.RadiusLog;
import net.jradius.log.RadiusLogger;
import net.jradius.realm.JRadiusRealmManager;
import net.jradius.realm.RealmFactory;
import net.jradius.server.config.DictionaryConfigurationItem;
import net.jradius.server.config.HandlerConfigurationItem;
import net.jradius.server.config.ListenerConfigurationItem;
import net.jradius.server.config.LogConfigurationItem;
import net.jradius.server.config.PacketHandlerConfigurationItem;
import net.jradius.server.config.XMLConfiguration;
import net.jradius.session.JRadiusSessionManager;
import net.jradius.session.SessionFactory;
import net.jradius.session.SessionKeyProvider;
import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.Command;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    private static XMLConfiguration xmlCfg;
    private static HierarchicalConfiguration.Node root;
    private static boolean debug;
    private static int timeoutSeconds;
    private static File configFile;
    private static Map<String, ListenerConfigurationItem> listeners;
    private static Map packetHandlers;
    private static Map eventHandlers;
    private static Map dictionaries;
    private static BeanFactory beanFactory;
    private static JRConfigParser parser;
    private static CatalogFactory factory;
    private static LogConfigurationItem logConfig;
    private static final String SESSION_MANAGER_KEY = "session-manager";
    private static final String REALM_MANAGER_KEY = "realm-manager";
    private static final String REQUESTER_KEY = "requester";
    private static final String KEY_PROVIDER_KEY = "key-provider";
    private static final String SESSION_FACTORY_KEY = "session-factory";
    private static final String REALM_FACTORY_KEY = "realm-factory";

    public static void initialize(File file) throws FileNotFoundException, ConfigurationException {
        configFile = file;
        Configuration.initialize(new FileInputStream(file), null);
    }

    public static void initialize(InputStream input, BeanFactory factory) throws FileNotFoundException, ConfigurationException {
        beanFactory = factory;
        xmlCfg = new XMLConfiguration(new InputStreamReader(input));
        root = xmlCfg.getRoot();
        RadiusLog.info("Configuring JRadius Server....");
        Configuration.setLogConfig();
        Configuration.setGeneralOptions();
        Configuration.setRealmManagerConfig();
        Configuration.setSessionManagerConfig();
        Configuration.setDictionaryConfigs();
        Configuration.setPacketHandlersConfigs();
        Configuration.setEventHandlersConfigs();
        Configuration.setListenerConfigs();
    }

    public static boolean isDebug() {
        return debug;
    }

    public static String getConfigFileDir() {
        if (configFile == null) {
            return ".";
        }
        String configFileDir = configFile.getParent();
        if (configFileDir == null) {
            return ".";
        }
        return configFileDir;
    }

    public static Collection getPacketHandlers() {
        return packetHandlers.values();
    }

    public static Collection getEventHandlers() {
        return eventHandlers.values();
    }

    public static PacketHandlerConfigurationItem packetHandlerConfigurationForName(String name) {
        return (PacketHandlerConfigurationItem)packetHandlers.get(name);
    }

    public static HandlerConfigurationItem eventHandlerConfigurationForName(String name) {
        return (HandlerConfigurationItem)eventHandlers.get(name);
    }

    public static JRCommand packetHandlerForName(String name) {
        return (JRCommand)Configuration.getCommand(name);
    }

    public static JRCommand eventHandlerForName(String name) {
        return (JRCommand)Configuration.getCommand(name);
    }

    public static Command getCommand(String commandID) throws IllegalArgumentException {
        int splitPos;
        String DELIMITER = ":";
        String commandName = commandID;
        String catalogName = null;
        Catalog catalog = null;
        if (commandID != null && (splitPos = commandID.indexOf(DELIMITER)) != -1) {
            catalogName = commandID.substring(0, splitPos);
            commandName = commandID.substring(splitPos + DELIMITER.length());
            if (commandName.indexOf(DELIMITER) != -1) {
                throw new IllegalArgumentException("commandID [" + commandID + "] has too many delimiters (reserved for future use)");
            }
        }
        if (catalogName != null) {
            catalog = factory.getCatalog(catalogName);
            if (catalog == null) {
                RadiusLog.warn("No catalog found for name: " + catalogName + ".");
                return null;
            }
        } else {
            catalog = factory.getCatalog();
            if (catalog == null) {
                RadiusLog.warn("No default catalog found.");
                return null;
            }
        }
        return catalog.getCommand(commandName);
    }

    public static Collection<ListenerConfigurationItem> getListenerConfigs() {
        return listeners.values();
    }

    public static ListenerConfigurationItem listenerConfigurationForName(String name) {
        return listeners.get(name);
    }

    public static Collection getDictionaryConfigs() {
        return dictionaries.values();
    }

    public static DictionaryConfigurationItem dictionaryConfigurationForName(String name) {
        return (DictionaryConfigurationItem)dictionaries.get(name);
    }

    public static int getTimeoutSeconds() {
        return timeoutSeconds;
    }

    private static void setGeneralOptions() {
        debug = xmlCfg.getConfigBoolean("debug");
        timeoutSeconds = xmlCfg.getConfigInt("timeout");
        List children = root.getChildren("chain-catalog");
        for (HierarchicalConfiguration.Node node : children) {
            xmlCfg.setRoot(node);
            String catalogURL = xmlCfg.getConfigString("name");
            if (catalogURL != null) {
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    RadiusLog.debug("Loading Chains URL: " + catalogURL);
                    parser.parse(classLoader.getResource(catalogURL));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            xmlCfg.setRoot(root);
        }
    }

    private static void setDictionaryConfigs() {
        List children = root.getChildren(DictionaryConfigurationItem.XML_KEY);
        for (HierarchicalConfiguration.Node node : children) {
            xmlCfg.setRoot(node);
            DictionaryConfigurationItem item = new DictionaryConfigurationItem(node, xmlCfg);
            dictionaries.put(item.getName(), item);
            xmlCfg.setRoot(root);
        }
    }

    private static void setLogConfig() {
        List children = root.getChildren(LogConfigurationItem.XML_KEY);
        for (HierarchicalConfiguration.Node node : children) {
            xmlCfg.setRoot(node);
            if (logConfig != null) {
                RadiusLog.warn("A RadiusLogger is already configured, skipping configuration");
                return;
            }
            logConfig = new LogConfigurationItem(node, xmlCfg);
            try {
                RadiusLogger logger = (RadiusLogger)Configuration.getBean(logConfig.getClassName());
                RadiusLog.setRadiusLogger(logger);
                RadiusLog.info("  Configuring RadiusLogger " + logConfig.getName() + ": " + logger.getClass().getName());
            }
            catch (Exception e) {
                RadiusLog.error(e.getMessage());
                logConfig = null;
            }
            xmlCfg.setRoot(root);
        }
    }

    private static void setPacketHandlersConfigs() {
        List list = root.getChildren("packet-handlers");
        for (HierarchicalConfiguration.Node node2 : list) {
            List children = node2.getChildren("packet-handler");
            for (HierarchicalConfiguration.Node node2 : children) {
                xmlCfg.setRoot(node2);
                PacketHandlerConfigurationItem item = new PacketHandlerConfigurationItem(node2, xmlCfg);
                packetHandlers.put(item.getName(), item);
                xmlCfg.setRoot(root);
            }
        }
    }

    private static void setEventHandlersConfigs() {
        List list = root.getChildren("event-handlers");
        for (HierarchicalConfiguration.Node node2 : list) {
            List children = node2.getChildren("event-handler");
            for (HierarchicalConfiguration.Node node2 : children) {
                xmlCfg.setRoot(node2);
                HandlerConfigurationItem item = new HandlerConfigurationItem(node2, xmlCfg);
                eventHandlers.put(item.getName(), item);
                xmlCfg.setRoot(root);
            }
        }
    }

    private static void setListenerConfigs() {
        List list = root.getChildren(ListenerConfigurationItem.XML_LIST_KEY);
        for (HierarchicalConfiguration.Node node2 : list) {
            List children = node2.getChildren(ListenerConfigurationItem.XML_KEY);
            for (HierarchicalConfiguration.Node node2 : children) {
                xmlCfg.setRoot(node2);
                ListenerConfigurationItem item = new ListenerConfigurationItem(node2, xmlCfg);
                listeners.put(item.getName(), item);
                xmlCfg.setRoot(root);
            }
        }
    }

    private static void setSessionManagerConfig() {
        List list = root.getChildren(SESSION_MANAGER_KEY);
        RadiusLog.info("  Initializing session manager");
        for (HierarchicalConfiguration.Node node : list) {
            xmlCfg.setRoot(node);
            String clazz = xmlCfg.getConfigString("class");
            String requester = xmlCfg.getConfigString(REQUESTER_KEY);
            String keyProvider = xmlCfg.getConfigString(KEY_PROVIDER_KEY);
            String sessionFactory = xmlCfg.getConfigString(SESSION_FACTORY_KEY);
            if (clazz != null) {
                try {
                    RadiusLog.info("    Session Manager (" + requester + "): " + clazz);
                    JRadiusSessionManager manager = (JRadiusSessionManager)Configuration.getBean(clazz);
                    JRadiusSessionManager.setManager(requester, manager);
                }
                catch (Exception e) {
                    RadiusLog.error(e.getMessage());
                }
            }
            if (keyProvider != null) {
                try {
                    RadiusLog.info("    Session Key Provider (" + requester + "): " + keyProvider);
                    SessionKeyProvider provider = (SessionKeyProvider)Configuration.getBean(keyProvider);
                    JRadiusSessionManager.getManager(requester).setSessionKeyProvider(requester, provider);
                }
                catch (Exception e) {
                    RadiusLog.error(e.getMessage());
                }
            }
            if (sessionFactory == null) continue;
            try {
                RadiusLog.info("    Session Factory (" + requester + "): " + sessionFactory);
                SessionFactory factory = (SessionFactory)Configuration.getBean(sessionFactory);
                factory.setConfig(xmlCfg, node);
                JRadiusSessionManager.getManager(requester).setSessionFactory(requester, factory);
            }
            catch (Exception e) {
                RadiusLog.error(e.getMessage());
            }
        }
    }

    public static Object getBean(String name) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        Object o = null;
        if (name.startsWith("bean:")) {
            String[] s = name.split(":");
            o = beanFactory.getBean(s[1]);
        } else {
            Class<?> clazz = Class.forName(name);
            o = clazz.newInstance();
            if (o instanceof InitializingBean) {
                try {
                    ((InitializingBean)o).afterPropertiesSet();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return o;
    }

    private static void setRealmManagerConfig() {
        List list = root.getChildren(REALM_MANAGER_KEY);
        RadiusLog.info("  Initializing realm manager");
        for (HierarchicalConfiguration.Node node : list) {
            xmlCfg.setRoot(node);
            String requester = xmlCfg.getConfigString(REQUESTER_KEY);
            String realmFactory = xmlCfg.getConfigString(REALM_FACTORY_KEY);
            if (realmFactory == null) continue;
            try {
                RadiusLog.info("    Realm Factory (" + requester + "): " + realmFactory);
                RealmFactory factory = (RealmFactory)Configuration.getBean(realmFactory);
                factory.setConfig(xmlCfg, node);
                JRadiusRealmManager.getManager().setRealmFactory(requester, factory);
            }
            catch (Exception e) {
                RadiusLog.error(e.getMessage());
            }
        }
    }

    static {
        listeners = new LinkedHashMap<String, ListenerConfigurationItem>();
        packetHandlers = new LinkedHashMap();
        eventHandlers = new LinkedHashMap();
        dictionaries = new LinkedHashMap();
        parser = new JRConfigParser();
        factory = CatalogFactory.getInstance();
    }
}

