/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.server;

import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import net.jradius.server.JRadiusThread;
import net.jradius.server.ListenerRequest;
import net.jradius.server.TCPListener;
import net.jradius.server.TCPListenerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeepAliveListener
extends JRadiusThread {
    private Socket socket;
    private TCPListener listener;
    private BlockingQueue<ListenerRequest> queue;

    public KeepAliveListener(Socket socket, TCPListener listener, BlockingQueue<ListenerRequest> queue) {
        this.socket = socket;
        this.listener = listener;
        this.queue = queue;
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.queue.put(new TCPListenerRequest(this.socket, this.listener, true));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.shutdown();
            this.listener.deadKeepAliveListener(this);
            return;
        }
    }

    public void shutdown() {
        if (this.socket == null) {
            return;
        }
        try {
            this.socket.shutdownInput();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.socket.shutdownOutput();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
    }
}

