/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.packet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jradius.log.RadiusLog;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;

public abstract class Format {
    public abstract void packAttribute(OutputStream var1, RadiusAttribute var2) throws IOException;

    public abstract int unpackAttributeHeader(InputStream var1, AttributeParseContext var2) throws IOException;

    public byte[] packAttributeList(AttributeList attrs) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (RadiusAttribute attr : attrs.getAttributeList()) {
            try {
                this.packAttribute(out, attr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }

    public void unpackAttributes(AttributeList attrs, byte[] bytes, int bOffset, int bLength) {
        ByteArrayInputStream attributeInput = new ByteArrayInputStream(bytes, bOffset, bLength);
        try {
            AttributeParseContext ctx;
            for (int pos = 0; pos < bLength; pos += ctx.attributeLength) {
                ctx = new AttributeParseContext();
                pos += this.unpackAttributeHeader(attributeInput, ctx);
                RadiusAttribute attribute = null;
                ctx.attributeValue = new byte[ctx.attributeLength - ctx.headerLength];
                ((InputStream)attributeInput).read(ctx.attributeValue, 0, ctx.attributeLength - ctx.headerLength);
                attribute = AttributeFactory.newAttribute(ctx.vendorNumber, ctx.attributeType, ctx.attributeValue, ctx.attributeOp);
                if (attribute == null) {
                    RadiusLog.warn("Unknown attribute with type = " + ctx.attributeType);
                } else {
                    attrs.add(attribute, false);
                }
                if (ctx.padding <= 0) continue;
                pos += ctx.padding;
                while (ctx.padding-- > 0) {
                    Format.readUnsignedByte(attributeInput);
                }
            }
            ((InputStream)attributeInput).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static long readUnsignedInt(InputStream in) throws IOException {
        return (long)Format.readUnsignedShort(in) << 16 | (long)Format.readUnsignedShort(in);
    }

    public static int readUnsignedShort(InputStream in) throws IOException {
        return Format.readUnsignedByte(in) << 8 | Format.readUnsignedByte(in);
    }

    public static int readUnsignedByte(InputStream in) throws IOException {
        return in.read() & 0xFF;
    }

    public static void writeUnsignedByte(OutputStream out, int b) throws IOException {
        out.write(b);
    }

    public static void writeUnsignedShort(OutputStream out, int s) throws IOException {
        out.write(s >> 8 & 0xFF);
        out.write(s & 0xFF);
    }

    public static void writeUnsignedInt(OutputStream out, long i) throws IOException {
        Format.writeUnsignedShort(out, (int)(i >> 16) & 0xFFFF);
        Format.writeUnsignedShort(out, (int)i & 0xFFFF);
    }

    protected class AttributeParseContext {
        public int attributeType = 0;
        public int attributeLength = 0;
        public int attributeOp = 11;
        public byte[] attributeValue = null;
        public int headerLength = 0;
        public int vendorNumber = -1;
        public int padding = 0;

        protected AttributeParseContext() {
        }
    }
}

