/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.log;

import net.jradius.exception.RadiusException;
import net.jradius.log.RadiusLogger;
import net.jradius.server.JRadiusRequest;
import net.jradius.session.JRadiusSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BaseRadiusLog
implements RadiusLogger {
    private Log log = LogFactory.getLog(this.getClass());

    public void debug(Object o) {
        this.log.debug(o);
    }

    public void info(Object o) {
        this.log.info(o);
    }

    public void warn(Object o) {
        this.log.warn(o);
    }

    public void error(Object o) {
        this.log.error(o);
    }

    public String problemReport(JRadiusRequest request, JRadiusSession session, RadiusException exception, String mesg) {
        StringBuffer sb = new StringBuffer();
        if (mesg != null) {
            sb.append("Problem: ").append(mesg).append("\n\n");
        }
        if (request != null) {
            sb.append("-----------------------------------------------------------\n").append("JRadiusRequest: ").append(request.toString()).append("\n").append("-----------------------------------------------------------\n");
            try {
                sb.append("RADIUS Request:\n").append("-----------------------------------------------------------\n").append(request.getRequestPacket().toString()).append("-----------------------------------------------------------\n").append("RADIUS Reply:\n").append("-----------------------------------------------------------\n").append(request.getReplyPacket().toString()).append("-----------------------------------------------------------\n").append("\n\n");
            }
            catch (RadiusException e) {
                // empty catch block
            }
        }
        if (session != null) {
            sb.append("-----------------------------------------------------------\n").append("RadiusSession:\n").append("-----------------------------------------------------------\n").append(session.toString()).append("\n\n");
        }
        if (exception != null) {
            sb.append("-----------------------------------------------------------\n").append("RadiusException:\n").append("-----------------------------------------------------------\n").append(exception.toString()).append("\n\n");
        }
        return sb.toString();
    }

    public void problem(JRadiusRequest request, JRadiusSession session, RadiusException exception, String mesg) {
        this.log.error((Object)this.problemReport(request, session, exception, mesg));
    }
}

