/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.handler;

import net.jradius.handler.EventHandlerBase;
import net.jradius.handler.chain.JRCommand;
import net.jradius.log.RadiusLog;
import net.jradius.server.JRadiusEvent;
import net.jradius.server.config.ConfigurationItem;
import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.Context;

public class EventHandlerChain
extends EventHandlerBase {
    private Catalog catalog;
    private String catalogName;
    private String onTrue;
    private String onFalse;

    public void setConfig(ConfigurationItem cfg) {
        super.setConfig(cfg);
        this.setCatalogName(cfg.getName());
    }

    public boolean handle(JRadiusEvent event) throws Exception {
        return this.execute(event.getTypeString(), event);
    }

    protected boolean execute(String commandName, JRadiusEvent event) throws Exception {
        Catalog catalog = this.getCatalog();
        if (catalog == null) {
            return true;
        }
        if ("true".equalsIgnoreCase(commandName)) {
            return true;
        }
        if ("false".equalsIgnoreCase(commandName)) {
            return false;
        }
        JRCommand command = (JRCommand)catalog.getCommand(commandName);
        return this.execute(command, event);
    }

    protected boolean execute(JRCommand command, JRadiusEvent event) throws Exception {
        if (command == null) {
            return false;
        }
        boolean result = command.execute((Context)event);
        String onTrue = this.getOnTrue();
        String onFalse = this.getOnFalse();
        if (result) {
            if (onTrue != null) {
                return this.execute(onTrue, event);
            }
        } else if (onFalse != null) {
            return this.execute(onFalse, event);
        }
        return result;
    }

    public void setOnFalse(String onFalse) {
        this.onFalse = onFalse;
    }

    public void setOnTrue(String onTrue) {
        this.onTrue = onTrue;
    }

    public String getOnFalse() {
        return this.onFalse;
    }

    public String getOnTrue() {
        return this.onTrue;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public Catalog getCatalog() {
        if (this.catalog == null) {
            CatalogFactory factory = CatalogFactory.getInstance();
            this.catalog = factory.getCatalog(this.getCatalogName());
            if (this.catalog == null) {
                RadiusLog.error("Unknown catalog named: " + this.getCatalogName());
            }
        }
        return this.catalog;
    }
}

