/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.ext.simple;

import com.noelios.restlet.http.HttpServerCall;
import com.noelios.restlet.util.KeepAliveInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.restlet.Server;
import org.restlet.data.Parameter;
import org.restlet.data.Response;
import org.restlet.util.Series;
import simple.http.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCall
extends HttpServerCall {
    private final Request request;
    private final simple.http.Response response;
    private volatile boolean requestHeadersAdded;

    SimpleCall(Server server, Request request, simple.http.Response response, boolean confidential) {
        super(server);
        this.request = request;
        this.response = response;
        this.setConfidential(confidential);
        this.requestHeadersAdded = false;
    }

    public void complete() {
        try {
            this.response.commit();
        }
        catch (IOException ex) {
            this.getLogger().log(Level.WARNING, "Unable to commit the response", ex);
        }
    }

    public String getClientAddress() {
        return this.request.getInetAddress().getHostAddress();
    }

    public int getClientPort() {
        Socket socket = this.getSocket();
        return socket != null ? socket.getPort() : -1;
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public ReadableByteChannel getRequestEntityChannel(long size) {
        return null;
    }

    public InputStream getRequestEntityStream(long size) {
        try {
            return new KeepAliveInputStream(this.request.getInputStream());
        }
        catch (IOException ex) {
            return null;
        }
    }

    public ReadableByteChannel getRequestHeadChannel() {
        return null;
    }

    public Series<Parameter> getRequestHeaders() {
        Series result = super.getRequestHeaders();
        if (!this.requestHeadersAdded) {
            int headerCount = this.request.headerCount();
            for (int i = 0; i < headerCount; ++i) {
                result.add((Object)new Parameter(this.request.getName(i), this.request.getValue(i)));
            }
            this.requestHeadersAdded = true;
        }
        return result;
    }

    public InputStream getRequestHeadStream() {
        return null;
    }

    public String getRequestUri() {
        return this.request.getURI();
    }

    public WritableByteChannel getResponseEntityChannel() {
        return null;
    }

    public OutputStream getResponseEntityStream() {
        try {
            return this.response.getOutputStream();
        }
        catch (IOException ex) {
            return null;
        }
    }

    private Socket getSocket() {
        return (Socket)this.request.getAttribute("org.restlet.ext.simple.socket");
    }

    public String getSslCipherSuite() {
        SSLSocket sslSocket;
        SSLSession sslSession;
        Socket socket = this.getSocket();
        if (socket instanceof SSLSocket && (sslSession = (sslSocket = (SSLSocket)socket).getSession()) != null) {
            return sslSession.getCipherSuite();
        }
        return null;
    }

    public List<Certificate> getSslClientCertificates() {
        SSLSocket sslSocket;
        SSLSession sslSession;
        Socket socket = this.getSocket();
        if (socket instanceof SSLSocket && (sslSession = (sslSocket = (SSLSocket)socket).getSession()) != null) {
            try {
                List<Certificate> clientCertificates = Arrays.asList(sslSession.getPeerCertificates());
                return clientCertificates;
            }
            catch (SSLPeerUnverifiedException e) {
                this.getLogger().log(Level.FINE, "Can't get the client certificates.", e);
            }
        }
        return null;
    }

    public String getVersion() {
        return this.request.getMajor() + "." + this.request.getMinor();
    }

    public void writeResponseHead(Response restletResponse) throws IOException {
        this.response.clear();
        for (Parameter header : this.getResponseHeaders()) {
            this.response.add(header.getName(), header.getValue());
        }
        this.response.setCode(this.getStatusCode());
        this.response.setText(this.getReasonPhrase());
        if (restletResponse.getEntity() == null) {
            this.response.setContentLength(0);
        }
    }
}

