/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.snmp;

import org.opennms.protocols.snmp.SnmpHandler;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduRequest;
import org.opennms.protocols.snmp.SnmpSession;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpVarBind;

public final class SnmpResponseHandler
implements SnmpHandler {
    boolean m_error = true;
    private SnmpPduPacket m_response = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snmpReceivedPdu(SnmpSession sess, int command, SnmpPduPacket pkt) {
        if (pkt.getCommand() == 162) {
            if (((SnmpPduRequest)pkt).getErrorStatus() == 0) {
                this.m_response = pkt;
            }
            SnmpResponseHandler snmpResponseHandler = this;
            synchronized (snmpResponseHandler) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snmpInternalError(SnmpSession sess, int err, SnmpSyntax obj) {
        SnmpResponseHandler snmpResponseHandler = this;
        synchronized (snmpResponseHandler) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snmpTimeoutError(SnmpSession sess, SnmpSyntax pkt) {
        SnmpResponseHandler snmpResponseHandler = this;
        synchronized (snmpResponseHandler) {
            this.notifyAll();
        }
    }

    public SnmpPduPacket getResponse() {
        return this.m_response;
    }

    public SnmpVarBind getFirstResponseVarBind() {
        return this.getResponseVarBind(0);
    }

    public SnmpSyntax getFirstResponseValue() {
        return this.getResponseValue(0);
    }

    public String getFirstResponseString() {
        return this.getResponseString(0);
    }

    public SnmpSyntax getResponseValue(int index) {
        return this.getResponseVarBind(index).getValue();
    }

    public String getResponseString(int index) {
        SnmpSyntax val = this.getResponseValue(index);
        return val == null ? null : val.toString();
    }

    public SnmpVarBind getResponseVarBind(int index) {
        return this.getResponse() == null ? null : this.getResponse().getVarBindAt(index);
    }

    public int getResponseVarBindCount() {
        return this.getResponse() == null ? 0 : this.getResponse().getLength();
    }
}

