/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.wmi;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.wmi.Definition;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WmiConfig
implements Serializable {
    private int _timeout;
    private boolean _has_timeout;
    private int _retry;
    private boolean _has_retry;
    private String _username;
    private String _domain;
    private String _password;
    private List<Definition> _definitionList = new ArrayList<Definition>();

    public void addDefinition(Definition vDefinition) throws IndexOutOfBoundsException {
        this._definitionList.add(vDefinition);
    }

    public void addDefinition(int index, Definition vDefinition) throws IndexOutOfBoundsException {
        this._definitionList.add(index, vDefinition);
    }

    public void deleteRetry() {
        this._has_retry = false;
    }

    public void deleteTimeout() {
        this._has_timeout = false;
    }

    public Enumeration<Definition> enumerateDefinition() {
        return Collections.enumeration(this._definitionList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof WmiConfig) {
            WmiConfig temp = (WmiConfig)obj;
            if (this._timeout != temp._timeout) {
                return false;
            }
            if (this._has_timeout != temp._has_timeout) {
                return false;
            }
            if (this._retry != temp._retry) {
                return false;
            }
            if (this._has_retry != temp._has_retry) {
                return false;
            }
            if (this._username != null) {
                if (temp._username == null) {
                    return false;
                }
                if (!this._username.equals(temp._username)) {
                    return false;
                }
            } else if (temp._username != null) {
                return false;
            }
            if (this._domain != null) {
                if (temp._domain == null) {
                    return false;
                }
                if (!this._domain.equals(temp._domain)) {
                    return false;
                }
            } else if (temp._domain != null) {
                return false;
            }
            if (this._password != null) {
                if (temp._password == null) {
                    return false;
                }
                if (!this._password.equals(temp._password)) {
                    return false;
                }
            } else if (temp._password != null) {
                return false;
            }
            if (this._definitionList != null) {
                if (temp._definitionList == null) {
                    return false;
                }
                if (!((Object)this._definitionList).equals(temp._definitionList)) {
                    return false;
                }
            } else if (temp._definitionList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public Definition getDefinition(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._definitionList.size()) {
            throw new IndexOutOfBoundsException("getDefinition: Index value '" + index + "' not in range [0.." + (this._definitionList.size() - 1) + "]");
        }
        return this._definitionList.get(index);
    }

    public Definition[] getDefinition() {
        Definition[] array = new Definition[]{};
        return this._definitionList.toArray(array);
    }

    public List<Definition> getDefinitionCollection() {
        return this._definitionList;
    }

    public int getDefinitionCount() {
        return this._definitionList.size();
    }

    public String getDomain() {
        return this._domain;
    }

    public String getPassword() {
        return this._password;
    }

    public int getRetry() {
        return this._retry;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public String getUsername() {
        return this._username;
    }

    public boolean hasRetry() {
        return this._has_retry;
    }

    public boolean hasTimeout() {
        return this._has_timeout;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this._timeout;
        result = 37 * result + this._retry;
        if (this._username != null) {
            result = 37 * result + this._username.hashCode();
        }
        if (this._domain != null) {
            result = 37 * result + this._domain.hashCode();
        }
        if (this._password != null) {
            result = 37 * result + this._password.hashCode();
        }
        if (this._definitionList != null) {
            result = 37 * result + ((Object)this._definitionList).hashCode();
        }
        return result;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Definition> iterateDefinition() {
        return this._definitionList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllDefinition() {
        this._definitionList.clear();
    }

    public boolean removeDefinition(Definition vDefinition) {
        boolean removed = this._definitionList.remove(vDefinition);
        return removed;
    }

    public Definition removeDefinitionAt(int index) {
        Definition obj = this._definitionList.remove(index);
        return obj;
    }

    public void setDefinition(int index, Definition vDefinition) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._definitionList.size()) {
            throw new IndexOutOfBoundsException("setDefinition: Index value '" + index + "' not in range [0.." + (this._definitionList.size() - 1) + "]");
        }
        this._definitionList.set(index, vDefinition);
    }

    public void setDefinition(Definition[] vDefinitionArray) {
        this._definitionList.clear();
        for (int i = 0; i < vDefinitionArray.length; ++i) {
            this._definitionList.add(vDefinitionArray[i]);
        }
    }

    public void setDefinition(List<Definition> vDefinitionList) {
        this._definitionList.clear();
        this._definitionList.addAll(vDefinitionList);
    }

    public void setDefinitionCollection(List<Definition> definitionList) {
        this._definitionList = definitionList;
    }

    public void setDomain(String domain) {
        this._domain = domain;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setRetry(int retry) {
        this._retry = retry;
        this._has_retry = true;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
        this._has_timeout = true;
    }

    public void setUsername(String username) {
        this._username = username;
    }

    public static WmiConfig unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (WmiConfig)Unmarshaller.unmarshal(WmiConfig.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

