/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.rancid.adapter;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.rancid.adapter.Mapping;
import org.opennms.netmgt.config.rancid.adapter.Policies;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RancidConfiguration
implements Serializable {
    private long _delay;
    private boolean _has_delay;
    private int _retries;
    private boolean _has_retries;
    private boolean _useCategories = false;
    private boolean _has_useCategories;
    private String _defaultType = "cisco";
    private Policies _policies;
    private List<Mapping> _mappingList;

    public RancidConfiguration() {
        this.setDefaultType("cisco");
        this._mappingList = new ArrayList<Mapping>();
    }

    public void addMapping(Mapping vMapping) throws IndexOutOfBoundsException {
        this._mappingList.add(vMapping);
    }

    public void addMapping(int index, Mapping vMapping) throws IndexOutOfBoundsException {
        this._mappingList.add(index, vMapping);
    }

    public void deleteDelay() {
        this._has_delay = false;
    }

    public void deleteRetries() {
        this._has_retries = false;
    }

    public void deleteUseCategories() {
        this._has_useCategories = false;
    }

    public Enumeration<Mapping> enumerateMapping() {
        return Collections.enumeration(this._mappingList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RancidConfiguration) {
            RancidConfiguration temp = (RancidConfiguration)obj;
            if (this._delay != temp._delay) {
                return false;
            }
            if (this._has_delay != temp._has_delay) {
                return false;
            }
            if (this._retries != temp._retries) {
                return false;
            }
            if (this._has_retries != temp._has_retries) {
                return false;
            }
            if (this._useCategories != temp._useCategories) {
                return false;
            }
            if (this._has_useCategories != temp._has_useCategories) {
                return false;
            }
            if (this._defaultType != null) {
                if (temp._defaultType == null) {
                    return false;
                }
                if (!this._defaultType.equals(temp._defaultType)) {
                    return false;
                }
            } else if (temp._defaultType != null) {
                return false;
            }
            if (this._policies != null) {
                if (temp._policies == null) {
                    return false;
                }
                if (!this._policies.equals(temp._policies)) {
                    return false;
                }
            } else if (temp._policies != null) {
                return false;
            }
            if (this._mappingList != null) {
                if (temp._mappingList == null) {
                    return false;
                }
                if (!((Object)this._mappingList).equals(temp._mappingList)) {
                    return false;
                }
            } else if (temp._mappingList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public String getDefaultType() {
        return this._defaultType;
    }

    public long getDelay() {
        return this._delay;
    }

    public Mapping getMapping(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._mappingList.size()) {
            throw new IndexOutOfBoundsException("getMapping: Index value '" + index + "' not in range [0.." + (this._mappingList.size() - 1) + "]");
        }
        return this._mappingList.get(index);
    }

    public Mapping[] getMapping() {
        Mapping[] array = new Mapping[]{};
        return this._mappingList.toArray(array);
    }

    public List<Mapping> getMappingCollection() {
        return this._mappingList;
    }

    public int getMappingCount() {
        return this._mappingList.size();
    }

    public Policies getPolicies() {
        return this._policies;
    }

    public int getRetries() {
        return this._retries;
    }

    public boolean getUseCategories() {
        return this._useCategories;
    }

    public boolean hasDelay() {
        return this._has_delay;
    }

    public boolean hasRetries() {
        return this._has_retries;
    }

    public boolean hasUseCategories() {
        return this._has_useCategories;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (int)(this._delay ^ this._delay >>> 32);
        result = 37 * result + this._retries;
        result = 37 * result + (this._useCategories ? 0 : 1);
        if (this._defaultType != null) {
            result = 37 * result + this._defaultType.hashCode();
        }
        if (this._policies != null) {
            result = 37 * result + this._policies.hashCode();
        }
        if (this._mappingList != null) {
            result = 37 * result + ((Object)this._mappingList).hashCode();
        }
        return result;
    }

    public boolean isUseCategories() {
        return this._useCategories;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public Iterator<Mapping> iterateMapping() {
        return this._mappingList.iterator();
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public void removeAllMapping() {
        this._mappingList.clear();
    }

    public boolean removeMapping(Mapping vMapping) {
        boolean removed = this._mappingList.remove(vMapping);
        return removed;
    }

    public Mapping removeMappingAt(int index) {
        Mapping obj = this._mappingList.remove(index);
        return obj;
    }

    public void setDefaultType(String defaultType) {
        this._defaultType = defaultType;
    }

    public void setDelay(long delay) {
        this._delay = delay;
        this._has_delay = true;
    }

    public void setMapping(int index, Mapping vMapping) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._mappingList.size()) {
            throw new IndexOutOfBoundsException("setMapping: Index value '" + index + "' not in range [0.." + (this._mappingList.size() - 1) + "]");
        }
        this._mappingList.set(index, vMapping);
    }

    public void setMapping(Mapping[] vMappingArray) {
        this._mappingList.clear();
        for (int i = 0; i < vMappingArray.length; ++i) {
            this._mappingList.add(vMappingArray[i]);
        }
    }

    public void setMapping(List<Mapping> vMappingList) {
        this._mappingList.clear();
        this._mappingList.addAll(vMappingList);
    }

    public void setMappingCollection(List<Mapping> mappingList) {
        this._mappingList = mappingList;
    }

    public void setPolicies(Policies policies) {
        this._policies = policies;
    }

    public void setRetries(int retries) {
        this._retries = retries;
        this._has_retries = true;
    }

    public void setUseCategories(boolean useCategories) {
        this._useCategories = useCategories;
        this._has_useCategories = true;
    }

    public static RancidConfiguration unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (RancidConfiguration)Unmarshaller.unmarshal(RancidConfiguration.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

