/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.util.Collection;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.ResourceVisitor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceTreeWalker
implements InitializingBean {
    private ResourceDao m_resourceDao;
    private ResourceVisitor m_visitor;

    public void walk() {
        this.walk(this.m_resourceDao.findTopLevelResources());
    }

    public void walk(Collection<OnmsResource> resources) {
        for (OnmsResource resource : resources) {
            this.m_visitor.visit(resource);
            this.walk(resource.getChildResources());
        }
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_resourceDao != null ? 1 : 0) != 0, (String)"property resourceDao must be set to a non-null value");
        Assert.state((this.m_visitor != null ? 1 : 0) != 0, (String)"property visitor must be set to a non-null value");
    }

    public ResourceDao getResourceDao() {
        return this.m_resourceDao;
    }

    public void setResourceDao(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    public ResourceVisitor getVisitor() {
        return this.m_visitor;
    }

    public void setVisitor(ResourceVisitor visitor) {
        this.m_visitor = visitor;
    }
}

