/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.core.FlowException;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionFactory;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionLock;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.springframework.webflow.executor.FlowExecutor;

public class FlowExecutorImpl
implements FlowExecutor {
    private static final Log logger;
    private FlowDefinitionLocator definitionLocator;
    private FlowExecutionFactory executionFactory;
    private FlowExecutionRepository executionRepository;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.webflow.executor.FlowExecutorImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
    }

    public FlowExecutorImpl(FlowDefinitionLocator definitionLocator, FlowExecutionFactory executionFactory, FlowExecutionRepository executionRepository) {
        Assert.notNull((Object)definitionLocator, (String)"The locator for accessing flow definitions is required");
        Assert.notNull((Object)executionFactory, (String)"The execution factory for creating new flow executions is required");
        Assert.notNull((Object)executionRepository, (String)"The repository for persisting flow executions is required");
        this.definitionLocator = definitionLocator;
        this.executionFactory = executionFactory;
        this.executionRepository = executionRepository;
    }

    public FlowDefinitionLocator getDefinitionLocator() {
        return this.definitionLocator;
    }

    public FlowExecutionFactory getExecutionFactory() {
        return this.executionFactory;
    }

    public FlowExecutionRepository getExecutionRepository() {
        return this.executionRepository;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FlowExecutionResult launchExecution(String flowId, MutableAttributeMap input, ExternalContext context) throws FlowException {
        FlowExecutionResult flowExecutionResult;
        block8: {
            FlowExecutionResult flowExecutionResult2;
            block7: {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Launching new execution of flow '" + flowId + "' with input " + input));
                    }
                    ExternalContextHolder.setExternalContext(context);
                    FlowDefinition flowDefinition = this.definitionLocator.getFlowDefinition(flowId);
                    FlowExecution flowExecution = this.executionFactory.createFlowExecution(flowDefinition);
                    flowExecution.start(input, context);
                    if (!flowExecution.hasEnded()) {
                        FlowExecutionLock lock = this.executionRepository.getLock(flowExecution.getKey());
                        lock.lock();
                        try {
                            this.executionRepository.putFlowExecution(flowExecution);
                        }
                        catch (Throwable throwable) {
                            Object var7_8 = null;
                            lock.unlock();
                            throw throwable;
                        }
                        {
                            Object var7_9 = null;
                            lock.unlock();
                            flowExecutionResult2 = this.createPausedResult(flowExecution);
                        }
                        Object var9_12 = null;
                        break block7;
                    }
                    flowExecutionResult = this.createEndResult(flowExecution);
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var9_14 = null;
                    ExternalContextHolder.setExternalContext(null);
                    throw throwable;
                }
            }
            ExternalContextHolder.setExternalContext(null);
            return flowExecutionResult2;
        }
        Object var9_13 = null;
        ExternalContextHolder.setExternalContext(null);
        return flowExecutionResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FlowExecutionResult resumeExecution(String flowExecutionKey, ExternalContext context) throws FlowException {
        try {
            FlowExecution flowExecution;
            FlowExecutionLock lock;
            block6: {
                FlowExecutionResult flowExecutionResult;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Resuming flow execution with key '" + flowExecutionKey));
                }
                ExternalContextHolder.setExternalContext(context);
                FlowExecutionKey key = this.executionRepository.parseFlowExecutionKey(flowExecutionKey);
                lock = this.executionRepository.getLock(key);
                lock.lock();
                try {
                    flowExecution = this.executionRepository.getFlowExecution(key);
                    flowExecution.resume(context);
                    if (flowExecution.hasEnded()) break block6;
                    this.executionRepository.putFlowExecution(flowExecution);
                    flowExecutionResult = this.createPausedResult(flowExecution);
                    Object var6_8 = null;
                    lock.unlock();
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    lock.unlock();
                    throw throwable;
                }
                Object var9_11 = null;
                ExternalContextHolder.setExternalContext(null);
                return flowExecutionResult;
            }
            this.executionRepository.removeFlowExecution(flowExecution);
            FlowExecutionResult flowExecutionResult = this.createEndResult(flowExecution);
            Object var6_9 = null;
            lock.unlock();
            Object var9_12 = null;
            ExternalContextHolder.setExternalContext(null);
            return flowExecutionResult;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            ExternalContextHolder.setExternalContext(null);
            throw throwable;
        }
    }

    private FlowExecutionResult createEndResult(FlowExecution flowExecution) {
        return FlowExecutionResult.createEndedResult(flowExecution.getDefinition().getId(), flowExecution.getOutcome());
    }

    private FlowExecutionResult createPausedResult(FlowExecution flowExecution) {
        return FlowExecutionResult.createPausedResult(flowExecution.getDefinition().getId(), flowExecution.getKey().toString());
    }
}

