/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.io.IOException;
import java.net.InetAddress;
import org.opennms.core.concurrent.BarrierSignaler;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.PduBuilder;
import org.opennms.netmgt.snmp.ResponseProcessor;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;

public abstract class SnmpWalker {
    private final String m_name;
    private final CollectionTracker m_tracker;
    private final BarrierSignaler m_signal;
    private InetAddress m_address;
    private WalkerPduBuilder m_pduBuilder;
    private ResponseProcessor m_responseProcessor;
    private final int m_maxVarsPerPdu;
    private boolean m_error = false;
    private String m_errorMessage = "";
    private Throwable m_errorThrowable = null;

    protected SnmpWalker(InetAddress address, String name, int maxVarsPerPdu, int maxRepititions, CollectionTracker tracker) {
        this.m_address = address;
        this.m_signal = new BarrierSignaler(1);
        this.m_name = name;
        this.m_tracker = tracker;
        this.m_tracker.setMaxRepetitions(maxRepititions);
        this.m_maxVarsPerPdu = maxVarsPerPdu;
    }

    protected abstract WalkerPduBuilder createPduBuilder(int var1);

    public void start() {
        this.m_pduBuilder = this.createPduBuilder(this.m_maxVarsPerPdu);
        try {
            this.buildAndSendNextPdu();
        }
        catch (Throwable e) {
            this.handleFatalError(e);
        }
    }

    public int getMaxVarsPerPdu() {
        return this.m_pduBuilder == null ? this.m_maxVarsPerPdu : this.m_pduBuilder.getMaxVarsPerPdu();
    }

    protected void buildAndSendNextPdu() throws IOException {
        if (this.m_tracker.isFinished()) {
            this.handleDone();
        } else {
            this.m_pduBuilder.reset();
            this.m_responseProcessor = this.m_tracker.buildNextPdu(this.m_pduBuilder);
            this.sendNextPdu(this.m_pduBuilder);
        }
    }

    protected abstract void sendNextPdu(WalkerPduBuilder var1) throws IOException;

    protected void handleDone() {
        this.finish();
    }

    public boolean failed() {
        return this.m_error;
    }

    public boolean timedOut() {
        return this.m_tracker.timedOut();
    }

    protected void handleAuthError(String msg) {
        this.m_tracker.setFailed(true);
        this.processError("Authentication error processing", msg, null);
    }

    protected void handleError(String msg) {
        this.m_tracker.setTimedOut(false);
        this.processError("Error retrieving", msg, null);
    }

    protected void handleError(String msg, Throwable t) {
        this.m_tracker.setTimedOut(false);
        this.processError("Error retrieving", msg, t);
    }

    protected void handleFatalError(Throwable e) {
        this.m_tracker.setFailed(true);
        this.processError("Unexpected error occurred processing", e.toString(), e);
    }

    protected void handleTimeout(String msg) {
        this.m_tracker.setTimedOut(true);
        this.processError("Timeout retrieving", msg, null);
    }

    private void processError(String reason, String cause, Throwable t) {
        String logMessage = reason + " " + this.getName() + " for " + this.m_address + ": " + cause;
        this.m_error = true;
        this.m_errorMessage = logMessage;
        this.m_errorThrowable = t;
        this.finish();
    }

    private void finish() {
        this.signal();
        try {
            this.close();
        }
        catch (IOException e) {
            SnmpWalker.log().error(this.getName() + ": Unexpected Error occured closing snmp session for: " + this.m_address, (Throwable)e);
        }
    }

    protected abstract void close() throws IOException;

    public String getName() {
        return this.m_name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signal() {
        SnmpWalker snmpWalker = this;
        synchronized (snmpWalker) {
            this.notifyAll();
        }
        if (this.m_signal != null) {
            this.m_signal.signalAll();
        }
    }

    protected static ThreadCategory log() {
        return ThreadCategory.getInstance(SnmpWalker.class);
    }

    public void waitFor() throws InterruptedException {
        this.m_signal.waitFor();
    }

    public void waitFor(long timeout) throws InterruptedException {
        this.m_signal.waitFor(timeout);
    }

    protected boolean processErrors(int errorStatus, int errorIndex) {
        return this.m_responseProcessor.processErrors(errorStatus, errorIndex);
    }

    protected void processResponse(SnmpObjId receivedOid, SnmpValue val) {
        this.m_responseProcessor.processResponse(receivedOid, val);
    }

    protected void setAddress(InetAddress address) {
        this.m_address = address;
    }

    protected InetAddress getAddress() {
        return this.m_address;
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    public Throwable getErrorThrowable() {
        return this.m_errorThrowable;
    }

    protected static abstract class WalkerPduBuilder
    extends PduBuilder {
        protected WalkerPduBuilder(int maxVarsPerPdu) {
            super(maxVarsPerPdu);
        }

        public abstract void reset();
    }
}

