/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.net.InetAddress;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.xml.bind.InetAddressXmlAdapter;
import org.opennms.netmgt.snmp.SnmpConfiguration;

@XmlRootElement(name="snmpAgentConfig")
public class SnmpAgentConfig
extends SnmpConfiguration {
    private InetAddress m_address;
    private InetAddress m_proxyFor;

    public SnmpAgentConfig() {
        this((InetAddress)null);
    }

    public SnmpAgentConfig(InetAddress agentAddress) {
        this(agentAddress, SnmpConfiguration.DEFAULTS);
    }

    public SnmpAgentConfig(InetAddress agentAddress, SnmpConfiguration defaults) {
        super(defaults);
        this.m_address = agentAddress;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("AgentConfig[");
        buff.append("Address: " + this.getAddress());
        buff.append(", ProxyForAddress: " + this.getProxyFor());
        buff.append(", Port: " + this.getPort());
        buff.append(", Community: " + this.getReadCommunity());
        buff.append(", Timeout: " + this.getTimeout());
        buff.append(", Retries: " + this.getRetries());
        buff.append(", MaxVarsPerPdu: " + this.getMaxVarsPerPdu());
        buff.append(", MaxRepetitions: " + this.getMaxRepetitions());
        buff.append(", Max request size: " + this.getMaxRequestSize());
        buff.append(", Version: " + SnmpAgentConfig.versionToString(this.getVersion()));
        if (this.getVersion() == 3) {
            buff.append(", Security level: " + this.getSecurityLevel());
            buff.append(", Security name: " + this.getSecurityName());
            buff.append(", auth-passphrase: " + this.getAuthPassPhrase());
            buff.append(", auth-protocol: " + this.getAuthProtocol());
            buff.append(", priv-passprhase: " + this.getPrivPassPhrase());
            buff.append(", priv-protocol: " + this.getPrivProtocol());
        }
        buff.append("]");
        return buff.toString();
    }

    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    public InetAddress getAddress() {
        return this.m_address;
    }

    public void setAddress(InetAddress address) {
        this.m_address = address;
    }

    public InetAddress getProxyFor() {
        return this.m_proxyFor;
    }

    public void setProxyFor(InetAddress address) {
        this.m_proxyFor = address;
    }
}

