/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.math.BigInteger;
import java.net.InetAddress;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;

public abstract class AbstractSnmpValue
implements SnmpValue {
    private int m_type;

    public AbstractSnmpValue(int type) {
        this.m_type = type;
    }

    public boolean isEndOfMib() {
        return false;
    }

    public String toDisplayString() {
        return this.toString();
    }

    public boolean isNumeric() {
        return false;
    }

    public int toInt() {
        return (int)this.toLong();
    }

    public InetAddress toInetAddress() {
        throw new IllegalArgumentException("Unable to convert " + this + " to an InetAddress");
    }

    public long toLong() {
        throw new IllegalArgumentException("Unable to convert " + this + " to a number");
    }

    public String toHexString() {
        throw new IllegalArgumentException("Unable to convert " + this + " to a hex string");
    }

    public int getType() {
        return this.m_type;
    }

    public BigInteger toBigInteger() {
        throw new IllegalArgumentException("Unable to convert " + this + " to a big integer");
    }

    public SnmpObjId toSnmpObjId() {
        throw new IllegalArgumentException("Unable to convert " + this + " to an SnmpObjId");
    }
}

