/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet;

import com.noelios.restlet.ClientHelper;
import com.noelios.restlet.ServerHelper;
import com.noelios.restlet.application.ApplicationHelper;
import com.noelios.restlet.authentication.AuthenticationHelper;
import com.noelios.restlet.authentication.AuthenticationUtils;
import com.noelios.restlet.authentication.HttpAmazonS3Helper;
import com.noelios.restlet.authentication.HttpBasicHelper;
import com.noelios.restlet.authentication.HttpDigestHelper;
import com.noelios.restlet.authentication.SmtpPlainHelper;
import com.noelios.restlet.component.ChildContext;
import com.noelios.restlet.component.ComponentContext;
import com.noelios.restlet.component.ComponentHelper;
import com.noelios.restlet.http.ContentType;
import com.noelios.restlet.http.CookieReader;
import com.noelios.restlet.http.CookieUtils;
import com.noelios.restlet.http.HttpClientCall;
import com.noelios.restlet.http.HttpClientConverter;
import com.noelios.restlet.http.HttpServerConverter;
import com.noelios.restlet.http.HttpUtils;
import com.noelios.restlet.http.StreamClientHelper;
import com.noelios.restlet.http.StreamServerHelper;
import com.noelios.restlet.local.ClapClientHelper;
import com.noelios.restlet.local.DirectoryResource;
import com.noelios.restlet.local.FileClientHelper;
import com.noelios.restlet.util.Base64;
import com.noelios.restlet.util.FormUtils;
import com.noelios.restlet.util.SecurityUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Directory;
import org.restlet.Guard;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.CharacterSet;
import org.restlet.data.ClientInfo;
import org.restlet.data.Cookie;
import org.restlet.data.CookieSetting;
import org.restlet.data.Dimension;
import org.restlet.data.Form;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Parameter;
import org.restlet.data.Preference;
import org.restlet.data.Product;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.Representation;
import org.restlet.resource.Resource;
import org.restlet.resource.Variant;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Engine
extends org.restlet.util.Engine {
    public static final String DESCRIPTOR_AUTHENTICATION = "com.noelios.restlet.AuthenticationHelper";
    public static final String DESCRIPTOR_PATH = "META-INF/services";
    public static final String DESCRIPTOR_AUTHENTICATION_PATH = "META-INF/services/com.noelios.restlet.AuthenticationHelper";
    public static final String DESCRIPTOR_CLIENT = "com.noelios.restlet.ClientHelper";
    public static final String DESCRIPTOR_CLIENT_PATH = "META-INF/services/com.noelios.restlet.ClientHelper";
    public static final String DESCRIPTOR_SERVER = "com.noelios.restlet.ServerHelper";
    public static final String DESCRIPTOR_SERVER_PATH = "META-INF/services/com.noelios.restlet.ServerHelper";
    public static final String VERSION = "1.1..1";
    public static final String VERSION_HEADER = "Noelios-Restlet-Engine/1.1..1";
    private volatile List<AuthenticationHelper> registeredAuthentications;
    private volatile List<ClientHelper> registeredClients = new CopyOnWriteArrayList<ClientHelper>();
    private volatile List<ServerHelper> registeredServers = new CopyOnWriteArrayList<ServerHelper>();

    public static Engine getInstance() {
        return (Engine)org.restlet.util.Engine.getInstance();
    }

    public static int getJavaMajorVersion() {
        int result;
        String javaVersion = System.getProperty("java.version");
        try {
            result = Integer.parseInt(javaVersion.substring(0, javaVersion.indexOf(".")));
        }
        catch (Exception e) {
            result = 0;
        }
        return result;
    }

    public static int getJavaMinorVersion() {
        int result;
        String javaVersion = System.getProperty("java.version");
        try {
            result = Integer.parseInt(javaVersion.split("\\.")[1]);
        }
        catch (Exception e) {
            result = 0;
        }
        return result;
    }

    public static int getJavaUpdateVersion() {
        int result;
        String javaVersion = System.getProperty("java.version");
        try {
            result = Integer.parseInt(javaVersion.substring(javaVersion.indexOf(95) + 1));
        }
        catch (Exception e) {
            result = 0;
        }
        return result;
    }

    public static Engine register() {
        return Engine.register(true);
    }

    public static Engine register(boolean discoverConnectors) {
        Engine result = new Engine(discoverConnectors);
        org.restlet.util.Engine.setInstance(result);
        return result;
    }

    public Engine() {
        this(true);
    }

    public Engine(boolean discoverHelpers) {
        this.registeredAuthentications = new CopyOnWriteArrayList<AuthenticationHelper>();
        if (discoverHelpers) {
            try {
                this.discoverConnectors();
                this.discoverAuthentications();
            }
            catch (IOException e) {
                Context.getCurrentLogger().log(Level.WARNING, "An error occured while discovering the engine helpers.", e);
            }
        }
    }

    @Override
    public int authenticate(Request request, Guard guard) {
        return AuthenticationUtils.authenticate(request, guard);
    }

    @Override
    public void challenge(Response response, boolean stale, Guard guard) {
        AuthenticationUtils.challenge(response, stale, guard);
    }

    @Override
    public void copyResponseHeaders(Iterable<Parameter> responseHeaders, Response response) {
        HttpClientConverter.copyResponseTransportHeaders(responseHeaders, response);
        HttpClientCall.copyResponseEntityHeaders(responseHeaders, response.getEntity());
    }

    @Override
    public void copyResponseHeaders(Response response, Series<Parameter> headers) {
        HttpServerConverter.addResponseHeaders(response, headers);
        HttpServerConverter.addEntityHeaders(response.getEntity(), headers);
    }

    @Override
    public Resource createDirectoryResource(Directory directory, Request request, Response response) throws IOException {
        return new DirectoryResource(directory, request, response);
    }

    public ApplicationHelper createHelper(Application application) {
        return new ApplicationHelper(application);
    }

    public ClientHelper createHelper(Client client, String helperClass) {
        ClientHelper result = null;
        if (client.getProtocols().size() > 0) {
            ClientHelper connector = null;
            Iterator<ClientHelper> iter = this.getRegisteredClients().iterator();
            while (result == null && iter.hasNext()) {
                connector = iter.next();
                if (!connector.getProtocols().containsAll(client.getProtocols()) || helperClass != null && !connector.getClass().getCanonicalName().equals(helperClass)) continue;
                try {
                    result = (ClientHelper)connector.getClass().getConstructor(Client.class).newInstance(client);
                }
                catch (Exception e) {
                    Context.getCurrentLogger().log(Level.SEVERE, "Exception while instantiation the client connector.", e);
                }
            }
            if (result == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("No available client connector supports the required protocols: ");
                for (Protocol p : client.getProtocols()) {
                    sb.append("'").append(p.getName()).append("' ");
                }
                sb.append(". Please add the JAR of a matching connector to your classpath.");
                Context.getCurrentLogger().log(Level.WARNING, sb.toString());
            }
        }
        return result;
    }

    public ComponentHelper createHelper(Component component) {
        return new ComponentHelper(component);
    }

    public ServerHelper createHelper(Server server, String helperClass) {
        ServerHelper result = null;
        if (server.getProtocols().size() > 0) {
            ServerHelper connector = null;
            Iterator<ServerHelper> iter = this.getRegisteredServers().iterator();
            while (result == null && iter.hasNext()) {
                connector = iter.next();
                if (helperClass != null && !connector.getClass().getCanonicalName().equals(helperClass) || !connector.getProtocols().containsAll(server.getProtocols())) continue;
                try {
                    result = (ServerHelper)connector.getClass().getConstructor(Server.class).newInstance(server);
                }
                catch (Exception e) {
                    Context.getCurrentLogger().log(Level.SEVERE, "Exception while instantiation the server connector.", e);
                }
            }
            if (result == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("No available server connector supports the required protocols: ");
                for (Protocol p : server.getProtocols()) {
                    sb.append("'").append(p.getName()).append("' ");
                }
                sb.append(". Please add the JAR of a matching connector to your classpath.");
                Context.getCurrentLogger().log(Level.WARNING, sb.toString());
            }
        }
        return result;
    }

    private void discoverAuthentications() throws IOException {
        ClassLoader classLoader = org.restlet.util.Engine.getClassLoader();
        this.registerHelpers(classLoader, classLoader.getResources(DESCRIPTOR_AUTHENTICATION_PATH), this.getRegisteredAuthentications(), null);
        this.registerDefaultAuthentications();
    }

    private void discoverClientConnectors(ClassLoader classLoader) throws IOException {
        this.registerHelpers(classLoader, classLoader.getResources(DESCRIPTOR_CLIENT_PATH), this.getRegisteredClients(), Client.class);
    }

    private void discoverConnectors() throws IOException {
        ClassLoader classLoader = org.restlet.util.Engine.getClassLoader();
        this.discoverClientConnectors(classLoader);
        this.discoverServerConnectors(classLoader);
        this.registerDefaultConnectors();
    }

    private void discoverServerConnectors(ClassLoader classLoader) throws IOException {
        this.registerHelpers(classLoader, classLoader.getResources(DESCRIPTOR_SERVER_PATH), this.getRegisteredServers(), Server.class);
    }

    public AuthenticationHelper findHelper(ChallengeScheme challengeScheme, boolean clientSide, boolean serverSide) {
        AuthenticationHelper result = null;
        List<AuthenticationHelper> helpers = this.getRegisteredAuthentications();
        for (int i = 0; result == null && i < helpers.size(); ++i) {
            AuthenticationHelper current = helpers.get(i);
            if (!current.getChallengeScheme().equals(challengeScheme) || (!clientSide || !current.isClientSide()) && clientSide || (!serverSide || !current.isServerSide()) && serverSide) continue;
            result = helpers.get(i);
        }
        return result;
    }

    @Override
    public void fireContextChanged(Restlet restlet, Context context) {
        if (context != null) {
            if (context instanceof ChildContext) {
                ChildContext childContext = (ChildContext)context;
                if (childContext.getChild() == null) {
                    childContext.setChild(restlet);
                }
            } else if (!(restlet instanceof Component) && context instanceof ComponentContext) {
                context.getLogger().severe("For security reasons, don't pass the component context to child Restlets anymore. Use the Context#createChildContext() method instead." + restlet.getClass());
            }
        }
    }

    @Override
    public String formatCookie(Cookie cookie) throws IllegalArgumentException {
        return CookieUtils.format(cookie);
    }

    @Override
    public String formatCookieSetting(CookieSetting cookieSetting) throws IllegalArgumentException {
        return CookieUtils.format(cookieSetting);
    }

    @Override
    public String formatDimensions(Collection<Dimension> dimensions) {
        return HttpUtils.createVaryHeader(dimensions);
    }

    @Override
    public String formatUserAgent(List<Product> products) throws IllegalArgumentException {
        StringBuilder builder = new StringBuilder();
        Iterator<Product> iterator = products.iterator();
        while (iterator.hasNext()) {
            Product product = iterator.next();
            if (product.getName() == null || product.getName().length() == 0) {
                throw new IllegalArgumentException("Product name cannot be null.");
            }
            builder.append(product.getName());
            if (product.getVersion() != null) {
                builder.append("/").append(product.getVersion());
            }
            if (product.getComment() != null) {
                builder.append(" (").append(product.getComment()).append(")");
            }
            if (!iterator.hasNext()) continue;
            builder.append(" ");
        }
        return builder.toString();
    }

    @Override
    public Variant getPreferredVariant(ClientInfo client, List<Variant> variants, Language defaultLanguage) {
        Language language;
        ArrayList<Preference<Language>> list;
        if (variants == null) {
            return null;
        }
        List<Language> variantLanguages = null;
        MediaType variantMediaType = null;
        boolean compatibleLanguage = false;
        boolean compatibleMediaType = false;
        Variant currentVariant2 = null;
        Variant bestVariant = null;
        Preference<Language> currentLanguagePref = null;
        Preference<Language> bestLanguagePref = null;
        Preference<MediaType> currentMediaTypePref = null;
        Preference<MediaType> bestMediaTypePref = null;
        float bestQuality = 0.0f;
        float bestLanguageScore = 0.0f;
        float bestMediaTypeScore = 0.0f;
        List<Preference<Language>> languagePrefs = client.getAcceptedLanguages();
        ArrayList<Preference<Language>> primaryLanguagePrefs = new ArrayList<Preference<Language>>();
        Preference<Language> defaultLanguagePref = defaultLanguage == null ? null : new Preference<Language>(defaultLanguage, 0.003f);
        Preference<Language> allLanguagesPref = new Preference<Language>(Language.ALL, 0.001f);
        if (languagePrefs.isEmpty()) {
            languagePrefs.add(new Preference<Language>(Language.ALL));
        } else {
            list = new ArrayList<Preference<Language>>();
            for (Preference<Language> preference : languagePrefs) {
                language = preference.getMetadata();
                if (language.getSubTags().isEmpty() || list.contains(language.getPrimaryTag())) continue;
                list.add((Preference<Language>)((Object)language.getPrimaryTag()));
                primaryLanguagePrefs.add(new Preference<Language>(new Language(language.getPrimaryTag()), 0.005f + 0.001f * preference.getQuality()));
            }
            if (defaultLanguage != null && !defaultLanguage.getSubTags().isEmpty() && !list.contains(defaultLanguage.getPrimaryTag())) {
                primaryLanguagePrefs.add(new Preference<Language>(new Language(defaultLanguage.getPrimaryTag()), 0.002f));
            }
        }
        languagePrefs.addAll(primaryLanguagePrefs);
        if (defaultLanguagePref != null) {
            languagePrefs.add(defaultLanguagePref);
            list = new ArrayList();
            for (Preference<Language> preference : languagePrefs) {
                language = preference.getMetadata();
                if (language.equals(Language.ALL)) continue;
                list.add(preference);
            }
            languagePrefs = list;
        }
        languagePrefs.add(allLanguagesPref);
        for (Variant currentVariant2 : variants) {
            variantLanguages = currentVariant2.getLanguages();
            variantMediaType = currentVariant2.getMediaType();
            for (Language variantLanguage : variantLanguages) {
                Iterator<Preference<Language>> iter2 = languagePrefs.iterator();
                while (variantLanguage != null && iter2.hasNext()) {
                    currentLanguagePref = iter2.next();
                    float currentScore = this.getScore(variantLanguage, currentLanguagePref.getMetadata());
                    boolean compatiblePref = currentScore != -1.0f;
                    if (!compatiblePref || bestLanguagePref != null && !(currentScore > bestLanguageScore)) continue;
                    bestLanguagePref = currentLanguagePref;
                    bestLanguageScore = currentScore;
                }
            }
            compatibleLanguage = variantLanguages.isEmpty() || bestLanguagePref != null;
            List<Preference<MediaType>> mediaTypePrefs = client.getAcceptedMediaTypes();
            if (mediaTypePrefs.size() == 0) {
                mediaTypePrefs.add(new Preference<MediaType>(MediaType.ALL));
            }
            Iterator<Preference<MediaType>> iter2 = mediaTypePrefs.iterator();
            while (compatibleLanguage && iter2.hasNext()) {
                currentMediaTypePref = iter2.next();
                float currentScore = this.getScore(variantMediaType, currentMediaTypePref.getMetadata());
                boolean compatiblePref = currentScore != -1.0f;
                if (!compatiblePref || bestMediaTypePref != null && !(currentScore > bestMediaTypeScore)) continue;
                bestMediaTypePref = currentMediaTypePref;
                bestMediaTypeScore = currentScore;
            }
            boolean bl = compatibleMediaType = variantMediaType == null || bestMediaTypePref != null;
            if (compatibleLanguage && compatibleMediaType) {
                float currentQuality = 0.0f;
                if (bestLanguagePref != null) {
                    currentQuality += bestLanguagePref.getQuality() * 10.0f;
                } else if (!variantLanguages.isEmpty()) {
                    currentQuality += 1.0f;
                }
                if (bestMediaTypePref != null) {
                    currentQuality += bestMediaTypePref.getQuality();
                }
                if (bestVariant == null) {
                    bestVariant = currentVariant2;
                    bestQuality = currentQuality;
                } else if (currentQuality > bestQuality) {
                    bestVariant = currentVariant2;
                    bestQuality = currentQuality;
                }
            }
            bestLanguagePref = null;
            bestLanguageScore = 0.0f;
            bestMediaTypePref = null;
            bestMediaTypeScore = 0.0f;
        }
        return bestVariant;
    }

    private String getProviderClassName(String line) {
        int index = line.indexOf(35);
        if (index != -1) {
            line = line.substring(0, index);
        }
        return line.trim();
    }

    public List<AuthenticationHelper> getRegisteredAuthentications() {
        return this.registeredAuthentications;
    }

    public List<ClientHelper> getRegisteredClients() {
        return this.registeredClients;
    }

    public List<ServerHelper> getRegisteredServers() {
        return this.registeredServers;
    }

    private float getScore(Language variantLanguage, Language preferenceLanguage) {
        float score = 0.0f;
        boolean compatibleLang = true;
        if (variantLanguage.getPrimaryTag().equalsIgnoreCase(preferenceLanguage.getPrimaryTag())) {
            score += 100.0f;
        } else if (!preferenceLanguage.getPrimaryTag().equals("*")) {
            compatibleLang = false;
        } else if (!preferenceLanguage.getSubTags().isEmpty()) {
            compatibleLang = false;
        } else {
            score += 1.0f;
        }
        if (compatibleLang) {
            if (preferenceLanguage.getSubTags().isEmpty() || variantLanguage.getSubTags().isEmpty()) {
                if (variantLanguage.getSubTags().isEmpty() && preferenceLanguage.getSubTags().isEmpty()) {
                    score += 10.0f;
                }
            } else {
                int maxSize = Math.min(preferenceLanguage.getSubTags().size(), variantLanguage.getSubTags().size());
                for (int i = 0; i < maxSize && compatibleLang; ++i) {
                    if (preferenceLanguage.getSubTags().get(i).equalsIgnoreCase(variantLanguage.getSubTags().get(i))) {
                        score = (float)((double)score + Math.pow(10.0, 1 - i));
                        continue;
                    }
                    compatibleLang = false;
                }
            }
        }
        return compatibleLang ? score : -1.0f;
    }

    private float getScore(MediaType variantMediaType, MediaType preferenceMediaType) {
        float score = 0.0f;
        boolean comptabibleMediaType = true;
        if (preferenceMediaType.getMainType().equals(variantMediaType.getMainType())) {
            score += 1000.0f;
        } else if (!preferenceMediaType.getMainType().equals("*")) {
            comptabibleMediaType = false;
        } else if (!preferenceMediaType.getSubType().equals("*")) {
            comptabibleMediaType = false;
        }
        if (comptabibleMediaType) {
            if (variantMediaType.getSubType().equals(preferenceMediaType.getSubType())) {
                score += 100.0f;
            } else if (!preferenceMediaType.getSubType().equals("*")) {
                comptabibleMediaType = false;
            }
            if (comptabibleMediaType && variantMediaType.getParameters() != null) {
                for (Parameter currentParam : variantMediaType.getParameters()) {
                    if (!this.isParameterFound(currentParam, preferenceMediaType)) continue;
                    score += 1.0f;
                }
            }
        }
        return comptabibleMediaType ? score : -1.0f;
    }

    private boolean isParameterFound(Parameter searchedParam, MediaType mediaRange) {
        boolean result = false;
        Iterator iter = mediaRange.getParameters().iterator();
        while (!result && iter.hasNext()) {
            result = searchedParam.equals(iter.next());
        }
        return result;
    }

    @Override
    public void parse(Form form, Representation webForm) {
        if (webForm != null) {
            FormUtils.parse(form, webForm);
        }
    }

    @Override
    public void parse(Form form, String queryString, CharacterSet characterSet, boolean decode, char separator) {
        if (queryString != null && !queryString.equals("")) {
            FormUtils.parse(form, queryString, characterSet, decode, separator);
        }
    }

    @Override
    public MediaType parseContentType(String contentType) throws IllegalArgumentException {
        try {
            return ContentType.parseContentType(contentType);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("The content type string \"" + contentType + "\" can not be parsed: " + e.getMessage(), e);
        }
    }

    @Override
    public Cookie parseCookie(String cookie) throws IllegalArgumentException {
        CookieReader cr = new CookieReader(cookie);
        try {
            return cr.readCookie();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read the cookie", e);
        }
    }

    @Override
    public CookieSetting parseCookieSetting(String cookieSetting) throws IllegalArgumentException {
        CookieReader cr = new CookieReader(cookieSetting);
        try {
            return cr.readCookieSetting();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read the cookie setting", e);
        }
    }

    @Override
    public List<Product> parseUserAgent(String userAgent) throws IllegalArgumentException {
        ArrayList<Product> result = new ArrayList<Product>();
        if (userAgent != null) {
            String token = null;
            String version = null;
            String comment = null;
            char[] tab = userAgent.trim().toCharArray();
            StringBuilder tokenBuilder = new StringBuilder();
            StringBuilder versionBuilder = null;
            StringBuilder commentBuilder = null;
            int index = 0;
            boolean insideToken = true;
            boolean insideVersion = false;
            boolean insideComment = false;
            for (index = 0; index < tab.length; ++index) {
                char c = tab[index];
                if (insideToken) {
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == ' ') {
                        tokenBuilder.append(c);
                        continue;
                    }
                    token = tokenBuilder.toString().trim();
                    insideToken = false;
                    if (c == '/') {
                        insideVersion = true;
                        versionBuilder = new StringBuilder();
                        continue;
                    }
                    if (c != '(') continue;
                    insideComment = true;
                    commentBuilder = new StringBuilder();
                    continue;
                }
                if (insideVersion) {
                    if (c != ' ') {
                        versionBuilder.append(c);
                        continue;
                    }
                    insideVersion = false;
                    version = versionBuilder.toString();
                    continue;
                }
                if (c == '(') {
                    insideComment = true;
                    commentBuilder = new StringBuilder();
                    continue;
                }
                if (insideComment) {
                    if (c == ')') {
                        insideComment = false;
                        comment = commentBuilder.toString();
                        result.add(new Product(token, version, comment));
                        insideToken = true;
                        tokenBuilder = new StringBuilder();
                        continue;
                    }
                    commentBuilder.append(c);
                    continue;
                }
                result.add(new Product(token, version, null));
                insideToken = true;
                tokenBuilder = new StringBuilder();
                tokenBuilder.append(c);
            }
            if (insideComment) {
                comment = commentBuilder.toString();
                result.add(new Product(token, version, comment));
            } else if (insideVersion) {
                version = versionBuilder.toString();
                result.add(new Product(token, version, null));
            } else if (insideToken && tokenBuilder.length() > 0) {
                token = tokenBuilder.toString();
                result.add(new Product(token, null, null));
            }
        }
        return result;
    }

    public void registerDefaultAuthentications() {
        this.getRegisteredAuthentications().add(new HttpBasicHelper());
        this.getRegisteredAuthentications().add(new HttpDigestHelper());
        this.getRegisteredAuthentications().add(new SmtpPlainHelper());
        this.getRegisteredAuthentications().add(new HttpAmazonS3Helper());
        HttpAmazonS3Helper helper = new HttpAmazonS3Helper();
        helper.setChallengeScheme(ChallengeScheme.HTTP_AWS);
        this.getRegisteredAuthentications().add(helper);
    }

    public void registerDefaultConnectors() {
        this.getRegisteredClients().add(new StreamClientHelper(null));
        this.getRegisteredClients().add(new ClapClientHelper(null));
        this.getRegisteredClients().add(new FileClientHelper(null));
        this.getRegisteredServers().add(new StreamServerHelper(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHelper(ClassLoader classLoader, URL configUrl, List helpers, Class constructorClass) {
        try {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(configUrl.openStream(), "utf-8"));
                String line = reader.readLine();
                while (line != null) {
                    String provider = this.getProviderClassName(line);
                    if (provider != null && !provider.equals("")) {
                        try {
                            Class<?> providerClass = classLoader.loadClass(provider);
                            if (constructorClass == null) {
                                helpers.add(providerClass.newInstance());
                            } else {
                                helpers.add(providerClass.getConstructor(constructorClass).newInstance(constructorClass.cast(null)));
                            }
                        }
                        catch (Exception e) {
                            Context.getCurrentLogger().log(Level.SEVERE, "Unable to register the helper " + provider, e);
                        }
                    }
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                Context.getCurrentLogger().log(Level.SEVERE, "Unable to read the provider descriptor: " + configUrl.toString());
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (IOException ioe) {
            Context.getCurrentLogger().log(Level.SEVERE, "Exception while detecting the helpers.", ioe);
        }
    }

    public void registerHelpers(ClassLoader classLoader, Enumeration<URL> configUrls, List helpers, Class constructorClass) {
        if (configUrls != null) {
            Enumeration<URL> configEnum = configUrls;
            while (configEnum.hasMoreElements()) {
                this.registerHelper(classLoader, configEnum.nextElement(), helpers, constructorClass);
            }
        }
    }

    public void registerUrlFactory() {
        URL.setURLStreamHandlerFactory(new URLStreamHandlerFactory(){

            public URLStreamHandler createURLStreamHandler(String protocol) {
                URLStreamHandler result = new URLStreamHandler(){

                    protected URLConnection openConnection(URL url) throws IOException {
                        return new URLConnection(url){

                            public void connect() throws IOException {
                            }

                            public InputStream getInputStream() throws IOException {
                                Response response;
                                InputStream result = null;
                                Context context = Context.getCurrent();
                                if (context != null && (response = context.getClientDispatcher().get(this.url.toString())).getStatus().isSuccess()) {
                                    result = response.getEntity().getStream();
                                }
                                return result;
                            }
                        };
                    }
                };
                return result;
            }
        });
    }

    @Override
    public String toBase64(byte[] target) {
        return Base64.encode(target, false);
    }

    @Override
    public String toMd5(String target) {
        return SecurityUtils.toMd5(target);
    }
}

