/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.trapd.EventConstants;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Value;

public class SyntaxToEvent {
    int m_typeId;
    String m_type;
    public static SyntaxToEvent[] m_syntaxToEvents;

    private SyntaxToEvent(int typeId, String type) {
        this.m_typeId = typeId;
        this.m_type = type;
    }

    private int getTypeId() {
        return this.m_typeId;
    }

    private String getType() {
        return this.m_type;
    }

    public static void setupSyntax() {
        m_syntaxToEvents = new SyntaxToEvent[]{new SyntaxToEvent(2, "Int32"), new SyntaxToEvent(5, "Null"), new SyntaxToEvent(6, "ObjectIdentifier"), new SyntaxToEvent(64, "IpAddress"), new SyntaxToEvent(67, "TimeTicks"), new SyntaxToEvent(65, "Counter32"), new SyntaxToEvent(66, "Gauge32"), new SyntaxToEvent(4, "OctetString"), new SyntaxToEvent(68, "Opaque"), new SyntaxToEvent(70, "Counter64"), new SyntaxToEvent(-1, "string")};
    }

    public static Parm processSyntax(String name, SnmpValue value) {
        Value val = new Value();
        boolean found = false;
        for (int i = 0; i < m_syntaxToEvents.length; ++i) {
            if (m_syntaxToEvents[i].getTypeId() != -1 && m_syntaxToEvents[i].getTypeId() != value.getType()) continue;
            val.setType(m_syntaxToEvents[i].getType());
            String encoding = null;
            encoding = value.isDisplayable() ? (name.matches(".*[Mm][Aa][Cc].*") ? "macAddress" : "text") : (value.getBytes().length == 6 ? "macAddress" : "base64");
            val.setEncoding(encoding);
            val.setContent(EventConstants.toString(encoding, value));
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalStateException("Internal error: fell through the bottom of the loop.  The syntax-to-events array might not have a catch-all for Object");
        }
        Parm parm = new Parm();
        parm.setParmName(name);
        parm.setValue(val);
        return parm;
    }

    static {
        SyntaxToEvent.setupSyntax();
    }
}

