/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.Map;
import net.sourceforge.jradiusclient.RadiusAttribute;
import net.sourceforge.jradiusclient.RadiusClient;
import net.sourceforge.jradiusclient.RadiusPacket;
import net.sourceforge.jradiusclient.exception.InvalidParameterException;
import net.sourceforge.jradiusclient.exception.RadiusException;
import net.sourceforge.jradiusclient.util.ChapUtil;
import org.apache.log4j.Level;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable
public final class RadiusAuthMonitor
extends IPv4Monitor {
    public static final int DEFAULT_TIMEOUT = 5000;
    public static final int DEFAULT_RETRY = 0;
    public static final int DEFAULT_AUTH_PORT = 1812;
    public static final int DEFAULT_ACCT_PORT = 1813;
    public static final String DEFAULT_AUTH_TYPE = "pap";
    public static final String DEFAULT_USER = "OpenNMS";
    public static final String DEFAULT_PASSWORD = "OpenNMS";
    public static final String DEFAULT_SECRET = "secret";
    public static final String DEFAULT_NASID = "opennms";

    public RadiusAuthMonitor() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ThreadCategory log = ThreadCategory.getInstance(((Object)((Object)this)).getClass());
        log.info(((Object)((Object)this)).getClass().getName() + ": RadiusAuthMonitor class loaded");
    }

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        ThreadCategory log = ThreadCategory.getInstance(((Object)((Object)this)).getClass());
        PollStatus status = PollStatus.unavailable();
        if (iface.getType() != 1) {
            log.error(((Object)((Object)this)).getClass().getName() + ": Unsupported interface type, only TYPE_IPV4 currently supported");
            throw new NetworkInterfaceNotSupportedException(((Object)((Object)this)).getClass().getName() + ": Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        if (parameters == null) {
            throw new NullPointerException();
        }
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 5000);
        int authport = ParameterMap.getKeyedInteger(parameters, (String)"authport", (int)1812);
        int acctport = ParameterMap.getKeyedInteger(parameters, (String)"acctport", (int)1813);
        String user = ParameterMap.getKeyedString(parameters, (String)"user", (String)"OpenNMS");
        String password = ParameterMap.getKeyedString(parameters, (String)"password", (String)"OpenNMS");
        String secret = ParameterMap.getKeyedString(parameters, (String)DEFAULT_SECRET, (String)DEFAULT_SECRET);
        String authType = ParameterMap.getKeyedString(parameters, (String)"authtype", (String)DEFAULT_AUTH_TYPE);
        String nasid = ParameterMap.getKeyedString(parameters, (String)"nasid", (String)DEFAULT_NASID);
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        RadiusClient rc = null;
        try {
            rc = new RadiusClient(ipv4Addr.getCanonicalHostName(), authport, acctport, secret, this.convertToSeconds(tracker.getConnectionTimeout()));
        }
        catch (RadiusException rex) {
            return this.logDown(Level.ERROR, "Radius Exception: " + rex.getMessage());
        }
        catch (InvalidParameterException ivpex) {
            return this.logDown(Level.ERROR, "Radius parameter exception: " + ivpex.getMessage());
        }
        tracker.reset();
        while (tracker.shouldRetry()) {
            try {
                tracker.startAttempt();
                ChapUtil chapUtil = new ChapUtil();
                RadiusPacket accessRequest = new RadiusPacket(1);
                RadiusAttribute nasIdAttribute = new RadiusAttribute(32, nasid.getBytes());
                RadiusAttribute userNameAttribute = new RadiusAttribute(1, user.getBytes());
                log.debug(((Object)((Object)this)).getClass().getName() + ": attempting Radius auth with authType: " + authType);
                accessRequest.setAttribute(userNameAttribute);
                accessRequest.setAttribute(nasIdAttribute);
                if (authType.equalsIgnoreCase("chap")) {
                    byte[] chapChallenge = chapUtil.getNextChapChallenge(16);
                    accessRequest.setAttribute(new RadiusAttribute(3, RadiusAuthMonitor.chapEncrypt(password, chapChallenge, chapUtil)));
                    accessRequest.setAttribute(new RadiusAttribute(60, chapChallenge));
                } else {
                    accessRequest.setAttribute(new RadiusAttribute(2, password.getBytes()));
                }
                RadiusPacket accessResponse = rc.authenticate(accessRequest, 0);
                if (accessResponse.getPacketType() == 2) {
                    double responseTime = tracker.elapsedTimeInMillis();
                    status = PollStatus.available((Double)responseTime);
                    if (!log.isDebugEnabled()) break;
                    log.debug(((Object)((Object)this)).getClass().getName() + ": Radius service is AVAILABLE on: " + ipv4Addr.getCanonicalHostName());
                    log.debug("poll: responseTime= " + responseTime + "ms");
                    break;
                }
            }
            catch (InvalidParameterException ivpex) {
                status = this.logDown(Level.ERROR, "Invalid Radius Parameter: " + (Object)((Object)ivpex));
            }
            catch (RadiusException radex) {
                status = this.logDown(Level.ERROR, "Radius Exception : " + (Object)((Object)radex));
            }
            tracker.nextAttempt();
        }
        return status;
    }

    private int convertToSeconds(int connectionTimeout) {
        return connectionTimeout / 1000 > 0 ? connectionTimeout / 1000 : 1;
    }

    private static byte[] chapEncrypt(String plainText, byte[] chapChallenge, ChapUtil chapUtil) {
        byte chapIdentifier = chapUtil.getNextChapIdentifier();
        byte[] chapPassword = new byte[17];
        chapPassword[0] = chapIdentifier;
        System.arraycopy(ChapUtil.chapEncrypt((byte)chapIdentifier, (byte[])plainText.getBytes(), (byte[])chapChallenge), 0, chapPassword, 1, 16);
        return chapPassword;
    }
}

