/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.netmgt.poller.nrpe.NrpeException;
import org.opennms.netmgt.poller.nrpe.NrpePacket;
import org.opennms.netmgt.utils.RelaxedX509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable
public final class NrpeMonitor
extends IPv4Monitor {
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final boolean DEFAULT_USE_SSL = true;
    private static final String[] ADH_CIPHER_SUITES = new String[]{"TLS_DH_anon_WITH_AES_128_CBC_SHA"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        String reason = null;
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        String command = ParameterMap.getKeyedString(parameters, (String)"command", (String)"_NRPE_CHECK");
        int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)5666);
        int padding = ParameterMap.getKeyedInteger(parameters, (String)"padding", (int)2);
        boolean useSsl = ParameterMap.getKeyedBoolean(parameters, (String)"usessl", (boolean)true);
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        if (this.log().isDebugEnabled()) {
            this.log().debug("poll: address = " + ipv4Addr.getHostAddress() + ", port = " + port + ", " + tracker);
        }
        int serviceStatus = 2;
        Double responseTime = null;
        tracker.reset();
        while (tracker.shouldRetry() && serviceStatus != 1) {
            Socket socket = null;
            try {
                tracker.startAttempt();
                socket = new Socket();
                socket.connect(new InetSocketAddress(ipv4Addr, port), tracker.getConnectionTimeout());
                socket.setSoTimeout(tracker.getSoTimeout());
                this.log().debug("NrpeMonitor: connected to host: " + ipv4Addr + " on port: " + port);
                reason = "Perhaps check the value of 'usessl' for this monitor against the NRPE daemon configuration";
                socket = this.wrapSocket(socket, useSsl);
                serviceStatus = 3;
                reason = "Connected successfully, but no response received";
                NrpePacket p = new NrpePacket(1, 0, command);
                byte[] b = p.buildPacket(padding);
                OutputStream o = socket.getOutputStream();
                o.write(b);
                NrpePacket response = NrpePacket.receivePacket(socket.getInputStream(), padding);
                responseTime = tracker.elapsedTimeInMillis();
                if (response.getResultCode() == 0) {
                    serviceStatus = 1;
                    reason = null;
                } else {
                    serviceStatus = 2;
                    reason = "NRPE command returned code " + response.getResultCode() + " and message: " + response.getBuffer();
                }
            }
            catch (NoRouteToHostException e) {
                reason = "No route to host exception for address " + ipv4Addr.getHostAddress();
                if (this.log().isEnabledFor(ThreadCategory.Level.WARN)) {
                    e.fillInStackTrace();
                    this.log().warn("poll: " + reason, (Throwable)e);
                }
            }
            catch (InterruptedIOException e) {
                reason = "did not connect to host within " + tracker;
                this.log().debug("NrpeMonitor: did not connect to host within " + tracker);
            }
            catch (ConnectException e) {
                reason = "Connection exception for address: " + ipv4Addr;
                if (this.log().isDebugEnabled()) {
                    e.fillInStackTrace();
                    this.log().debug("poll: " + reason, (Throwable)e);
                }
            }
            catch (NrpeException e) {
                reason = "NrpeException while polling address: " + ipv4Addr;
                if (this.log().isDebugEnabled()) {
                    e.fillInStackTrace();
                    this.log().debug("poll: " + reason, (Throwable)e);
                }
            }
            catch (IOException e) {
                reason = "IOException while polling address: " + ipv4Addr;
                if (this.log().isDebugEnabled()) {
                    e.fillInStackTrace();
                    this.log().debug("poll: " + reason, (Throwable)e);
                }
            }
            finally {
                block39: {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException e) {
                        if (!this.log().isDebugEnabled()) break block39;
                        e.fillInStackTrace();
                        this.log().debug("poll: Error closing socket.", (Throwable)e);
                    }
                }
            }
            tracker.nextAttempt();
        }
        if (reason == null) {
            return PollStatus.get((int)serviceStatus, responseTime);
        }
        return PollStatus.get((int)serviceStatus, reason);
    }

    protected Socket wrapSocket(Socket socket, boolean useSsl) throws IOException {
        if (!useSsl) {
            return socket;
        }
        SSLSocketFactory sslSF = null;
        TrustManager[] tm = new TrustManager[]{new RelaxedX509TrustManager()};
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, tm, new SecureRandom());
        }
        catch (NoSuchAlgorithmException e) {
            this.log().error("wrapSocket: Error wrapping socket, throwing runtime exception..." + e);
            throw new IllegalStateException("No such algorithm in SSLSocketFactory: " + e);
        }
        catch (KeyManagementException e) {
            this.log().error("wrapSocket: Error wrapping socket, throwing runtime exception..." + e);
            throw new IllegalStateException("Key management exception in SSLSocketFactory: " + e);
        }
        sslSF = sslContext.getSocketFactory();
        InetAddress inetAddress = socket.getInetAddress();
        String hostAddress = inetAddress.getHostAddress();
        int port = socket.getPort();
        Socket wrappedSocket = sslSF.createSocket(socket, hostAddress, port, true);
        SSLSocket sslSocket = (SSLSocket)wrappedSocket;
        sslSocket.setEnabledCipherSuites(ADH_CIPHER_SUITES);
        return wrappedSocket;
    }
}

