/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.opennms.core.utils.Base64;
import org.opennms.core.utils.IPLike;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable
public class HttpMonitor
extends IPv4Monitor {
    private static final int[] DEFAULT_PORTS = new int[]{80, 8080, 8888};
    private static final int DEFAULT_RETRY = 0;
    private static final String DEFAULT_URL = "/";
    private static final int DEFAULT_TIMEOUT = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_IPV4 currently supported");
        }
        int currentPort = -1;
        HttpMonitorClient httpClient = new HttpMonitorClient(iface, new TreeMap<String, Object>(parameters));
        for (int portIndex = 0; portIndex < this.determinePorts(httpClient.getParameters()).length && httpClient.getPollStatus() != 1; ++portIndex) {
            currentPort = this.determinePorts(httpClient.getParameters())[portIndex];
            httpClient.setTimeoutTracker(new TimeoutTracker(parameters, 0, 3000));
            this.log().debug("Port = " + currentPort + ", Address = " + iface.getAddress() + ", " + httpClient.getTimeoutTracker());
            httpClient.setCurrentPort(currentPort);
            httpClient.getTimeoutTracker().reset();
            while (httpClient.getTimeoutTracker().shouldRetry() && httpClient.getPollStatus() != 1) {
                try {
                    httpClient.getTimeoutTracker().startAttempt();
                    httpClient.connect();
                    this.log().debug("HttpMonitor: connected to host: " + iface.getAddress() + " on port: " + currentPort);
                    httpClient.sendHttpCommand();
                    if (!httpClient.isEndOfStream()) {
                        httpClient.setResponseTime(httpClient.getTimeoutTracker().elapsedTimeInMillis());
                        this.logResponseTimes(httpClient.getResponseTime(), httpClient.getCurrentLine());
                        if (httpClient.getPollStatus() == 1 && StringUtils.isNotBlank((String)httpClient.getResponseText())) {
                            httpClient.setPollStatus(2);
                            httpClient.readLinedMatching();
                            if (!httpClient.isEndOfStream()) {
                                httpClient.read();
                                if (!httpClient.isResponseTextFound()) {
                                    String message = "Matching text: [" + httpClient.getResponseText() + "] not found in body of HTTP response";
                                    this.log().debug(message);
                                    httpClient.setReason("Matching text: [" + httpClient.getResponseText() + "] not found in body of HTTP response");
                                }
                            }
                        }
                    }
                }
                catch (NoRouteToHostException e) {
                    this.log().warn("checkStatus: No route to host exception for address " + iface.getAddress(), (Throwable)e);
                    portIndex = this.determinePorts(httpClient.getParameters()).length;
                    httpClient.setReason("No route to host exception");
                }
                catch (SocketTimeoutException e) {
                    this.log().info("checkStatus: HTTP socket connection timed out with " + httpClient.getTimeoutTracker().toString());
                    httpClient.setReason("HTTP connection timeout");
                }
                catch (InterruptedIOException e) {
                    this.log().info(String.format("checkStatus: HTTP connection interrupted after %d bytes transferred with %s", e.bytesTransferred, httpClient.getTimeoutTracker().toString()), (Throwable)e);
                    httpClient.setReason(String.format("HTTP connection interrupted, %d bytes transferred", e.bytesTransferred));
                }
                catch (ConnectException e) {
                    this.log().warn("Connection exception for " + iface.getAddress() + ":" + this.determinePorts(httpClient.getParameters())[portIndex], (Throwable)e);
                    httpClient.setReason("HTTP connection exception on port: " + this.determinePorts(httpClient.getParameters())[portIndex] + ": " + e.getMessage());
                }
                catch (IOException e) {
                    e.fillInStackTrace();
                    this.log().warn("IOException while polling address " + iface.getAddress(), (Throwable)e);
                    httpClient.setReason("IOException while polling address: " + iface.getAddress() + ": " + e.getMessage());
                }
                finally {
                    httpClient.closeConnection();
                }
                httpClient.getTimeoutTracker().nextAttempt();
            }
        }
        return httpClient.determinePollStatusResponse();
    }

    private void logResponseTimes(Double responseTime, String line) {
        if (this.log().isDebugEnabled()) {
            this.log().debug("poll: response= " + line);
            this.log().debug("poll: responseTime= " + responseTime + "ms");
        }
    }

    protected Socket wrapSocket(Socket socket) throws IOException {
        return socket;
    }

    private boolean determineVerbosity(Map<String, Object> parameters) {
        String verbose = ParameterMap.getKeyedString(parameters, (String)"verbose", null);
        return verbose != null && verbose.equalsIgnoreCase("true");
    }

    private String determineUserAgent(Map<String, Object> parameters) {
        String agent = ParameterMap.getKeyedString(parameters, (String)"user-agent", null);
        if (this.isBlank(agent)) {
            return "OpenNMS HttpMonitor";
        }
        return agent;
    }

    String determineBasicAuthentication(Map<String, Object> parameters) {
        String credentials = ParameterMap.getKeyedString(parameters, (String)"basic-authentication", null);
        if (this.isNotBlank(credentials)) {
            credentials = new String(Base64.encodeBase64((byte[])credentials.getBytes()));
        } else {
            String user = ParameterMap.getKeyedString(parameters, (String)"user", null);
            if (this.isBlank(user)) {
                credentials = null;
            } else {
                String passwd = ParameterMap.getKeyedString(parameters, (String)"password", (String)"");
                credentials = new String(Base64.encodeBase64((byte[])(user + ":" + passwd).getBytes()));
            }
        }
        return credentials;
    }

    private String determineHttpHeader(Map<String, Object> parameters, String key) {
        return ParameterMap.getKeyedString(parameters, (String)key, null);
    }

    private String determineVirtualHost(NetworkInterface iface, Map<String, Object> parameters) {
        boolean res = ParameterMap.getKeyedBoolean(parameters, (String)"resolve-ip", (boolean)false);
        String virtualHost = ParameterMap.getKeyedString(parameters, (String)"host-name", null);
        if (this.isBlank(virtualHost)) {
            virtualHost = res ? ((InetAddress)iface.getAddress()).getCanonicalHostName() : ((InetAddress)iface.getAddress()).getHostAddress();
        }
        return virtualHost;
    }

    private String determineResponseText(Map<String, Object> parameters) {
        return ParameterMap.getKeyedString(parameters, (String)"response-text", null);
    }

    private String determineResponse(Map<String, Object> parameters) {
        return ParameterMap.getKeyedString(parameters, (String)"response", (String)this.determineDefaultResponseRange(this.determineUrl(parameters)));
    }

    private String determineUrl(Map<String, Object> parameters) {
        return ParameterMap.getKeyedString(parameters, (String)"url", (String)DEFAULT_URL);
    }

    protected int[] determinePorts(Map<String, Object> parameters) {
        return ParameterMap.getKeyedIntegerArray(parameters, (String)"port", (int[])DEFAULT_PORTS);
    }

    private String determineDefaultResponseRange(String url) {
        if (url == null || url.equals(DEFAULT_URL)) {
            return "100-499";
        }
        return "100-399";
    }

    private boolean isNotBlank(String str) {
        return StringUtils.isNotBlank((String)str);
    }

    private boolean isBlank(String str) {
        return StringUtils.isBlank((String)str);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class HttpMonitorClient {
        private double m_responseTime;
        NetworkInterface m_iface;
        Map<String, Object> m_parameters;
        String m_httpCmd;
        Socket m_httpSocket;
        private BufferedReader m_lineRdr;
        private String m_currentLine;
        private int m_serviceStatus;
        private String m_reason;
        private final StringBuffer m_html = new StringBuffer();
        private int m_serverResponseCode;
        private TimeoutTracker m_timeoutTracker;
        private int m_currentPort;
        private String m_responseText;
        private boolean m_responseTextFound = false;

        HttpMonitorClient(NetworkInterface iface, TreeMap<String, Object> parameters) {
            this.m_iface = iface;
            this.m_parameters = parameters;
            this.buildCommand();
            this.m_serviceStatus = 2;
            this.m_responseText = HttpMonitor.this.determineResponseText(parameters);
        }

        public void read() throws IOException {
            int nullCount = 0;
            while (nullCount < 2) {
                this.readLinedMatching();
                if (!this.isEndOfStream()) continue;
                ++nullCount;
            }
        }

        public int getCurrentPort() {
            return this.m_currentPort;
        }

        public Map<String, Object> getParameters() {
            return this.m_parameters;
        }

        public boolean isResponseTextFound() {
            return this.m_responseTextFound;
        }

        public void setResponseTextFound(boolean found) {
            this.m_responseTextFound = found;
        }

        public boolean checkCurrentLineMatchesResponseText() {
            this.m_responseTextFound = this.m_responseText.charAt(0) == '~' && !this.m_responseTextFound ? this.m_currentLine.matches(this.m_responseText.substring(1)) : this.m_currentLine.indexOf(this.m_responseText) != -1;
            return this.m_responseTextFound;
        }

        public String getResponseText() {
            return this.m_responseText;
        }

        public void setResponseText(String responseText) {
            this.m_responseText = responseText;
        }

        public void setCurrentPort(int currentPort) {
            this.m_currentPort = currentPort;
        }

        public TimeoutTracker getTimeoutTracker() {
            return this.m_timeoutTracker;
        }

        public void setTimeoutTracker(TimeoutTracker tracker) {
            this.m_timeoutTracker = tracker;
        }

        public Double getResponseTime() {
            return this.m_responseTime;
        }

        public void setResponseTime(double elapsedTimeInMillis) {
            this.m_responseTime = elapsedTimeInMillis;
        }

        private void connect() throws IOException, SocketException {
            this.m_httpSocket = new Socket();
            this.m_httpSocket.connect(new InetSocketAddress((InetAddress)this.m_iface.getAddress(), this.m_currentPort), this.m_timeoutTracker.getConnectionTimeout());
            this.m_serviceStatus = 3;
            this.m_httpSocket.setSoTimeout(this.m_timeoutTracker.getSoTimeout());
            this.m_httpSocket = HttpMonitor.this.wrapSocket(this.m_httpSocket);
        }

        public void closeConnection() {
            try {
                if (this.m_httpSocket != null) {
                    this.m_httpSocket.close();
                    this.m_httpSocket = null;
                }
            }
            catch (IOException e) {
                e.fillInStackTrace();
                HttpMonitor.this.log().warn("Error closing socket connection", (Throwable)e);
            }
        }

        public int getPollStatus() {
            return this.m_serviceStatus;
        }

        public void setPollStatus(int serviceStatus) {
            this.m_serviceStatus = serviceStatus;
        }

        public String getCurrentLine() {
            return this.m_currentLine;
        }

        public int getServerResponse() {
            return this.m_serverResponseCode;
        }

        private void determineServerInitialResponse() {
            int serverResponseValue = -1;
            if (this.m_currentLine != null && this.m_currentLine.startsWith("HTTP/")) {
                serverResponseValue = this.parseHttpResponse();
                if (IPLike.matchNumericListOrRange((String)String.valueOf(serverResponseValue), (String)HttpMonitor.this.determineResponse(this.m_parameters))) {
                    HttpMonitor.this.log().debug("determineServerResponse: valid server response: " + serverResponseValue + " found.");
                    this.m_serviceStatus = 1;
                } else {
                    this.m_serviceStatus = 2;
                    StringBuffer sb = new StringBuffer();
                    sb.append("HTTP response value: ");
                    sb.append(serverResponseValue);
                    sb.append(". Expecting: ");
                    sb.append(HttpMonitor.this.determineResponse(this.m_parameters));
                    sb.append(".");
                    this.m_reason = sb.toString();
                }
            }
            this.m_serverResponseCode = serverResponseValue;
        }

        private int parseHttpResponse() {
            StringTokenizer t = new StringTokenizer(this.m_currentLine);
            t.nextToken();
            int serverResponse = -1;
            try {
                serverResponse = Integer.parseInt(t.nextToken());
            }
            catch (NumberFormatException nfE) {
                HttpMonitor.this.log().info("Error converting response code from host = " + this.m_iface.getAddress() + ", response = " + this.m_currentLine);
            }
            return serverResponse;
        }

        public boolean isEndOfStream() {
            boolean eos = false;
            if (this.m_currentLine == null) {
                eos = true;
            }
            return eos;
        }

        public String readLinedMatching() throws IOException {
            this.m_currentLine = this.m_lineRdr.readLine();
            if (HttpMonitor.this.determineVerbosity(this.m_parameters)) {
                HttpMonitor.this.log().debug("\t<<: " + this.m_currentLine);
            }
            this.m_html.append(this.m_currentLine);
            if (this.m_responseText != null && this.m_currentLine != null && !this.m_responseTextFound && this.checkCurrentLineMatchesResponseText()) {
                HttpMonitor.this.log().debug("response-text: " + this.m_responseText + ": found.");
                this.m_serviceStatus = 1;
            }
            return this.m_currentLine;
        }

        public void sendHttpCommand() throws IOException {
            if (HttpMonitor.this.determineVerbosity(this.m_parameters)) {
                HttpMonitor.this.log().debug("Sending HTTP command: " + this.m_httpCmd);
            }
            this.m_httpSocket.getOutputStream().write(this.m_httpCmd.getBytes());
            this.m_lineRdr = new BufferedReader(new InputStreamReader(this.m_httpSocket.getInputStream()));
            this.readLinedMatching();
            if (HttpMonitor.this.determineVerbosity(this.m_parameters)) {
                HttpMonitor.this.log().debug("Server response: " + this.m_currentLine);
            }
            this.determineServerInitialResponse();
        }

        private void buildCommand() {
            StringBuilder sb = new StringBuilder();
            sb.append("GET ").append(HttpMonitor.this.determineUrl(this.m_parameters)).append(" HTTP/1.1\r\n");
            sb.append("Connection: CLOSE \r\n");
            sb.append("Host: ").append(HttpMonitor.this.determineVirtualHost(this.m_iface, this.m_parameters)).append("\r\n");
            sb.append("User-Agent: ").append(HttpMonitor.this.determineUserAgent(this.m_parameters)).append("\r\n");
            if (HttpMonitor.this.determineBasicAuthentication(this.m_parameters) != null) {
                sb.append("Authorization: Basic ").append(HttpMonitor.this.determineBasicAuthentication(this.m_parameters)).append("\r\n");
            }
            for (String string : this.m_parameters.keySet()) {
                String parmKey = string;
                if (!parmKey.matches("header[0-9]+$")) continue;
                sb.append(HttpMonitor.this.determineHttpHeader(this.m_parameters, parmKey)).append("\r\n");
            }
            sb.append("\r\n");
            String cmd = sb.toString();
            HttpMonitor.this.log().debug("checkStatus: cmd:\n" + cmd);
            this.m_httpCmd = cmd;
        }

        public void setReason(String reason) {
            this.m_reason = reason;
        }

        public String getReason() {
            return this.m_reason;
        }

        public Socket getHttpSocket() {
            return this.m_httpSocket;
        }

        public void setHttpSocket(Socket httpSocket) {
            this.m_httpSocket = httpSocket;
        }

        protected PollStatus determinePollStatusResponse() {
            if (this.getPollStatus() == 2) {
                StringBuffer testedPorts = new StringBuffer();
                for (int i = 0; i < HttpMonitor.this.determinePorts(this.getParameters()).length; ++i) {
                    if (i == 0) {
                        testedPorts.append(HttpMonitor.this.determinePorts(this.getParameters())[0]);
                        continue;
                    }
                    testedPorts.append(',').append(HttpMonitor.this.determinePorts(this.getParameters())[i]);
                }
                this.getParameters().put("qualifier", testedPorts.toString());
                String reason = this.getReason();
                reason = reason + "/Ports: " + testedPorts.toString();
                this.setReason(reason);
                HttpMonitor.this.log().debug("checkStatus: Reason: \"" + this.getReason() + "\"");
                return PollStatus.unavailable((String)this.getReason());
            }
            if (this.getPollStatus() == 1) {
                this.getParameters().put("qualifier", Integer.toString(this.getCurrentPort()));
                return PollStatus.available((Double)this.getResponseTime());
            }
            return PollStatus.get((int)this.getPollStatus(), (String)this.getReason());
        }
    }
}

