/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.capsd.EventUtils;
import org.opennms.netmgt.capsd.InsufficientInformationException;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.dao.DemandPollDao;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.poller.Poller;
import org.opennms.netmgt.poller.pollables.PollableInterface;
import org.opennms.netmgt.poller.pollables.PollableNetwork;
import org.opennms.netmgt.poller.pollables.PollableNode;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.utils.XmlrpcUtil;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;

final class PollerEventProcessor
implements EventListener {
    private final Poller m_poller;
    private volatile DemandPollDao m_demandPollDao;

    private void createMessageSelectorAndSubscribe() {
        ArrayList<String> ueiList = new ArrayList<String>();
        ueiList.add("uei.opennms.org/nodes/nodeGainedService");
        ueiList.add("uei.opennms.org/nodes/serviceDeleted");
        ueiList.add("uei.opennms.org/nodes/interfaceReparented");
        ueiList.add("uei.opennms.org/nodes/nodeDeleted");
        ueiList.add("uei.opennms.org/nodes/duplicateNodeDeleted");
        ueiList.add("uei.opennms.org/nodes/interfaceDeleted");
        ueiList.add("uei.opennms.org/internal/poller/suspendPollingService");
        ueiList.add("uei.opennms.org/internal/poller/resumePollingService");
        ueiList.add("uei.opennms.org/internal/schedOutagesChanged");
        ueiList.add("uei.opennms.org/internal/demandPollService");
        ueiList.add("uei.opennms.org/internal/thresholdConfigChange");
        ueiList.add("uei.opennms.org/nodes/assetInfoChanged");
        ueiList.add("uei.opennms.org/nodes/nodeCategoryMembershipChanged");
        this.getEventManager().addEventListener(this, ueiList);
    }

    private void nodeGainedServiceHandler(Event event) {
        String whichEvent = "Unexpected Event: " + event.getUei() + ": ";
        if (event.getUei().equals("uei.opennms.org/nodes/nodeGainedService")) {
            whichEvent = "nodeGainedService: ";
        } else if (event.getUei().equals("uei.opennms.org/internal/poller/resumePollingService")) {
            whichEvent = "resumePollingService: ";
        }
        String ipAddr = event.getInterface();
        int nodeId = (int)event.getNodeid();
        String svcName = event.getService();
        String nodeLabel = EventUtils.getParm(event, "nodelabel");
        try {
            nodeLabel = this.getPoller().getQueryManager().getNodeLabel(nodeId);
        }
        catch (Exception e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"Unable to retrieve nodeLabel for node %d", (Object[])new Object[]{nodeId});
        }
        this.getPoller().scheduleService(nodeId, nodeLabel, ipAddr, svcName);
    }

    private void interfaceReparentedHandler(Event event) {
        LogUtils.debugf((Object)this, (String)"interfaceReparentedHandler: processing interfaceReparented event for %s", (Object[])new Object[]{event.getInterface()});
        if (event.getInterface() == null) {
            return;
        }
        String ipAddr = event.getInterface();
        String oldNodeIdStr = null;
        String newNodeIdStr = null;
        Parms parms = event.getParms();
        if (parms != null) {
            String parmName = null;
            Value parmValue = null;
            String parmContent = null;
            for (Parm parm : parms.getParmCollection()) {
                parmName = parm.getParmName();
                parmValue = parm.getValue();
                if (parmValue == null) continue;
                parmContent = parmValue.getContent();
                if (parmName.equals("oldNodeID")) {
                    oldNodeIdStr = parmContent;
                    continue;
                }
                if (!parmName.equals("newNodeID")) continue;
                newNodeIdStr = parmContent;
            }
        }
        if (oldNodeIdStr == null || newNodeIdStr == null) {
            LogUtils.errorf((Object)this, (String)"interfaceReparentedHandler: old and new nodeId parms are required, unable to process.", (Object[])new Object[0]);
            return;
        }
        try {
            PollableNode oldNode = this.getNetwork().getNode(Integer.parseInt(oldNodeIdStr));
            if (oldNode == null) {
                LogUtils.errorf((Object)this, (String)"interfaceReparentedHandler: Cannot locate old node %s belonging to interface %s", (Object[])new Object[]{oldNodeIdStr, ipAddr});
                return;
            }
            PollableNode newNode = this.getNetwork().getNode(Integer.parseInt(newNodeIdStr));
            if (newNode == null) {
                LogUtils.errorf((Object)this, (String)"interfaceReparentedHandler: Cannot locate new node %s to move interface to.  Also, grammar error: ended a sentence with a preposition.", (Object[])new Object[]{newNodeIdStr});
                return;
            }
            PollableInterface iface = oldNode.getInterface(InetAddress.getByName(ipAddr));
            if (iface == null) {
                LogUtils.errorf((Object)this, (String)"interfaceReparentedHandler: Cannot locate interface with ipAddr %s to reparent.", (Object[])new Object[]{ipAddr});
                return;
            }
            iface.reparentTo(newNode);
        }
        catch (NumberFormatException nfe) {
            LogUtils.errorf((Object)this, (String)"interfaceReparentedHandler: failed converting old/new nodeid parm to integer, unable to process.", (Object[])new Object[0]);
            return;
        }
        catch (UnknownHostException e) {
            LogUtils.errorf((Object)this, (String)"interfaceReparentedHandler: failed converting ipAddr %s to an inet address.", (Object[])new Object[]{ipAddr});
            return;
        }
    }

    private void nodeRemovePollableServiceHandler(Event event) {
        InetAddress address;
        int nodeId = (int)event.getNodeid();
        String ipAddr = event.getInterface();
        String svcName = event.getService();
        try {
            address = InetAddress.getByName(ipAddr);
        }
        catch (UnknownHostException e) {
            LogUtils.errorf((Object)this, (String)"Unable to convert %s to an inet address.", (Object[])new Object[]{ipAddr});
            return;
        }
        if (svcName == null) {
            LogUtils.errorf((Object)this, (String)"nodeRemovePollableServiceHandler: service name is null, ignoring event", (Object[])new Object[0]);
            return;
        }
        PollableService svc = this.getNetwork().getService(nodeId, address, svcName);
        svc.delete();
    }

    private void nodeDeletedHandler(Event event) {
        Date closeDate;
        int nodeId = (int)event.getNodeid();
        String sourceUei = event.getUei();
        long txNo = -1L;
        Parms parms = event.getParms();
        if (parms != null) {
            String parmName = null;
            Value parmValue = null;
            String parmContent = null;
            for (Parm parm : parms.getParmCollection()) {
                parmName = parm.getParmName();
                parmValue = parm.getValue();
                if (parmValue == null) continue;
                parmContent = parmValue.getContent();
                if (!parmName.equals("txno")) continue;
                String temp = parmContent;
                LogUtils.debugf((Object)this, (String)"nodeDeletedHandler:  parmName: %s /parmContent: %s", (Object[])new Object[]{parmName, parmContent});
                try {
                    txNo = Long.valueOf(temp);
                }
                catch (NumberFormatException nfe) {
                    LogUtils.warnf((Object)this, (Throwable)nfe, (String)"nodeDeletedHandler: Parameter %s cannot be non-numeric", (Object[])new Object[]{"txno"});
                    txNo = -1L;
                }
            }
        }
        try {
            closeDate = EventConstants.parseToDate((String)event.getTime());
        }
        catch (ParseException e) {
            closeDate = new Date();
        }
        this.getPoller().closeOutagesForNode(closeDate, event.getDbid(), nodeId);
        PollableNode node = this.getNetwork().getNode(nodeId);
        if (node == null) {
            LogUtils.errorf((Object)this, (String)"Nodeid %d does not exist in pollable node map, unable to delete node.", (Object[])new Object[]{nodeId});
            if (this.isXmlRPCEnabled()) {
                int status = 2;
                XmlrpcUtil.createAndSendXmlrpcNotificationEvent(txNo, sourceUei, "Node does not exist in pollable node map.", status, "OpenNMS.Poller");
            }
            return;
        }
        node.delete();
    }

    private void interfaceDeletedHandler(Event event) {
        Date closeDate;
        InetAddress addr;
        int nodeId = (int)event.getNodeid();
        String sourceUei = event.getUei();
        String ipAddr = event.getInterface();
        long txNo = -1L;
        Parms parms = event.getParms();
        if (parms != null) {
            String parmName = null;
            Value parmValue = null;
            String parmContent = null;
            for (Parm parm : parms.getParmCollection()) {
                parmName = parm.getParmName();
                parmValue = parm.getValue();
                if (parmValue == null) continue;
                parmContent = parmValue.getContent();
                if (!parmName.equals("txno")) continue;
                String temp = parmContent;
                LogUtils.debugf((Object)this, (String)"interfaceDeletedHandlerHandler:  parmName: %s /parmContent: %s", (Object[])new Object[]{parmName, parmContent});
                try {
                    txNo = Long.valueOf(temp);
                }
                catch (NumberFormatException nfe) {
                    LogUtils.warnf((Object)this, (Throwable)nfe, (String)"interfaceDeletedHandlerHandler: Parameter %s cannot be non-numberic", (Object[])new Object[]{"txno"});
                    txNo = -1L;
                }
            }
        }
        try {
            addr = InetAddress.getByName(ipAddr);
        }
        catch (UnknownHostException e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"interfaceDeletedHandler: Could not convert interface %s to InetAddress", (Object[])new Object[]{event.getInterface()});
            return;
        }
        try {
            closeDate = EventConstants.parseToDate((String)event.getTime());
        }
        catch (ParseException e) {
            closeDate = new Date();
        }
        this.getPoller().closeOutagesForInterface(closeDate, event.getDbid(), nodeId, ipAddr);
        PollableInterface iface = this.getNetwork().getInterface(nodeId, addr);
        if (iface == null) {
            LogUtils.errorf((Object)this, (String)"Interface %d/%s does not exist in pollable node map, unable to delete node.", (Object[])new Object[]{nodeId, event.getInterface()});
            if (this.isXmlRPCEnabled()) {
                int status = 2;
                XmlrpcUtil.createAndSendXmlrpcNotificationEvent(txNo, sourceUei, "Interface does not exist in pollable node map.", status, "OpenNMS.Poller");
            }
            return;
        }
        iface.delete();
    }

    private void serviceDeletedHandler(Event event) {
        Date closeDate;
        InetAddress addr;
        int nodeId = (int)event.getNodeid();
        String ipAddr = event.getInterface();
        String service = event.getService();
        try {
            addr = InetAddress.getByName(ipAddr);
        }
        catch (UnknownHostException e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"serviceDeletedHandler: Could not convert %s to an InetAddress", (Object[])new Object[]{ipAddr});
            return;
        }
        try {
            closeDate = EventConstants.parseToDate((String)event.getTime());
        }
        catch (ParseException e) {
            closeDate = new Date();
        }
        this.getPoller().closeOutagesForService(closeDate, event.getDbid(), nodeId, ipAddr, service);
        PollableService svc = this.getNetwork().getService(nodeId, addr, service);
        if (svc == null) {
            LogUtils.errorf((Object)this, (String)"Interface %d/%s does not exist in pollable node map, unable to delete node.", (Object[])new Object[]{nodeId, event.getInterface()});
            return;
        }
        svc.delete();
    }

    PollerEventProcessor(Poller poller) {
        this.m_poller = poller;
        this.createMessageSelectorAndSubscribe();
        LogUtils.debugf((Object)this, (String)"Subscribed to eventd", (Object[])new Object[0]);
    }

    public void close() {
        this.getEventManager().removeEventListener(this);
    }

    private EventIpcManager getEventManager() {
        return this.getPoller().getEventManager();
    }

    public void onEvent(Event event) {
        if (event == null) {
            return;
        }
        LogUtils.debugf((Object)this, (String)"PollerEventProcessor: received event, uei = %s", (Object[])new Object[]{event.getUei()});
        if (event.getUei().equals("uei.opennms.org/internal/schedOutagesChanged")) {
            LogUtils.infof((Object)this, (String)"Reloading poller config factory and polloutages config factory", (Object[])new Object[0]);
            this.scheduledOutagesChangeHandler();
        } else if (event.getUei().equals("uei.opennms.org/internal/thresholdConfigChange")) {
            LogUtils.infof((Object)this, (String)"Reloading thresholding configuration in pollerd", (Object[])new Object[0]);
            this.thresholdsConfigChangeHandler();
        } else if (!event.hasNodeid()) {
            LogUtils.infof((Object)this, (String)"PollerEventProcessor: no database node id found, discarding event", (Object[])new Object[0]);
        } else if (event.getUei().equals("uei.opennms.org/nodes/nodeGainedService")) {
            if (event.getInterface() == null || event.getInterface().length() == 0) {
                LogUtils.infof((Object)this, (String)"PollerEventProcessor: no interface found, discarding event", (Object[])new Object[0]);
            } else {
                this.nodeGainedServiceHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/internal/poller/resumePollingService")) {
            if (event.getInterface() == null || event.getInterface().length() == 0) {
                LogUtils.infof((Object)this, (String)"PollerEventProcessor: no interface found, cannot resume polling service, discarding event", (Object[])new Object[0]);
            } else {
                this.nodeGainedServiceHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/internal/poller/suspendPollingService")) {
            if (event.getInterface() == null || event.getInterface().length() == 0) {
                LogUtils.infof((Object)this, (String)"PollerEventProcessor: no interface found, cannot suspend polling service, discarding event", (Object[])new Object[0]);
            } else {
                this.nodeRemovePollableServiceHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/nodes/interfaceReparented")) {
            if (event.getInterface() == null || event.getInterface().length() == 0) {
                LogUtils.infof((Object)this, (String)"PollerEventProcessor: no interface found, discarding event", (Object[])new Object[0]);
            } else {
                this.interfaceReparentedHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/nodes/nodeDeleted") || event.getUei().equals("uei.opennms.org/nodes/duplicateNodeDeleted")) {
            if (event.getNodeid() < 0L) {
                LogUtils.infof((Object)this, (String)"PollerEventProcessor: no node or interface found, discarding event", (Object[])new Object[0]);
            }
            this.nodeDeletedHandler(event);
        } else if (event.getUei().equals("uei.opennms.org/nodes/interfaceDeleted")) {
            if (event.getNodeid() < 0L || event.getInterface() == null || event.getInterface().length() == 0) {
                LogUtils.infof((Object)this, (String)"PollerEventProcessor: invalid nodeid or no interface found, discarding event", (Object[])new Object[0]);
            } else {
                this.interfaceDeletedHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/nodes/serviceDeleted")) {
            if (event.getNodeid() < 0L || event.getInterface() == null || event.getInterface().length() == 0 || event.getService() == null) {
                LogUtils.infof((Object)this, (String)"PollerEventProcessor: invalid nodeid or no nodeinterface or service found, discarding event", (Object[])new Object[0]);
            } else {
                this.serviceDeletedHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/nodes/nodeCategoryMembershipChanged")) {
            if (event.getNodeid() >= 0L) {
                this.serviceReschedule(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/nodes/assetInfoChanged") && event.getNodeid() >= 0L) {
            this.serviceReschedule(event);
        }
    }

    private void serviceReschedule(Event event) {
        PollableNode pnode = this.getNetwork().getNode((int)event.getNodeid());
        Integer nodeId = (int)event.getNodeid();
        String nodeLabel = pnode.getNodeLabel();
        List<String[]> list = this.getPoller().getQueryManager().getNodeServices(nodeId);
        for (String[] row : list) {
            Date closeDate;
            InetAddress addr;
            LogUtils.debugf((Object)this, (String)" Removing the following from the list: %s:%s", (Object[])new Object[]{row[0], row[1]});
            try {
                addr = InetAddress.getByName(row[0]);
            }
            catch (UnknownHostException e) {
                LogUtils.warnf((Object)this, (String)("Rescheduler: Could not convert " + row[0] + " to an InetAddress"), (Object[])new Object[]{e});
                return;
            }
            try {
                closeDate = EventConstants.parseToDate((String)event.getTime());
            }
            catch (ParseException e) {
                closeDate = new Date();
            }
            this.getPoller().closeOutagesForService(closeDate, event.getDbid(), nodeId, row[0], row[1]);
            PollableService svc = this.getNetwork().getService(nodeId, addr, row[1]);
            if (svc != null) {
                svc.delete();
                while (!svc.isDeleted()) {
                    LogUtils.debugf((Object)this, (String)"Waiting for the service to delete...", (Object[])new Object[0]);
                }
                continue;
            }
            LogUtils.debugf((Object)this, (String)"Service Not Found", (Object[])new Object[0]);
        }
        this.getPoller().getPollerConfig().rebuildPackageIpListMap();
        for (String[] row : list) {
            LogUtils.debugf((Object)this, (String)" Re-adding the following to the list: %s:%s", (Object[])new Object[]{row[0], row[1]});
            this.getPoller().scheduleService(nodeId, nodeLabel, row[0], row[1]);
        }
    }

    private void demandPollServiceHandler(Event e) throws InsufficientInformationException {
        EventUtils.checkNodeId(e);
        EventUtils.checkInterface(e);
        EventUtils.checkService(e);
        EventUtils.requireParm(e, "demandPollId");
        this.m_demandPollDao.get((Serializable)Integer.valueOf(EventUtils.getIntParm(e, "demandPollId", -1)));
    }

    private void scheduledOutagesChangeHandler() {
        try {
            this.getPollerConfig().update();
            this.getPoller().getPollOutagesConfig().update();
        }
        catch (Exception e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"Failed to reload PollerConfigFactory", (Object[])new Object[0]);
        }
        this.getPoller().refreshServicePackages();
    }

    private void thresholdsConfigChangeHandler() {
        this.getPoller().refreshServiceThresholds();
    }

    public String getName() {
        return "Poller:PollerEventProcessor";
    }

    private Poller getPoller() {
        return this.m_poller;
    }

    private PollerConfig getPollerConfig() {
        return this.getPoller().getPollerConfig();
    }

    private PollableNetwork getNetwork() {
        return this.getPoller().getNetwork();
    }

    private boolean isXmlRPCEnabled() {
        return this.getPollerConfig().getXmlrpc();
    }
}

